/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.WrappedHandler;
import com.Infinity.Nexus.Core.block.entity.common.SetMachineLevel;
import com.Infinity.Nexus.Core.block.entity.common.SetUpgradeLevel;
import com.Infinity.Nexus.Core.utils.ModEnergyStorage;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.custom.Squeezer;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.wrappedHandlerMap.SqueezerHandler;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.recipe.SqueezerRecipes;
import com.Infinity.Nexus.Mod.screen.squeezer.SqueezerMenu;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqueezerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            SqueezerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
                case 3 -> false;
                case 4, 5, 6, 7 -> ModUtils.isUpgrade((ItemStack)stack);
                case 8 -> ModUtils.isComponent((ItemStack)stack);
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int FLUID_SLOT = 2;
    private static final int OUTPUT_FLUID_SLOT = 3;
    private static final int[] UPGRADE_SLOTS = new int[]{4, 5, 6, 7};
    private static final int COMPONENT_SLOT = 8;
    private static final int capacity = 60000;
    private static final int maxTransfer = 640;
    private static final int fluidCapacity = 5000;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private final FluidTank FLUID_STORAGE = this.createFluidStorage();
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SqueezerHandler.extract(i, Direction.UP), SqueezerHandler::insert)), Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SqueezerHandler.extract(i, Direction.DOWN), SqueezerHandler::insert)), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SqueezerHandler.extract(i, Direction.NORTH), SqueezerHandler::insert)), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SqueezerHandler.extract(i, Direction.SOUTH), SqueezerHandler::insert)), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SqueezerHandler.extract(i, Direction.EAST), SqueezerHandler::insert)), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> SqueezerHandler.extract(i, Direction.WEST), SqueezerHandler::insert)));
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress;
    public ItemStack recipeOutput = ItemStack.f_41583_;

    private FluidTank createFluidStorage() {
        return new FluidTank(5000){

            public void onContentsChanged() {
                SqueezerBlockEntity.this.m_6596_();
                if (!SqueezerBlockEntity.this.f_58857_.m_5776_()) {
                    SqueezerBlockEntity.this.f_58857_.m_7260_(SqueezerBlockEntity.this.m_58899_(), SqueezerBlockEntity.this.m_58900_(), SqueezerBlockEntity.this.m_58900_(), 3);
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                return true;
            }
        };
    }

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(60000, 640){

            public void onEnergyChanged() {
                SqueezerBlockEntity.this.m_6596_();
                SqueezerBlockEntity.this.m_58904_().m_7260_(SqueezerBlockEntity.this.m_58899_(), SqueezerBlockEntity.this.m_58900_(), SqueezerBlockEntity.this.m_58900_(), 3);
            }
        };
    }

    public SqueezerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SQUEEZER_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> SqueezerBlockEntity.this.progress;
                    case 1 -> SqueezerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        SqueezerBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        SqueezerBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)Squeezer.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.ENERGY_STORAGE);
        this.lazyFluidHandler = LazyOptional.of(() -> this.FLUID_STORAGE);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.infinity_nexus_mod.squeezer").m_130946_(" LV " + this.getMachineLevel());
    }

    public static int getComponentSlot() {
        return 8;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SqueezerMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public static long getFluidCapacity() {
        return 5000L;
    }

    public void setEnergyLevel(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("squeezer.progress", this.progress);
        pTag.m_128405_("squeezer.energy", this.ENERGY_STORAGE.getEnergyStored());
        pTag = this.FLUID_STORAGE.writeToNBT(pTag);
        pTag.m_128365_("recipeOutput", (Tag)this.recipeOutput.serializeNBT());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("squeezer.progress");
        this.ENERGY_STORAGE.setEnergy(pTag.m_128451_("squeezer.energy"));
        this.FLUID_STORAGE.readFromNBT(pTag);
        this.recipeOutput = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("recipeOutput"));
    }

    public ItemStack getResultItem() {
        return this.recipeOutput;
    }

    public FluidStack getFluid() {
        return this.FLUID_STORAGE.getFluid();
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        try {
            if (pLevel.f_46443_) {
                return;
            }
            this.fillUpOnFluid(2);
            int machineLevel = this.getMachineLevel() - 1 <= 0 ? 0 : this.getMachineLevel() - 1;
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Squeezer.LIT, (Comparable)Integer.valueOf(machineLevel)), 3);
            if (this.isRedstonePowered(pPos)) {
                return;
            }
            if (!this.hasRecipe()) {
                this.resetProgress();
                return;
            }
            this.setMaxProgress(machineLevel);
            if (!this.hasEnoughEnergy()) {
                return;
            }
            if (!this.canInsertOutputFluid()) {
                return;
            }
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Squeezer.LIT, (Comparable)Integer.valueOf(machineLevel + 9)), 3);
            this.increaseCraftingProgress();
            this.extractEnergy(this);
            SqueezerBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                ModUtils.ejectItemsWhePusher((BlockPos)pPos.m_7494_(), (int[])UPGRADE_SLOTS, (int[])new int[]{1}, (ItemStackHandler)this.itemHandler, (Level)pLevel);
                this.resetProgress();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean canInsertOutputFluid() {
        return this.FLUID_STORAGE.getSpace() >= this.getCurrentRecipe().get().getFluid().getAmount() && this.FLUID_STORAGE.getFluid().isFluidEqual(this.getCurrentRecipe().get().getFluid()) || this.FLUID_STORAGE.getFluid().isEmpty();
    }

    private void fillUpOnFluid(int fluidInputSlot) {
        try {
            ItemStack fluidStack = this.itemHandler.getStackInSlot(fluidInputSlot);
            if (fluidStack.m_41619_()) {
                return;
            }
            fluidStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
                Item patt13170$temp = fluidStack.m_41720_();
                if (patt13170$temp instanceof BucketItem) {
                    BucketItem bucketItem = (BucketItem)patt13170$temp;
                    FluidStack fluidStackToDrain = new FluidStack(this.FLUID_STORAGE.getFluid(), 1000);
                    ItemStack filledBucket = new ItemStack((ItemLike)this.FLUID_STORAGE.getFluid().getFluid().m_6859_());
                    if (this.isValidBucket(filledBucket, bucketItem)) {
                        this.FLUID_STORAGE.drain(fluidStackToDrain, IFluidHandler.FluidAction.EXECUTE);
                        this.itemHandler.insertItem(3, filledBucket, false);
                        this.itemHandler.extractItem(2, 1, false);
                        this.itemHandler.setStackInSlot(3, filledBucket);
                    }
                } else if (this.canInsertFluidOnItem((IFluidHandlerItem)iFluidHandlerItem)) {
                    FluidStack fluidStackToFill = new FluidStack(this.FLUID_STORAGE.getFluid(), 10);
                    this.FLUID_STORAGE.drain(fluidStackToFill, IFluidHandler.FluidAction.EXECUTE);
                    iFluidHandlerItem.fill(fluidStackToFill, IFluidHandler.FluidAction.EXECUTE);
                } else if (this.canInsertFluidItemInOutputSlot()) {
                    this.itemHandler.extractItem(2, 1, false);
                    this.itemHandler.setStackInSlot(3, iFluidHandlerItem.getContainer());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isValidBucket(ItemStack filledBucket, BucketItem bucketItem) {
        return !filledBucket.m_41619_() && this.itemHandler.getStackInSlot(3).m_41619_() && bucketItem == Items.f_42446_ && this.FLUID_STORAGE.getFluid().getAmount() >= 1000;
    }

    private boolean canInsertFluidItemInOutputSlot() {
        return this.itemHandler.getStackInSlot(3).m_41619_() && !this.FLUID_STORAGE.isEmpty();
    }

    private boolean canInsertFluidOnItem(IFluidHandlerItem iFluidHandlerItem) {
        return iFluidHandlerItem.getFluidInTank(0).isFluidEqual(this.FLUID_STORAGE.getFluid()) && iFluidHandlerItem.getFluidInTank(0).getAmount() < iFluidHandlerItem.getTankCapacity(0) || iFluidHandlerItem.getFluidInTank(0).isEmpty();
    }

    private void extractEnergy(SqueezerBlockEntity squeezerBlockEntity) {
        int energy = this.getCurrentRecipe().get().getEnergy();
        int machineLevel = this.getMachineLevel() + 1;
        int maxProgress = squeezerBlockEntity.maxProgress;
        int speed = ModUtils.getSpeed((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) + 1;
        int strength = ModUtils.getStrength((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) * 10;
        int var1 = (energy + machineLevel * 20) / maxProgress * (speed + machineLevel);
        int var2 = Math.multiplyExact(strength, var1 / 100);
        int extractEnergy = var1 - var2;
        squeezerBlockEntity.ENERGY_STORAGE.extractEnergy(Math.max(extractEnergy, 1), false);
    }

    private boolean hasEnoughEnergy() {
        return this.ENERGY_STORAGE.getEnergyStored() >= (this.getCurrentRecipe().get().getEnergy() + this.getMachineLevel() * 20) / this.maxProgress;
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<SqueezerRecipes> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().m_8043_(null);
        this.itemHandler.extractItem(0, recipe.get().getInputCount(), false);
        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)result.m_41720_(), this.itemHandler.getStackInSlot(1).m_41613_() + result.m_41613_()));
        ItemStack component = this.itemHandler.getStackInSlot(8);
        ModUtils.useComponent((ItemStack)component, (Level)this.f_58857_, (BlockPos)this.m_58899_());
        FluidStack fluidStack = recipe.get().getFluid();
        this.FLUID_STORAGE.fill(new FluidStack(fluidStack, fluidStack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
        if (ModUtils.getMuffler((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS) < 1) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
    }

    private boolean hasRecipe() {
        Optional<SqueezerRecipes> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            this.recipeOutput = ItemStack.f_41583_;
            return false;
        }
        ItemStack result = recipe.get().m_8043_(this.m_58904_().m_9598_());
        this.recipeOutput = result.m_41777_();
        return this.canInsertAmountIntoOutputSlot(result.m_41613_()) && this.canInsertItemIntoOutputSlot(result.m_41720_());
    }

    private int getMachineLevel() {
        return ModUtils.getComponentLevel((ItemStack)this.itemHandler.getStackInSlot(8));
    }

    private Optional<SqueezerRecipes> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)SqueezerRecipes.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private boolean canInsertItemIntoOutputSlot(Item item) {
        return this.itemHandler.getStackInSlot(1).m_41619_() || this.itemHandler.getStackInSlot(1).m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(1).m_41613_() + count <= this.itemHandler.getStackInSlot(1).m_41741_();
    }

    private boolean isRedstonePowered(BlockPos pPos) {
        return this.f_58857_.m_276867_(pPos);
    }

    private boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void setMaxProgress(int machineLevel) {
        int duration = this.getCurrentRecipe().get().getDuration();
        int halfDuration = duration / 2;
        int speedReduction = halfDuration / 16;
        int speed = ModUtils.getSpeed((ItemStackHandler)this.itemHandler, (int[])UPGRADE_SLOTS);
        int reducedDuration = speed * speedReduction;
        int reducedLevel = machineLevel * (halfDuration / 8);
        duration = duration - reducedDuration - reducedLevel;
        this.maxProgress = Math.max(duration, ConfigUtils.assembler_minimum_tick);
    }

    public static int getInputSlot() {
        return 0;
    }

    public static int getOutputSlot() {
        return 1;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void setMachineLevel(ItemStack itemStack, Player player) {
        SetMachineLevel.setMachineLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int)8, (ItemStackHandler)this.itemHandler);
    }

    public void setUpgradeLevel(ItemStack itemStack, Player player) {
        SetUpgradeLevel.setUpgradeLevel((ItemStack)itemStack, (Player)player, (BlockEntity)this, (int[])UPGRADE_SLOTS, (ItemStackHandler)this.itemHandler);
    }
}

