/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.block.entity.WrappedHandler;
import com.Infinity.Nexus.Core.items.ModItems;
import com.Infinity.Nexus.Core.utils.ModUtils;
import com.Infinity.Nexus.Mod.block.custom.Tank;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.block.entity.wrappedHandlerMap.TankHandler;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.screen.tank.TankMenu;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TankBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            TankBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1 -> {
                    if (!ModUtils.isUpgrade((ItemStack)stack) && !ModUtils.isComponent((ItemStack)stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> ModUtils.isUpgrade((ItemStack)stack);
                default -> false;
            };
        }
    };
    private static final int FLUID_SLOT = 0;
    private static final int OUTPUT_FLUID_SLOT = 1;
    private static final int FLUID_CAPACITY = ConfigUtils.tank_capacity;
    private final FluidTank FLUID_STORAGE = this.createFluidStorage();
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.empty();
    private final Map<Direction, LazyOptional<WrappedHandler>> directionWrappedHandlerMap = Map.of(Direction.UP, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> TankHandler.extract(i, Direction.UP), TankHandler::insert)), Direction.DOWN, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> TankHandler.extract(i, Direction.DOWN), TankHandler::insert)), Direction.NORTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> TankHandler.extract(i, Direction.NORTH), TankHandler::insert)), Direction.SOUTH, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> TankHandler.extract(i, Direction.SOUTH), TankHandler::insert)), Direction.EAST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> TankHandler.extract(i, Direction.EAST), TankHandler::insert)), Direction.WEST, LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.itemHandler, i -> TankHandler.extract(i, Direction.WEST), TankHandler::insert)));
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> TankBlockEntity.this.endless;
                case 1 -> TankBlockEntity.this.FLUID_STORAGE.getFluidAmount();
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    TankBlockEntity.this.endless = pValue;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int endless = 0;

    private FluidTank createFluidStorage() {
        return new FluidTank(FLUID_CAPACITY){

            public void onContentsChanged() {
                TankBlockEntity.this.m_6596_();
                if (!TankBlockEntity.this.f_58857_.m_5776_()) {
                    TankBlockEntity.this.f_58857_.m_7260_(TankBlockEntity.this.m_58899_(), TankBlockEntity.this.m_58900_(), TankBlockEntity.this.m_58900_(), 3);
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                return true;
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                int maxAllowedDrain = Math.min(maxDrain, TankBlockEntity.this.FLUID_STORAGE.getCapacity() / 2);
                if (TankBlockEntity.this.endless == 1) {
                    maxAllowedDrain = Math.min(maxAllowedDrain, TankBlockEntity.this.FLUID_STORAGE.getCapacity() / 2);
                }
                int drained = Math.min(this.fluid.getAmount(), maxAllowedDrain);
                FluidStack stack = new FluidStack(this.fluid.getFluid(), drained);
                if (action.execute() && drained > 0) {
                    this.fluid.shrink(drained);
                    this.onContentsChanged();
                    if (TankBlockEntity.this.endless == 1) {
                        this.fluid.setAmount(TankBlockEntity.this.FLUID_STORAGE.getCapacity());
                        this.onContentsChanged();
                    }
                }
                return stack;
            }
        };
    }

    public TankBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TANK_BE.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (this.directionWrappedHandlerMap.containsKey(side)) {
                Direction localDir = (Direction)this.m_58900_().m_61143_((Property)Tank.FACING);
                if (side == Direction.UP || side == Direction.DOWN) {
                    return this.directionWrappedHandlerMap.get(side).cast();
                }
                return switch (localDir) {
                    default -> this.directionWrappedHandlerMap.get(side.m_122424_()).cast();
                    case Direction.EAST -> this.directionWrappedHandlerMap.get(side.m_122427_()).cast();
                    case Direction.SOUTH -> this.directionWrappedHandlerMap.get(side).cast();
                    case Direction.WEST -> this.directionWrappedHandlerMap.get(side.m_122428_()).cast();
                };
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyFluidHandler = LazyOptional.of(() -> this.FLUID_STORAGE);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        if (!this.FLUID_STORAGE.getFluid().isEmpty()) {
            ItemStack itemStack = new ItemStack((ItemLike)this.m_58900_().m_60734_().m_5456_());
            itemStack.m_41700_("Fluid", (Tag)this.FLUID_STORAGE.getFluid().writeToNBT(new CompoundTag()));
            ItemEntity itemTank = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), itemStack);
            this.f_58857_.m_7967_((Entity)itemTank);
        } else {
            ItemEntity itemTank = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), new ItemStack((ItemLike)this.m_58900_().m_60734_().m_5456_()));
            this.f_58857_.m_7967_((Entity)itemTank);
        }
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        String endless = this.endless == 1 ? Component.m_237115_((String)"tooltip.infinity_nexus_mod.tank_endless").getString() : "";
        return Component.m_237115_((String)"block.infinity_nexus_mod.tank").m_130946_(": ").m_7220_(this.FLUID_STORAGE.getFluid().getDisplayName()).m_130946_(" ").m_130946_(endless);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new TankMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public static long getFluidCapacity() {
        return FLUID_CAPACITY;
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("tank.progress", this.endless);
        pTag = this.FLUID_STORAGE.writeToNBT(pTag);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.endless = pTag.m_128451_("tank.progress");
        this.FLUID_STORAGE.readFromNBT(pTag);
    }

    public FluidStack getFluid() {
        return this.FLUID_STORAGE.getFluid();
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        try {
            if (pLevel.f_46443_) {
                return;
            }
            this.fillUpOnFluid();
            this.ejectFluid();
            this.verifyEndless(pState, pLevel, pPos);
            TankBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void ejectFluid() {
        BlockEntity blockEntity;
        if (this.itemHandler.getStackInSlot(2).m_150930_((Item)ModItems.PUSHER_UPGRADE.get()) && !this.FLUID_STORAGE.getFluid().isEmpty() && (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) != null) {
            blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).ifPresent(iFluidHandler -> {
                FluidStack newFluid;
                int filledAmount;
                int transferAmount;
                FluidStack stack = this.FLUID_STORAGE.getFluid();
                FluidStack tankFluid = iFluidHandler.getFluidInTank(0);
                int freeSpace = iFluidHandler.getTankCapacity(0) - tankFluid.getAmount();
                if ((stack.getFluid() == tankFluid.getFluid() || tankFluid.isEmpty()) && (transferAmount = Math.min(stack.getAmount(), Math.min(freeSpace, 1000))) > 0 && (filledAmount = iFluidHandler.fill(newFluid = new FluidStack(stack.getFluid(), transferAmount), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    this.FLUID_STORAGE.drain(filledAmount, IFluidHandler.FluidAction.EXECUTE);
                }
            });
        }
    }

    private void verifyEndless(BlockState pState, Level pLevel, BlockPos pPos) {
        if (this.endless == 1 && !ConfigUtils.tank_can_endless) {
            this.endless = 0;
            if ((Integer)pState.m_61143_((Property)Tank.LIT) != 0) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Tank.LIT, (Comparable)Integer.valueOf(0)), 3);
            }
            return;
        }
        if (this.endless != 1 && ConfigUtils.tank_can_endless && this.FLUID_STORAGE.getFluid().getAmount() >= this.FLUID_STORAGE.getCapacity()) {
            boolean shouldBeEndless;
            String fluidId = this.FLUID_STORAGE.getFluid().getFluid().m_205069_().m_205785_().m_135782_().toString();
            boolean isBlacklisted = ConfigUtils.blacklist_tank_fluids.contains(fluidId);
            boolean bl = shouldBeEndless = ConfigUtils.blacklist_tank_fluids_toggle && isBlacklisted || !ConfigUtils.blacklist_tank_fluids_toggle && !isBlacklisted;
            if (shouldBeEndless) {
                this.endless = 1;
                this.FLUID_STORAGE.fill(new FluidStack(this.FLUID_STORAGE.getFluid().getFluid(), this.FLUID_STORAGE.getCapacity()), IFluidHandler.FluidAction.EXECUTE);
                if ((Integer)pState.m_61143_((Property)Tank.LIT) != 1) {
                    pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Tank.LIT, (Comparable)Integer.valueOf(1)), 3);
                }
            }
        }
        if (this.endless == 1) {
            if (this.FLUID_STORAGE.getFluid().getAmount() < this.FLUID_STORAGE.getCapacity()) {
                this.FLUID_STORAGE.fill(new FluidStack(this.FLUID_STORAGE.getFluid().getFluid(), this.FLUID_STORAGE.getCapacity()), IFluidHandler.FluidAction.EXECUTE);
            }
            if ((Integer)pState.m_61143_((Property)Tank.LIT) != 1) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)Tank.LIT, (Comparable)Integer.valueOf(1)), 3);
            }
        }
    }

    private void fillUpOnFluid() {
        if (this.hasFluidSourceInSlot(0)) {
            this.transferItemFluidToTank(0);
        }
    }

    private void transferItemFluidToTank(int fluidInputSlot) {
        this.itemHandler.getStackInSlot(fluidInputSlot).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(iFluidHandlerItem -> {
            if (this.FLUID_STORAGE.getSpace() <= 0) {
                return;
            }
            boolean isBucket = iFluidHandlerItem.getContainer().m_41720_() instanceof BucketItem;
            int transferAmount = isBucket ? 1000 : Math.min(this.FLUID_STORAGE.getSpace(), 1000);
            FluidStack simulatedDrain = iFluidHandlerItem.drain(transferAmount, IFluidHandler.FluidAction.SIMULATE);
            if (simulatedDrain.isEmpty() || simulatedDrain.getAmount() <= 0) {
                return;
            }
            FluidStack drained = iFluidHandlerItem.drain(transferAmount, IFluidHandler.FluidAction.EXECUTE);
            if (!drained.isEmpty() && drained.getAmount() > 0) {
                this.FLUID_STORAGE.fill(new FluidStack(drained.getFluid(), drained.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                if (isBucket) {
                    this.itemHandler.extractItem(0, 1, false);
                    this.itemHandler.setStackInSlot(0, Items.f_42446_.m_7968_());
                }
                this.removeContainer(iFluidHandlerItem.getContainer(), isBucket ? 0 : drained.getAmount());
            }
        });
    }

    private void removeContainer(ItemStack container, int fluid) {
        if ((fluid <= 0 || container.m_41720_() instanceof BucketItem) && this.itemHandler.getStackInSlot(1).m_41619_()) {
            this.itemHandler.extractItem(0, this.itemHandler.getStackInSlot(0).m_41613_(), false);
            this.itemHandler.setStackInSlot(1, container);
        }
    }

    private boolean hasFluidSourceInSlot(int fluidInputSlot) {
        return this.itemHandler.getStackInSlot(fluidInputSlot).m_41613_() > 0 && this.itemHandler.getStackInSlot(fluidInputSlot).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    public void fillFluidFromNBT(FluidStack stack) {
        if (!stack.isEmpty()) {
            this.FLUID_STORAGE.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public static int getInputSlot() {
        return 0;
    }

    public static int getOutputSlot() {
        return 1;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    @NotNull
    public FluidStack getRenderStack() {
        return this.FLUID_STORAGE.getFluid();
    }

    public IFluidTank getFluidTank() {
        return this.FLUID_STORAGE;
    }

    public void fillBucket(ItemStack mainHandItem, Player pPlayer, Level pLevel) {
        if (mainHandItem.m_150930_(Items.f_42446_.m_5456_()) && this.FLUID_STORAGE.getFluidAmount() >= 1000) {
            mainHandItem.m_41774_(1);
            this.FLUID_STORAGE.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            pPlayer.m_9236_().m_6263_(pPlayer, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 0.5f, 0.2f);
            ItemEntity itemEntity = new ItemEntity(pLevel, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), new ItemStack((ItemLike)this.FLUID_STORAGE.getFluid().getFluid().m_6859_()));
            pLevel.m_7967_((Entity)itemEntity);
        }
    }
}

