/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Mod.block.entity.TranslocatorBlockEntityBase;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.utils.ModUtilsMachines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.Nullable;

public class TranslocatorBlockEntity
extends TranslocatorBlockEntityBase {
    public TranslocatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState);
    }

    @Override
    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_5776_()) {
            return;
        }
        if (this.mode == 0 && !this.isInputSlotEmpty()) {
            if (this.hasProgressFinished()) {
                this.depositItem(pLevel, pPos);
            } else {
                this.increaseProgress();
            }
        } else if (this.canSend()) {
            if (!this.isInputSlotEmpty()) {
                if (this.hasProgressFinished()) {
                    this.resetProgress();
                    this.sendItem(pLevel);
                    this.upgradeStep();
                }
                this.increaseProgress();
            } else {
                if (this.hasProgressFinished() && this.isInputSlotEmpty()) {
                    this.resetProgress();
                    this.pullItem(pLevel, pPos, pState);
                }
                this.increaseProgress();
            }
        }
        this.updateLit(pLevel, pState);
        TranslocatorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }

    private void pullItem(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockEntity entity = this.getInventoryPos(pLevel, pPos, pState);
        if (entity == null) {
            return;
        }
        entity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).ifPresent(handler -> {
            if (this.filter != null && this.filter.length > 0) {
                boolean itemPulled = false;
                int startIdx = this.filterIndex;
                for (int i = 0; i < this.filter.length; ++i) {
                    int currentIdx = (startIdx + i) % this.filter.length;
                    String targetItem = this.filter[currentIdx];
                    for (int slot = 0; slot < handler.getSlots(); ++slot) {
                        int amountToPull;
                        ItemStack extracted;
                        int spaceAvailable;
                        String itemName;
                        ItemStack stackInSlot = handler.getStackInSlot(slot);
                        if (stackInSlot.m_41619_() || !(itemName = stackInSlot.m_41720_().m_204114_().m_205785_().m_135782_().toString()).equals(targetItem)) continue;
                        ItemStack currentStack = this.itemHandler.getStackInSlot(0);
                        int maxStackSize = Math.min(stackInSlot.m_41741_(), this.itemHandler.getSlotLimit(0));
                        if (currentStack.m_41619_()) {
                            int amountToPull2 = Math.min(stackInSlot.m_41613_(), maxStackSize);
                            ItemStack extracted2 = handler.extractItem(slot, amountToPull2, false);
                            if (!extracted2.m_41619_()) {
                                this.itemHandler.setStackInSlot(0, extracted2);
                                this.resetProgress();
                                itemPulled = true;
                                this.filterIndex = (currentIdx + 1) % this.filter.length;
                                this.m_6596_();
                                break;
                            }
                        } else if (ItemStack.m_150942_((ItemStack)currentStack, (ItemStack)stackInSlot) && (spaceAvailable = maxStackSize - currentStack.m_41613_()) > 0 && !(extracted = handler.extractItem(slot, amountToPull = Math.min(stackInSlot.m_41613_(), spaceAvailable), false)).m_41619_()) {
                            currentStack.m_41769_(extracted.m_41613_());
                            this.itemHandler.setStackInSlot(0, currentStack);
                            this.resetProgress();
                            itemPulled = true;
                            this.filterIndex = (currentIdx + 1) % this.filter.length;
                            this.m_6596_();
                            break;
                        }
                        if (itemPulled) break;
                    }
                    if (!itemPulled) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    ItemStack stackInSlot = handler.getStackInSlot(slot);
                    if (stackInSlot.m_41619_() || !this.isFiltered(stackInSlot)) continue;
                    ItemStack currentStack = this.itemHandler.getStackInSlot(0);
                    int maxStackSize = Math.min(stackInSlot.m_41741_(), this.itemHandler.getSlotLimit(0));
                    if (currentStack.m_41619_()) {
                        int amountToPull = Math.min(stackInSlot.m_41613_(), maxStackSize);
                        ItemStack extracted = handler.extractItem(slot, amountToPull, false);
                        if (extracted.m_41619_()) continue;
                        this.itemHandler.setStackInSlot(0, extracted);
                        this.resetProgress();
                    } else {
                        int amountToPull;
                        ItemStack extracted;
                        int spaceAvailable;
                        if (!ItemStack.m_150942_((ItemStack)currentStack, (ItemStack)stackInSlot) || (spaceAvailable = maxStackSize - currentStack.m_41613_()) <= 0 || (extracted = handler.extractItem(slot, amountToPull = Math.min(stackInSlot.m_41613_(), spaceAvailable), false)).m_41619_()) continue;
                        currentStack.m_41769_(extracted.m_41613_());
                        this.itemHandler.setStackInSlot(0, currentStack);
                        this.resetProgress();
                    }
                    break;
                }
            }
        });
    }

    private void depositItem(Level level, BlockPos pos) {
        BlockEntity entity = this.getInventoryPos(level, pos, this.m_58900_());
        if (entity == null) {
            return;
        }
        entity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN).ifPresent(handler -> {
            ItemStack stackToDeposit = this.itemHandler.getStackInSlot(0);
            if (stackToDeposit.m_41619_()) {
                return;
            }
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack slotStack = handler.getStackInSlot(i);
                if (!slotStack.m_41619_() && !ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stackToDeposit) || !handler.isItemValid(i, stackToDeposit)) continue;
                int maxStackSize = Math.min(handler.getSlotLimit(i), stackToDeposit.m_41741_());
                int spaceAvailable = maxStackSize - slotStack.m_41613_();
                int toInsert = Math.min(stackToDeposit.m_41613_(), spaceAvailable);
                if (toInsert > 0) {
                    ItemStack stackToInsert = stackToDeposit.m_41620_(toInsert);
                    ItemStack leftover = handler.insertItem(i, stackToInsert, false);
                    if (!leftover.m_41619_()) {
                        stackToDeposit.m_41769_(leftover.m_41613_());
                    }
                    this.itemHandler.setStackInSlot(0, stackToDeposit);
                    this.resetProgress();
                }
                if (stackToDeposit.m_41619_()) break;
            }
        });
    }

    private void sendItem(Level level) {
        BlockPos targetPos = this.getDestination();
        BlockEntity entity = level.m_7702_(targetPos);
        if (entity instanceof TranslocatorBlockEntity) {
            TranslocatorBlockEntity translocator = (TranslocatorBlockEntity)entity;
            ItemStack stackToSend = this.itemHandler.getStackInSlot(0);
            if (stackToSend != null && !stackToSend.m_41619_()) {
                if (translocator.receiveItem(stackToSend)) {
                    this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
                    ModUtilsMachines.sendParticlePath((ServerLevel)this.m_58904_(), ParticleTypes.f_175830_, this.f_58858_, targetPos, 0.5, 0.5, 0.5);
                } else {
                    this.depositItem(level, this.f_58858_);
                    this.progress = this.maxProgress - 5;
                }
            }
        }
    }

    public boolean receiveItem(ItemStack stack) {
        if (stack.m_41619_() || !this.isInputSlotEmpty() || !this.isFiltered(stack)) {
            return false;
        }
        ItemStack currentStack = this.itemHandler.getStackInSlot(0);
        if (currentStack.m_41619_()) {
            int stackLimit = Math.min(stack.m_41741_(), this.itemHandler.getSlotLimit(0));
            ItemStack toInsert = stack.m_41777_();
            toInsert.m_41764_(Math.min(toInsert.m_41613_(), stackLimit));
            this.itemHandler.setStackInSlot(0, toInsert);
        } else if (ItemStack.m_150942_((ItemStack)currentStack, (ItemStack)stack)) {
            int maxStackSize = Math.min(currentStack.m_41741_(), this.itemHandler.getSlotLimit(0));
            int newCount = currentStack.m_41613_() + stack.m_41613_();
            if (newCount <= maxStackSize) {
                currentStack.m_41769_(stack.m_41613_());
            } else {
                int remaining = maxStackSize - currentStack.m_41613_();
                currentStack.m_41769_(remaining);
            }
            this.itemHandler.setStackInSlot(0, currentStack);
        } else {
            return false;
        }
        if (this.canSend()) {
            this.progress = ConfigUtils.translocator_skip_progress;
        }
        this.m_6596_();
        return true;
    }

    @Override
    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }
}

