/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity;

import com.Infinity.Nexus.Core.items.ModItems;
import com.Infinity.Nexus.Mod.block.custom.Translocator;
import com.Infinity.Nexus.Mod.block.entity.ModBlockEntities;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.utils.ModUtilsMachines;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslocatorBlockEntityBase
extends BlockEntity {
    protected static final int INPUT_SLOT = 0;
    protected static final int UPGRADE_SLOT = 1;
    protected int progress = 0;
    protected int maxProgress = ConfigUtils.translocator_delay;
    protected int mode = 0;
    protected int step = 0;
    protected String[] filter;
    protected int filterIndex;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TranslocatorBlockEntityBase.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> false;
                case 1 -> {
                    if (stack.m_41720_() == ModItems.PUSHER_UPGRADE.get()) {
                        yield true;
                    }
                    yield false;
                }
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> TranslocatorBlockEntityBase.this.progress;
                case 1 -> TranslocatorBlockEntityBase.this.maxProgress;
                case 2 -> TranslocatorBlockEntityBase.this.mode;
                case 3 -> TranslocatorBlockEntityBase.this.step;
                case 4 -> TranslocatorBlockEntityBase.this.filterIndex;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    TranslocatorBlockEntityBase.this.progress = pValue;
                    break;
                }
                case 1: {
                    TranslocatorBlockEntityBase.this.maxProgress = pValue;
                    break;
                }
                case 2: {
                    TranslocatorBlockEntityBase.this.mode = pValue;
                    break;
                }
                case 3: {
                    TranslocatorBlockEntityBase.this.step = pValue;
                    break;
                }
                case 4: {
                    TranslocatorBlockEntityBase.this.filterIndex = pValue;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public TranslocatorBlockEntityBase(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.TRASLOCATOR_BE.get(), pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public static int getInputSlot() {
        return 0;
    }

    public static int getUpgradeSlot() {
        return 1;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("translocator.progress", this.progress);
        pTag.m_128405_("translocator.max_progress", this.maxProgress);
        pTag.m_128405_("translocator.mode", this.mode);
        pTag.m_128405_("translocator.step", this.step);
        pTag.m_128359_("translocator.filter", this.filter == null ? "" : String.join((CharSequence)";", this.filter));
        pTag.m_128405_("translocator.filterIndex", this.filterIndex);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        this.progress = pTag.m_128451_("translocator.progress");
        this.maxProgress = pTag.m_128451_("translocator.max_progress");
        this.mode = pTag.m_128451_("translocator.mode");
        this.step = pTag.m_128451_("translocator.step");
        this.filter = pTag.m_128461_("translocator.filter").isEmpty() ? new String[]{} : pTag.m_128461_("translocator.filter").split(";");
        this.filterIndex = pTag.m_128451_("translocator.filterIndex");
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
    }

    protected boolean isFiltered(ItemStack stack) {
        if (this.filter == null || this.filter.length == 0) {
            return true;
        }
        String itemName = stack.m_41720_().m_204114_().m_205785_().m_135782_().toString();
        for (String s : this.filter) {
            if (!itemName.equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    protected void upgradeStep() {
        int[] size = this.itemHandler.getStackInSlot(1).m_41784_().m_128465_("cords");
        int steps = size.length / 3;
        this.step = this.step < steps - 1 ? ++this.step : 0;
    }

    protected boolean canLink(BlockPos pos) {
        if (this.m_58904_().m_46749_(pos)) {
            return (int)Math.sqrt(this.m_58899_().m_123331_((Vec3i)pos)) < ConfigUtils.translocator_range_limit;
        }
        return false;
    }

    protected void resetProgress() {
        this.progress = 0;
        this.maxProgress = ConfigUtils.translocator_delay;
    }

    protected void increaseProgress() {
        if (this.progress < this.maxProgress) {
            ++this.progress;
        }
    }

    protected boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    protected BlockPos getDestination() {
        int[] cords = this.getCords();
        if (cords.length == 3 && this.canLink(new BlockPos(cords[0], cords[1], cords[2]))) {
            return new BlockPos(cords[0], cords[1], cords[2]);
        }
        return this.m_58899_();
    }

    protected int[] getCords() {
        if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
            int[] cordsArray = this.itemHandler.getStackInSlot(1).m_41784_().m_128465_("cords");
            int index = this.step * 3;
            if (cordsArray.length >= 3 && index + 2 < cordsArray.length) {
                return new int[]{cordsArray[index], cordsArray[index + 1], cordsArray[index + 2]};
            }
        }
        return new int[0];
    }

    protected BlockEntity getInventoryPos(Level pLevel, BlockPos pPos, BlockState pState) {
        Direction direction = (Direction)pState.m_61143_((Property)Translocator.FACING);
        return pLevel.m_7702_(pPos.m_121945_(direction.m_122424_()));
    }

    protected boolean canSend() {
        return this.getCords().length == 3;
    }

    protected boolean isInputSlotEmpty() {
        return this.itemHandler.getStackInSlot(0).m_41619_();
    }

    protected void updateLit(Level level, BlockState state) {
        int lit = 6;
        int step = this.maxProgress / 5;
        if (this.mode == 1) {
            if (this.canSend()) {
                lit = this.progress >= 4 * step ? 5 : (this.progress >= 3 * step ? 4 : (this.progress >= 2 * step ? 3 : (this.progress >= step ? 2 : 1)));
            }
        } else if (this.mode == 0 && !this.isInputSlotEmpty()) {
            lit = this.progress <= step ? 5 : (this.progress <= 2 * step ? 4 : (this.progress <= 3 * step ? 3 : (this.progress <= 4 * step ? 2 : 1)));
        }
        this.setLit(level, state, lit);
    }

    protected void setLit(Level level, BlockState state, int lit) {
        if ((Integer)state.m_61143_((Property)Translocator.LIT) != lit) {
            level.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)Translocator.LIT, (Comparable)Integer.valueOf(lit)), 3);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }

    public void toggleMode(ItemStack stack, Player player, boolean shift, BlockPos pos) {
        if (stack.m_150930_((Item)ModItems.PUSHER_UPGRADE.get())) {
            if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
                ItemEntity entity = new ItemEntity(this.f_58857_, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.itemHandler.getStackInSlot(1));
                this.f_58857_.m_7967_((Entity)entity);
                this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
                this.mode = 0;
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").m_7220_((Component)Component.m_237115_((String)"tooltip.infinity_nexus.translocator_receive")));
            } else {
                this.itemHandler.setStackInSlot(1, stack);
                this.mode = 1;
                player.m_21205_().m_41774_(1);
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").m_7220_((Component)Component.m_237115_((String)"tooltip.infinity_nexus.translocator_send")));
            }
        } else {
            this.addItemFiler(stack, player, shift);
        }
    }

    protected void addItemFiler(ItemStack stack, Player player, boolean shift) {
        if (!stack.m_41619_() && stack.m_41720_() != ModItemsAdditions.TRANSLOCATOR_LINK.get()) {
            String itemName = stack.m_41720_().m_204114_().m_205785_().m_135782_().toString();
            if (this.filter != null && Arrays.asList(this.filter).contains(itemName)) {
                return;
            }
            if (this.filter == null) {
                this.filter = new String[]{itemName};
            } else {
                String[] newFilter = Arrays.copyOf(this.filter, this.filter.length + 1);
                newFilter[newFilter.length - 1] = itemName;
                this.filter = newFilter;
            }
        } else if (shift) {
            if (this.filter == null || this.filter.length == 0) {
                return;
            }
            String item = this.filter[this.filter.length - 1];
            ItemStack displayStack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item))));
            this.filter = Arrays.copyOf(this.filter, this.filter.length - 1);
            this.m_6596_();
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").m_7220_((Component)Component.m_237115_((String)"tooltip.infinity_nexus.translocator_filter")).m_130946_("\n \u263c \u00a7c" + displayStack.m_41786_().getString()));
        }
        MutableComponent message = Component.m_237113_((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").m_7220_((Component)Component.m_237115_((String)"tooltip.infinity_nexus.translocator_filter").m_130946_(" ").m_130940_(ChatFormatting.GOLD));
        if (this.filter == null || this.filter.length == 0) {
            message.m_7220_((Component)Component.m_237115_((String)"tooltip.infinity_nexus_mod.tank_empty"));
        } else {
            for (String item : this.filter) {
                ItemStack displayStack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item))));
                if (displayStack.m_41619_()) continue;
                MutableComponent itemComponent = Component.m_237119_().m_130946_("\n").m_130946_(" \u263c ").m_7220_((Component)displayStack.m_41786_().m_6881_().m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(displayStack)))).m_130940_(ChatFormatting.AQUA));
                message.m_7220_((Component)itemComponent);
            }
        }
        player.m_213846_((Component)message);
    }

    public void setCords(int[] cords, Player player) {
        if (this.itemHandler.getStackInSlot(1).m_150930_((Item)ModItems.PUSHER_UPGRADE.get())) {
            this.itemHandler.getStackInSlot(1).m_41784_().m_128385_("cords", cords);
            ModUtilsMachines.sendParticlePath((ServerLevel)this.m_58904_(), ParticleTypes.f_175831_, this.f_58858_, new BlockPos(cords[0], cords[1], cords[2]), 0.5, 0.5, 0.5);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").m_7220_((Component)Component.m_237115_((String)"tooltip.infinity_nexus.translocator_link")));
            this.mode = 1;
            player.m_21205_().m_41784_().m_128385_("cords", new int[]{this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_()});
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)Translocator.LIT, (Comparable)Integer.valueOf(1)), 3);
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e").m_7220_((Component)Component.m_237115_((String)"tooltip.infinity_nexus.translocator_link_fail")));
        }
    }
}

