/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.block.entity.renderer;

import com.Infinity.Nexus.Mod.block.entity.TankBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TankBlockEntityRenderer
implements BlockEntityRenderer<TankBlockEntity> {
    private final BlockEntityRendererProvider.Context context;

    public TankBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    public void render(@NotNull TankBlockEntity pBlockEntity, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        FluidStack fluidStack = pBlockEntity.getFluidTank().getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        Level level = pBlockEntity.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos pos = pBlockEntity.m_58899_();
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getStillTexture(fluidStack);
        if (stillTexture == null) {
            return;
        }
        FluidState state = fluidStack.getFluid().m_76145_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillTexture);
        int tintColor = fluidTypeExtensions.getTintColor(state, (BlockAndTintGetter)level, pos);
        float height = (float)pBlockEntity.getFluidTank().getFluidAmount() / (float)pBlockEntity.getFluidTank().getCapacity() * 0.625f + 0.25f;
        VertexConsumer builder = pBuffer.m_6299_(ItemBlockRenderTypes.m_109287_((FluidState)state));
        if (pBlockEntity.getFluidTank().getFluidAmount() < pBlockEntity.getFluidTank().getCapacity()) {
            TankBlockEntityRenderer.drawQuad(builder, pPoseStack, 0.25f, height, 0.25f, 0.75f, height, 0.75f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), pPackedLight, tintColor);
        }
        TankBlockEntityRenderer.drawQuad(builder, pPoseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), pPackedLight, tintColor);
        pPoseStack.m_85836_();
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pPoseStack.m_252880_(-1.0f, 0.0f, -1.5f);
        TankBlockEntityRenderer.drawQuad(builder, pPoseStack, 0.25f, 0.0f, 0.75f, 0.75f, height, 0.75f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), pPackedLight, tintColor);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        pPoseStack.m_252880_(-1.0f, 0.0f, 0.0f);
        TankBlockEntityRenderer.drawQuad(builder, pPoseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), pPackedLight, tintColor);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_252781_(Axis.f_252392_.m_252977_(90.0f));
        pPoseStack.m_252880_(0.0f, 0.0f, -1.0f);
        TankBlockEntityRenderer.drawQuad(builder, pPoseStack, 0.25f, 0.0f, 0.25f, 0.75f, height, 0.25f, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), pPackedLight, tintColor);
        pPoseStack.m_85849_();
    }

    private static void drawVertex(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int packedLight, int color) {
        builder.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z).m_193479_(color).m_7421_(u, v).m_85969_(packedLight).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private static void drawQuad(VertexConsumer builder, PoseStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, int packedLight, int color) {
        TankBlockEntityRenderer.drawVertex(builder, poseStack, x0, y0, z0, u0, v0, packedLight, color);
        TankBlockEntityRenderer.drawVertex(builder, poseStack, x0, y1, z1, u0, v1, packedLight, color);
        TankBlockEntityRenderer.drawVertex(builder, poseStack, x1, y1, z1, u1, v1, packedLight, color);
        TankBlockEntityRenderer.drawVertex(builder, poseStack, x1, y0, z0, u1, v0, packedLight, color);
    }
}

