/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.entity.ai;

import com.Infinity.Nexus.Mod.entity.custom.Asgreon;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class AsgreonAttackGoal
extends MeleeAttackGoal {
    private final Asgreon entity;
    private int attackDelay = 50;
    private int tickUntilNextAttack = 80;
    private boolean shouldCountTillNextAttack = false;

    public AsgreonAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        super(pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.entity = (Asgreon)pMob;
    }

    protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
        if (this.isEnemyWithinAttackDistance(pEnemy, 5.0)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttacAnimation()) {
                this.entity.setAttacking(true);
            }
            if (this.m_25564_()) {
                this.f_25540_.m_21563_().m_24946_(pEnemy.m_20185_(), pEnemy.m_20186_(), pEnemy.m_20189_());
                this.performAttack(pEnemy);
            }
        } else {
            this.m_25563_();
            this.shouldCountTillNextAttack = false;
            this.entity.setAttacking(false);
            this.entity.attackAnimationTimeout = 0;
        }
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy, double pDistToEnemySqr) {
        return pDistToEnemySqr <= this.m_6639_(pEnemy);
    }

    protected double m_6639_(LivingEntity pAttackTarget) {
        return 5.0;
    }

    protected void m_25563_() {
        this.tickUntilNextAttack = this.m_183277_(this.attackDelay * 2);
    }

    public boolean m_25564_() {
        return this.tickUntilNextAttack <= 0;
    }

    protected int m_25565_() {
        return this.tickUntilNextAttack;
    }

    private void performAttack(LivingEntity pEnemy) {
        this.m_25563_();
        this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
        this.f_25540_.m_7327_((Entity)pEnemy);
    }

    private boolean isTimeToStartAttacAnimation() {
        return this.tickUntilNextAttack <= this.attackDelay;
    }

    public void m_8056_() {
        super.m_8056_();
        this.attackDelay = 50;
        this.tickUntilNextAttack = 80;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.shouldCountTillNextAttack) {
            this.tickUntilNextAttack = Math.max(this.tickUntilNextAttack - 1, 0);
        }
    }

    public void m_8041_() {
        this.entity.setAttacking(false);
        super.m_8041_();
    }
}

