/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.events;

import com.Infinity.Nexus.Mod.command.Infuser;
import com.Infinity.Nexus.Mod.command.Teste;
import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.item.custom.HammerItem;
import com.Infinity.Nexus.Mod.item.custom.ImperialInfinityArmorItem;
import com.Infinity.Nexus.Mod.item.custom.InfinityArmorItem;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.command.ConfigCommand;

@Mod.EventBusSubscriber(modid="infinity_nexus_mod")
public class ModEvents {
    private static final Set<BlockPos> HARVESTED_BLOCKS = new HashSet<BlockPos>();

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        new Teste((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new Infuser((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onHammerUsage(BlockEvent.BreakEvent event) {
        HammerItem hammer;
        ItemStack mainHandItem;
        Player player;
        block5: {
            block4: {
                player = event.getPlayer();
                mainHandItem = player.m_21205_();
                Item item = mainHandItem.m_41720_();
                if (!(item instanceof HammerItem)) break block4;
                hammer = (HammerItem)item;
                if (player instanceof ServerPlayer) break block5;
            }
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockPos initialBlockPos = event.getPos();
        if (HARVESTED_BLOCKS.contains(initialBlockPos)) {
            return;
        }
        ModEvents.processHammerBreak(mainHandItem, hammer, initialBlockPos, serverPlayer);
    }

    private static void processHammerBreak(ItemStack mainHandItem, HammerItem hammer, BlockPos initialBlockPos, ServerPlayer serverPlayer) {
        int baseRange = mainHandItem.m_41784_().m_128451_("range");
        int effectiveRange = mainHandItem.m_41720_() == ModItemsAdditions.IMPERIAL_INFINITY_HAMMER.get() ? baseRange + 2 : baseRange + 1;
        for (BlockPos pos : HammerItem.getBlocksToBeDestroyed(effectiveRange, initialBlockPos, serverPlayer)) {
            if (pos == initialBlockPos || !hammer.isCorrectToolForDrops(mainHandItem, serverPlayer.m_9236_().m_8055_(pos))) continue;
            HARVESTED_BLOCKS.add(pos);
            serverPlayer.f_8941_.m_9280_(pos);
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            serverPlayer.m_284548_().m_8767_((ParticleOptions)ParticleTypes.f_235898_, x, y, z, 4, 0.0, 0.0, 0.0, 0.0);
            HARVESTED_BLOCKS.remove(pos);
        }
    }

    @SubscribeEvent
    public static void onArmorChange(LivingEquipmentChangeEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_9236_().m_5776_() && event.getSlot().m_20743_() == EquipmentSlot.Type.ARMOR) {
            ModEvents.checkArmorAndDisableFlight(player);
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        Player player = event.getPlayer();
        Item tossedItem = event.getEntity().m_32055_().m_41720_();
        if (!player.m_9236_().m_5776_() && (tossedItem instanceof ImperialInfinityArmorItem || tossedItem instanceof InfinityArmorItem)) {
            ModEvents.checkArmorAndDisableFlight(player);
        }
    }

    private static void checkArmorAndDisableFlight(Player player) {
    }

    public static boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack chestpiece;
        Item helmet;
        Item breastplate;
        Item leggings;
        Item boots = player.m_150109_().m_36052_(0).m_41720_();
        return ModEvents.hasFullInfinitySet(boots, leggings = player.m_150109_().m_36052_(1).m_41720_(), breastplate = player.m_150109_().m_36052_(2).m_41720_(), helmet = player.m_150109_().m_36052_(3).m_41720_(), chestpiece = player.m_150109_().m_36052_(2)) || ModEvents.hasFullImperialSet(boots, leggings, breastplate, helmet);
    }

    private static boolean hasFullInfinitySet(Item boots, Item leggings, Item breastplate, Item helmet, ItemStack fuel) {
        return boots == ModItemsAdditions.INFINITY_BOOTS.get() && leggings == ModItemsAdditions.INFINITY_LEGGINGS.get() && breastplate == ModItemsAdditions.INFINITY_CHESTPLATE.get() && helmet == ModItemsAdditions.INFINITY_HELMET.get() && fuel.m_41784_().m_128451_("Fuel") > 1;
    }

    private static boolean hasFullImperialSet(Item boots, Item leggings, Item breastplate, Item helmet) {
        return boots == ModItemsAdditions.IMPERIAL_INFINITY_BOOTS.get() && leggings == ModItemsAdditions.IMPERIAL_INFINITY_LEGGINGS.get() && breastplate == ModItemsAdditions.IMPERIAL_INFINITY_CHESTPLATE.get() && helmet == ModItemsAdditions.IMPERIAL_INFINITY_HELMET.get();
    }
}

