/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.events;

import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="infinity_nexus_mod")
public class PlayerDamageEvent {
    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            try {
                if (PlayerDamageEvent.hasFullImperialArmor(player)) {
                    Entity entity = event.getSource().m_7639_();
                    if (entity instanceof Player) {
                        Player enemy = (Player)entity;
                        ItemStack weapon = enemy.m_21205_();
                        if (!PlayerDamageEvent.isCorrectWeapon(weapon)) {
                            enemy.m_213846_((Component)Component.m_237113_((String)"\u00a7f[\u00a74I\u00a75n\u00a79fi\u00a73ni\u00a7bty\u00a7f]: \u00a7e\u00a7cYou cannot attack other players with full Imperial Armor with this weapon!"));
                            enemy.m_20282_(true);
                            enemy.m_6330_(SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            event.setCanceled(true);
                        } else {
                            float damage = event.getAmount();
                            float newDamage = damage / 100.0f * 10.0f;
                            event.setAmount(newDamage);
                        }
                    } else {
                        Entity damage = event.getSource().m_7639_();
                        if (damage instanceof Mob) {
                            Mob mob = (Mob)damage;
                            ServerPlayer target = (ServerPlayer)event.getEntity();
                            target.m_5706_((Entity)mob);
                        }
                        event.setCanceled(true);
                    }
                } else if (PlayerDamageEvent.hasFullCarbonArmor(player)) {
                    float damage = event.getAmount();
                    float hurtDamage = damage * 2.0f;
                    for (int i = 0; i < 4; ++i) {
                        int durability = player.m_150109_().m_36052_(i).m_41773_();
                        if (durability < 1) continue;
                        ItemStack part = player.m_150109_().m_36052_(i);
                        part.m_220157_((int)hurtDamage, player.m_9236_().f_46441_, null);
                    }
                    event.setAmount(damage / 2.0f);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isCorrectWeapon(ItemStack weapon) {
        return weapon.m_41720_() == ModItemsAdditions.IMPERIAL_INFINITY_SWORD.get() || weapon.m_41720_() == ModItemsAdditions.IMPERIAL_INFINITY_3D_SWORD.get() || weapon.m_41720_() == ModItemsAdditions.IMPERIAL_INFINITY_AXE.get() || weapon.m_41720_() == ModItemsAdditions.IMPERIAL_INFINITY_PAXEL.get() || weapon.m_41720_() == ModItemsAdditions.IMPERIAL_INFINITY_HAMMER.get() || weapon.m_41720_() == ModItemsAdditions.IMPERIAL_INFINITY_PICKAXE.get() || weapon.m_41720_() == ModItemsAdditions.IMPERIAL_INFINITY_SHOVEL.get() || weapon.m_41720_() == ModItemsAdditions.IMPERIAL_INFINITY_BOW.get() || weapon.m_41720_() == ModItemsAdditions.IMPERIAL_INFINITY_HOE.get();
    }

    private static boolean hasFullImperialArmor(Player player) {
        Item boots = player.m_150109_().m_36052_(0).m_41720_();
        Item leggings = player.m_150109_().m_36052_(1).m_41720_();
        Item breastplate = player.m_150109_().m_36052_(2).m_41720_();
        Item helmet = player.m_150109_().m_36052_(3).m_41720_();
        boolean armor = boots == ModItemsAdditions.IMPERIAL_INFINITY_BOOTS.get() && leggings == ModItemsAdditions.IMPERIAL_INFINITY_LEGGINGS.get() && breastplate == ModItemsAdditions.IMPERIAL_INFINITY_CHESTPLATE.get() && helmet == ModItemsAdditions.IMPERIAL_INFINITY_HELMET.get();
        return armor;
    }

    private static boolean hasFullCarbonArmor(Player player) {
        Item boots = player.m_150109_().m_36052_(0).m_41720_();
        Item leggings = player.m_150109_().m_36052_(1).m_41720_();
        Item breastplate = player.m_150109_().m_36052_(2).m_41720_();
        Item helmet = player.m_150109_().m_36052_(3).m_41720_();
        boolean armor = boots == ModItemsAdditions.CARBON_BOOTS.get() && leggings == ModItemsAdditions.CARBON_LEGGINGS.get() && breastplate == ModItemsAdditions.CARBON_CHESTPLATE.get() && helmet == ModItemsAdditions.CARBON_HELMET.get();
        return armor;
    }
}

