/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item;

import com.Infinity.Nexus.Mod.utils.ModTags;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class ModPaxelItem
extends DiggerItem
implements Vanishable {
    protected static final Map<Block, Block> BLOCK_STRIPPING_MAP = Axe.getStrippables();
    protected static final Map<Block, BlockState> SHOVEL_LOOKUP = Shovel.getFlattenables();

    public ModPaxelItem(Tier tier, float damage, float attackSpeed, Function<Item.Properties, Item.Properties> properties) {
        super(damage, attackSpeed, tier, ModTags.Blocks.PAXEL_MINEABLE, properties.apply(new Item.Properties().m_41499_((int)((double)tier.m_6609_() * 1.5))));
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_204336_(BlockTags.f_144282_) || state.m_204336_(BlockTags.f_144280_) || state.m_204336_(BlockTags.f_144283_) || state.m_204336_(ModTags.Blocks.PAXEL_MINEABLE)) {
            return this.f_40980_;
        }
        return 1.0f;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return ToolActions.DEFAULT_AXE_ACTIONS.contains(action) || ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(action) || ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(action) || ToolActions.DEFAULT_HOE_ACTIONS.contains(action);
    }

    public boolean isCorrectToolForDrops(@NotNull ItemStack stack, BlockState state) {
        return state.m_204336_(BlockTags.f_144282_) || state.m_204336_(BlockTags.f_144280_) || state.m_204336_(BlockTags.f_144283_) || state.m_204336_(ModTags.Blocks.PAXEL_MINEABLE);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState blockState = level.m_8055_(pos);
        BlockState resultToSet = null;
        Block strippedResult = BLOCK_STRIPPING_MAP.get(blockState.m_60734_());
        if (strippedResult != null) {
            level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            resultToSet = (BlockState)strippedResult.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)blockState.m_61143_((Property)RotatedPillarBlock.f_55923_)));
        } else if (context.m_43719_() != Direction.DOWN) {
            BlockState foundResult = SHOVEL_LOOKUP.get(blockState.m_60734_());
            if (foundResult != null && level.m_8055_(pos.m_7494_()).m_60795_()) {
                level.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
                resultToSet = foundResult;
            } else if (blockState.m_60734_() instanceof CampfireBlock && ((Boolean)blockState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                if (!level.m_5776_()) {
                    level.m_5898_(null, 1009, pos, 0);
                }
                resultToSet = (BlockState)blockState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
            }
        }
        if (resultToSet != null) {
            if (!level.m_5776_()) {
                level.m_7731_(pos, resultToSet, 11);
                if (player != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(context.m_43724_()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static final class Axe
    extends AxeItem {
        public static Map<Block, Block> getStrippables() {
            return AxeItem.f_150683_;
        }

        private Axe(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
            super(tier, attackDamage, attackSpeed, properties);
        }
    }

    private static final class Shovel
    extends ShovelItem {
        public static Map<Block, BlockState> getFlattenables() {
            return ShovelItem.f_43110_;
        }

        private Shovel(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
            super(tier, attackDamage, attackSpeed, properties);
        }
    }
}

