/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item.custom;

import com.Infinity.Nexus.Mod.item.ModArmorMaterials;
import com.Infinity.Nexus.Mod.item.client.parceiros.FractalArmorModel;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FractalArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation START_ANIM = RawAnimation.begin().thenPlay("animation.start").thenLoop("animation.idle");
    private static final RawAnimation FLY_START_ANIM = RawAnimation.begin().thenPlay("animation.fly_start").thenLoop("animation.flying");

    public FractalArmorItem() {
        super((ArmorMaterial)ModArmorMaterials.INFINITY, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC).m_41486_());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                FractalArmorModel.FractalArmorRenderer renderer = new FractalArmorModel.FractalArmorRenderer(stack.m_41784_().m_128461_("armorName"));
                renderer.prepForRender((Entity)entity, stack, slot, original);
                return renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "StateController", 20, this::handleAnimations)});
    }

    private PlayState handleAnimations(AnimationState<FractalArmorItem> state) {
        AnimationController controller;
        Entity entity = (Entity)state.getData(DataTickets.ENTITY);
        if (!(entity instanceof Player) && !(entity instanceof ArmorStand)) {
            return PlayState.STOP;
        }
        boolean isFlying = false;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean bl = isFlying = player.m_150110_().f_35935_ || player.m_21255_();
        }
        if ((controller = state.getController()).getAnimationState() == AnimationController.State.STOPPED) {
            controller.setAnimation(START_ANIM);
            return PlayState.CONTINUE;
        }
        controller.stop();
        if (isFlying) {
            controller.setAnimation(FLY_START_ANIM);
        } else {
            controller.setAnimation(START_ANIM);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

