/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item.custom;

import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.item.client.InfinityArmorRenderer;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class InfinityArmorItem
extends ArmorItem
implements GeoItem {
    private static final int EFFECT_DURATION = 1000;
    private static final int EFFECT_AMPLIFIER = 1;
    private static final int MAX_FOOD_LEVEL = 19;
    private static final int MAX_SATURATION = 5;
    private static final int PARTICLE_SOUND_DELAY = 250;
    private static final double PARTICLE_VELOCITY = 0.3;
    private static final double PARTICLE_Y_VELOCITY = -0.2;
    private static final double PARTICLE_RISE_VELOCITY = 0.02;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static int particleDelay;
    private static int fuel;
    private static double lastY;
    private static boolean wasFlying;
    private static boolean isFalling;

    public InfinityArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!(pEntity instanceof Player)) {
            return;
        }
        Player player = (Player)pEntity;
    }

    private void renderParticles(Player player, Level level) {
        boolean isCurrentlyFlying = player.m_150110_().f_35935_;
        if (!player.m_20096_() && !isCurrentlyFlying) {
            double currentY = player.m_20186_();
            if (currentY < lastY) {
                isFalling = true;
            }
            lastY = currentY;
        }
        if (player.m_20096_()) {
            if (isFalling || wasFlying) {
                this.handleLandingEffects(player, level);
                isFalling = false;
                wasFlying = false;
            }
            lastY = player.m_20186_();
        }
        if (isCurrentlyFlying) {
            wasFlying = true;
            this.handleFlightEffects(player, level);
        }
    }

    private void handleFlightEffects(Player player, Level pLevel) {
        double pitch = player.m_146909_();
        double yaw = -player.m_146908_() + 90.0f;
        double v = 0.3 * Math.sin(Math.toRadians(yaw));
        double x = player.m_20185_() + v;
        double y = player.m_20186_();
        double z = player.m_20189_() + 0.3 * Math.cos(Math.toRadians(yaw));
        pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 0.0, -0.2, 0.0);
        x = player.m_20185_() - v;
        z = player.m_20189_() - 0.3 * Math.cos(Math.toRadians(yaw));
        pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 0.0, -0.2, 0.0);
        if (++particleDelay >= 250) {
            particleDelay = 0;
            pLevel.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11756_, SoundSource.AMBIENT, 0.5f, 0.4f, false);
        }
    }

    private void handleLandingEffects(Player player, Level pLevel) {
        double radius = 0.5;
        double[] radii = new double[]{radius + 0.5, radius + 1.0, radius + 1.5};
        int[] stepSizes = new int[]{15, 10, 5};
        for (int i = 0; i < radii.length; ++i) {
            radius = radii[i];
            int stepSize = stepSizes[i];
            for (int j = 0; j < 360; j += stepSize) {
                double x = player.m_20185_() + radius * Math.cos(Math.toRadians(j));
                double z = player.m_20189_() + radius * Math.sin(Math.toRadians(j));
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, player.m_20186_(), z, 0.0, 0.02, 0.0);
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123815_, x, player.m_20186_(), z, 0.0, 0.02, 0.0);
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_175834_, x, player.m_20186_(), z, 0.0, 0.02, 0.0);
            }
        }
        pLevel.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12319_, SoundSource.AMBIENT, 0.5f, 0.5f, false);
        pLevel.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11874_, SoundSource.AMBIENT, 0.5f, 0.1f, false);
    }

    private boolean hasFullSuitOfArmorOn(Player player) {
        if (player == null) {
            return false;
        }
        return player.m_150109_().f_35975_.stream().allMatch(stack -> {
            if (stack.m_41619_()) {
                return false;
            }
            Item item = stack.m_41720_();
            return item == ModItemsAdditions.INFINITY_BOOTS.get() || item == ModItemsAdditions.INFINITY_LEGGINGS.get() || item == ModItemsAdditions.INFINITY_CHESTPLATE.get() || item == ModItemsAdditions.INFINITY_HELMET.get();
        });
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"item.infinity_nexus.infinity_armor"));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.infinity_nexus.pressShift"));
        }
        super.m_7373_(stack, level, components, flag);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new InfinityArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> {
            state.setAnimation(DefaultAnimations.IDLE);
            state.getController().setAnimation(RawAnimation.begin().then("misc.idle", Animation.LoopType.LOOP));
            Entity entity = (Entity)state.getData(DataTickets.ENTITY);
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            for (ItemStack stack : entity.m_6168_()) {
                if (stack.m_41619_()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.m_41720_());
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    static {
        lastY = Double.MAX_VALUE;
        wasFlying = false;
        isFalling = false;
    }
}

