/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.item.custom.orbs;

import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.item.custom.Orb;
import com.Infinity.Nexus.Mod.worldgen.dimension.ModDimensions;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class Resource
extends Orb {
    private final int range;
    List<ResourceKey<Level>> dimensions = List.of(ModDimensions.EXPLORAR_LEVEL_KEY, Level.f_46429_, Level.f_46430_);

    public Resource(Item.Properties pProperties, int stage, int range) {
        super(pProperties, stage);
        this.range = range;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        ServerLevel serverLevel;
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        if (player == null || level.m_5776_() || !player.m_6144_()) {
            return super.onItemUseFirst(stack, context);
        }
        if (!(level instanceof ServerLevel) || !this.dimensions.contains((serverLevel = (ServerLevel)level).m_46472_())) {
            player.m_213846_((Component)Component.m_237115_((String)"message.infinity_nexus.not_in_explorar"));
            return super.onItemUseFirst(stack, context);
        }
        this.performAction(context, player);
        return super.onItemUseFirst(stack, context);
    }

    private void performAction(UseOnContext context, Player player) {
        ServerLevel serverLevel = (ServerLevel)context.m_43725_();
        BlockPos center = context.m_8083_();
        int minY = -63;
        int maxY = (int)player.m_20186_();
        Queue<BlockPos> oresQueue = this.findOres(minY, maxY, center, serverLevel);
        if (oresQueue.isEmpty()) {
            player.m_213846_((Component)Component.m_237115_((String)"message.infinity_nexus.no_ores_found"));
            return;
        }
        player.m_213846_((Component)Component.m_237115_((String)"message.infinity_nexus.start_extraction"));
        player.m_21205_().m_41774_(1);
        this.processOres(oresQueue, serverLevel, player, (int)player.m_20186_() + 2);
    }

    private void processOres(Queue<BlockPos> oresQueue, ServerLevel serverLevel, Player player, int startY) {
        while (!oresQueue.isEmpty()) {
            BlockPos orePos = oresQueue.poll();
            if (!serverLevel.m_46749_(orePos)) continue;
            BlockPos surfacePos = this.findSurfacePosAbovePlayer(orePos, startY, serverLevel);
            if (surfacePos == null) {
                return;
            }
            BlockState oreState = serverLevel.m_8055_(orePos);
            if (oreState.m_60795_()) {
                return;
            }
            if (player.m_21206_().m_150930_((Item)ModItemsAdditions.IMPERIAL_INFINITY_PAXEL.get())) {
                ItemEntity oreItem = new ItemEntity((Level)serverLevel, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)oreState.m_60734_()));
                BlockState replace = orePos.m_123342_() >= 0 ? Blocks.f_50069_.m_49966_() : Blocks.f_152550_.m_49966_();
                serverLevel.m_7731_(orePos, replace, 3);
                serverLevel.m_7967_((Entity)oreItem);
                continue;
            }
            serverLevel.m_7731_(surfacePos, oreState, 3);
            BlockState replace = orePos.m_123342_() >= 0 ? Blocks.f_50069_.m_49966_() : Blocks.f_152550_.m_49966_();
            serverLevel.m_7731_(orePos, replace, 3);
        }
        player.m_213846_((Component)Component.m_237115_((String)"message.infinity_nexus.extraction_complete"));
    }

    private BlockPos findSurfacePosAbovePlayer(BlockPos orePos, int startY, ServerLevel serverLevel) {
        int maxHeight = serverLevel.m_151558_();
        BlockPos surfacePos = new BlockPos(orePos.m_123341_(), startY, orePos.m_123343_());
        while (surfacePos.m_123342_() < maxHeight && !serverLevel.m_8055_(surfacePos).m_60795_()) {
            surfacePos = surfacePos.m_7494_();
        }
        return surfacePos.m_123342_() >= maxHeight ? null : surfacePos;
    }

    private Queue<BlockPos> findOres(int minY, int maxY, BlockPos center, ServerLevel serverLevel) {
        LinkedList<BlockPos> oresQueue = new LinkedList<BlockPos>();
        for (int x = -this.range; x <= this.range; ++x) {
            for (int z = -this.range; z <= this.range; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(center.m_123341_() + x, y, center.m_123343_() + z);
                    BlockState state = serverLevel.m_8055_(pos);
                    List tags = state.m_204343_().toList();
                    if (!tags.toString().contains("forge:ores")) continue;
                    oresQueue.add(pos);
                }
            }
        }
        return oresQueue;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)"tooltip.infinity_nexus.resource_orb_description"));
        components.add((Component)Component.m_237115_((String)"tooltip.infinity_nexus.orb_range").m_7220_((Component)Component.m_237113_((String)(" " + this.range))));
        super.m_7373_(stack, level, components, flag);
    }
}

