/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.networking.packet;

import com.Infinity.Nexus.Mod.block.entity.MobCrusherBlockEntity;
import com.Infinity.Nexus.Mod.networking.ModMessages;
import com.Infinity.Nexus.Mod.networking.packet.AreaVisibilityS2CPacket;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ToggleAreaC2SPacket {
    private final BlockPos pos;
    private final boolean showArea;

    public ToggleAreaC2SPacket(BlockPos pos, boolean showArea) {
        this.pos = pos;
        this.showArea = showArea;
    }

    public ToggleAreaC2SPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.showArea = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.showArea);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            BlockEntity patt2242$temp = level.m_7702_(this.pos);
            if (patt2242$temp instanceof MobCrusherBlockEntity) {
                MobCrusherBlockEntity blockEntity = (MobCrusherBlockEntity)patt2242$temp;
                blockEntity.setShowArea(this.showArea);
                blockEntity.m_6596_();
                for (ServerPlayer nearbyPlayer : level.m_6907_()) {
                    if (!(nearbyPlayer.m_20275_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_()) < 4096.0)) continue;
                    ModMessages.sendToPlayer(new AreaVisibilityS2CPacket(this.pos, this.showArea), nearbyPlayer);
                }
                level.m_7260_(this.pos, blockEntity.m_58900_(), blockEntity.m_58900_(), 3);
            }
        });
        return true;
    }
}

