/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.block.entity.AssemblerBlockEntity;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AssemblerRecipes
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ResourceLocation id;
    private final int duration;
    private final int energy;

    public AssemblerRecipes(NonNullList<Ingredient> inputItems, ItemStack output, ResourceLocation id, int duration, int energy) {
        this.inputItems = inputItems;
        this.output = output;
        this.id = id;
        this.duration = duration;
        this.energy = energy;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        int matches = 0;
        StringBuilder verifiedSlots = new StringBuilder();
        int componentSlot = AssemblerBlockEntity.getComponentSlot();
        ItemStack stack = pContainer.m_8020_(componentSlot);
        block0: for (int i = 1; i < this.inputItems.size(); ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!((Ingredient)this.inputItems.get(i)).test(pContainer.m_8020_(j)) || verifiedSlots.toString().contains(String.valueOf(j))) continue;
                ++matches;
                verifiedSlots.append(" ").append(j);
                continue block0;
            }
        }
        if (matches < 8) {
            return false;
        }
        return ((Ingredient)this.inputItems.get(0)).test(stack);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEnergy() {
        return this.energy;
    }

    public static class Serializer
    implements RecipeSerializer<AssemblerRecipes> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("infinity_nexus_mod", "assembler");

        public AssemblerRecipes fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            int duration = pSerializedRecipe.get("duration").getAsInt();
            int energy = pSerializedRecipe.get("energy").getAsInt();
            return new AssemblerRecipes((NonNullList<Ingredient>)inputs, output, pRecipeId, duration, energy);
        }

        @Nullable
        public AssemblerRecipes fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList inputs = NonNullList.m_122780_((int)pBuffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            int duration = pBuffer.readInt();
            int energy = pBuffer.readInt();
            ItemStack output = pBuffer.m_130267_();
            return new AssemblerRecipes((NonNullList<Ingredient>)inputs, output, pRecipeId, duration, energy);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, AssemblerRecipes pRecipe) {
            pBuffer.writeInt(pRecipe.m_7527_().size());
            for (Ingredient ing : pRecipe.m_7527_()) {
                ing.m_43923_(pBuffer);
            }
            pBuffer.writeInt(pRecipe.duration);
            pBuffer.writeInt(pRecipe.energy);
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
        }
    }

    public static class Type
    implements RecipeType<AssemblerRecipes> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "assembler";
    }
}

