/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FermentationBarrelRecipes
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final int duration;
    private final FluidStack inputFluidStack;
    private final FluidStack outputFluidStack;
    private final NonNullList<Ingredient> input;
    private final int inputCount;
    private final ItemStack output;
    private final boolean recipeType;

    public FermentationBarrelRecipes(NonNullList<Ingredient> input, int inputCount, FluidStack inputFluidStack, FluidStack outputFluidStack, ItemStack output, ResourceLocation id, int duration, boolean recipeType) {
        this.id = id;
        this.duration = duration;
        this.inputFluidStack = inputFluidStack;
        this.outputFluidStack = outputFluidStack;
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.recipeType = recipeType;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        return ((Ingredient)this.input.get(0)).test(pContainer.m_8020_(2));
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.input;
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public FluidStack getInputFluidStack() {
        return this.inputFluidStack;
    }

    public FluidStack getOutputFluidStack() {
        return this.outputFluidStack;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public boolean getRecipeType() {
        return this.recipeType;
    }

    public static class Serializer
    implements RecipeSerializer<FermentationBarrelRecipes> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("infinity_nexus_mod", "fermentation");

        public FermentationBarrelRecipes fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            int inputCount = ingredients.get(0).getAsJsonObject().get("count").getAsInt();
            FluidStack inputFluid = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(pSerializedRecipe.get("fluidInputType").getAsString()))), pSerializedRecipe.get("fluidInputAmount").getAsInt());
            FluidStack outputFluid = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(pSerializedRecipe.get("fluidOutputType").getAsString()))), pSerializedRecipe.get("fluidOutputAmount").getAsInt());
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            int duration = pSerializedRecipe.get("duration").getAsInt();
            boolean type = pSerializedRecipe.get("fermenting").getAsBoolean();
            return new FermentationBarrelRecipes((NonNullList<Ingredient>)inputs, inputCount, inputFluid, outputFluid, output, pRecipeId, duration, type);
        }

        @Nullable
        public FermentationBarrelRecipes fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList inputs = NonNullList.m_122780_((int)pBuffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            int inputCount = pBuffer.readInt();
            int duration = pBuffer.readInt();
            boolean type = pBuffer.readBoolean();
            FluidStack inputFluid = pBuffer.readFluidStack();
            FluidStack outputFluid = pBuffer.readFluidStack();
            ItemStack output = pBuffer.m_130267_();
            return new FermentationBarrelRecipes((NonNullList<Ingredient>)inputs, inputCount, inputFluid, outputFluid, output, pRecipeId, duration, type);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, FermentationBarrelRecipes pRecipe) {
            pBuffer.writeInt(pRecipe.m_7527_().size());
            for (Ingredient ing : pRecipe.m_7527_()) {
                ing.m_43923_(pBuffer);
            }
            pBuffer.writeInt(pRecipe.inputCount);
            pBuffer.writeInt(pRecipe.duration);
            pBuffer.writeBoolean(pRecipe.recipeType);
            pBuffer.writeFluidStack(pRecipe.inputFluidStack);
            pBuffer.writeFluidStack(pRecipe.inputFluidStack);
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
        }
    }

    public static class Type
    implements RecipeType<FermentationBarrelRecipes> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "fermentation";
    }
}

