/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.block.entity.InfuserBlockEntity;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfuserRecipes
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final int inputCount;
    private final ItemStack output;
    private final ResourceLocation id;
    private final int[] pedestals;

    public InfuserRecipes(NonNullList<Ingredient> inputItems, int inputCount, ItemStack output, ResourceLocation id, int[] pedestals) {
        this.inputItems = inputItems;
        this.inputCount = inputCount;
        this.output = output;
        this.id = id;
        this.pedestals = pedestals;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        int inputSlot = InfuserBlockEntity.getInputSlot();
        ItemStack stack = pContainer.m_8020_(inputSlot);
        return ((Ingredient)this.inputItems.get(0)).test(stack) && pContainer.m_8020_(0).m_41613_() >= this.inputCount;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public int[] getPedestals() {
        return this.pedestals;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public static class Serializer
    implements RecipeSerializer<InfuserRecipes> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("infinity_nexus_mod", "infuser");

        public InfuserRecipes fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            int inputCount = 1;
            if (ingredients.get(0).getAsJsonObject().get("count") != null) {
                inputCount = ingredients.get(0).getAsJsonObject().get("count").getAsInt();
            }
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            inputs.set(0, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(0)));
            JsonArray pedestalArray = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"pedestals");
            int[] pedestals = new int[pedestalArray.size()];
            for (int i = 0; i < pedestalArray.size(); ++i) {
                pedestals[i] = pedestalArray.get(i).getAsInt();
            }
            return new InfuserRecipes((NonNullList<Ingredient>)inputs, inputCount, output, pRecipeId, pedestals);
        }

        @Nullable
        public InfuserRecipes fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList inputs = NonNullList.m_122780_((int)pBuffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            int inputCount = pBuffer.readInt();
            ItemStack output = pBuffer.m_130267_();
            int pedestalCount = pBuffer.readInt();
            int[] pedestals = new int[pedestalCount];
            for (int i = 0; i < pedestalCount; ++i) {
                pedestals[i] = pBuffer.readInt();
            }
            return new InfuserRecipes((NonNullList<Ingredient>)inputs, inputCount, output, pRecipeId, pedestals);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, InfuserRecipes pRecipe) {
            pBuffer.writeInt(pRecipe.m_7527_().size());
            for (Ingredient ing : pRecipe.m_7527_()) {
                ing.m_43923_(pBuffer);
            }
            pBuffer.writeInt(pRecipe.inputCount);
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
            pBuffer.writeInt(pRecipe.getPedestals().length);
            for (Object pedestal : (Object)pRecipe.getPedestals()) {
                pBuffer.writeInt((int)pedestal);
            }
        }
    }

    public static class Type
    implements RecipeType<InfuserRecipes> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "infuser";
    }
}

