/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.recipe;

import com.Infinity.Nexus.Mod.block.entity.PressBlockEntity;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PressRecipes
implements Recipe<SimpleContainer> {
    private final NonNullList<Ingredient> inputItems;
    private final int inputCount;
    private final ItemStack output;
    private final ResourceLocation id;
    private final int duration;
    private final int energy;

    public PressRecipes(NonNullList<Ingredient> inputItems, int inputCount, ItemStack output, ResourceLocation id, int duration, int energy) {
        this.inputItems = inputItems;
        this.inputCount = inputCount;
        this.output = output;
        this.id = id;
        this.duration = duration;
        this.energy = energy;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        int componentSlot = PressBlockEntity.getComponentSlot();
        ItemStack stack = pContainer.m_8020_(componentSlot);
        return ((Ingredient)this.inputItems.get(0)).test(stack) && ((Ingredient)this.inputItems.get(1)).test(pContainer.m_8020_(0)) && pContainer.m_8020_(0).m_41613_() >= this.inputCount && ((Ingredient)this.inputItems.get(2)).test(pContainer.m_8020_(1));
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<PressRecipes> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("infinity_nexus_mod", "pressing");

        @NotNull
        public PressRecipes fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            int inputCount = ingredients.get(1).getAsJsonObject().get("count").getAsInt();
            NonNullList inputs = NonNullList.m_122780_((int)3, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            int duration = pSerializedRecipe.get("duration").getAsInt();
            int energy = pSerializedRecipe.get("energy").getAsInt();
            return new PressRecipes((NonNullList<Ingredient>)inputs, inputCount, output, pRecipeId, duration, energy);
        }

        @Nullable
        public PressRecipes fromNetwork(@NotNull ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList inputs = NonNullList.m_122780_((int)pBuffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            int inputCount = pBuffer.readInt();
            int duration = pBuffer.readInt();
            int energy = pBuffer.readInt();
            ItemStack output = pBuffer.m_130267_();
            return new PressRecipes((NonNullList<Ingredient>)inputs, inputCount, output, pRecipeId, duration, energy);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, PressRecipes pRecipe) {
            pBuffer.writeInt(pRecipe.m_7527_().size());
            for (Ingredient ing : pRecipe.m_7527_()) {
                ing.m_43923_(pBuffer);
            }
            pBuffer.writeInt(pRecipe.inputCount);
            pBuffer.writeInt(pRecipe.duration);
            pBuffer.writeInt(pRecipe.energy);
            pBuffer.writeItemStack(pRecipe.m_8043_(null), false);
        }
    }

    public static class Type
    implements RecipeType<PressRecipes> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "pressing";
    }
}

