/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.assembler;

import com.Infinity.Nexus.Core.renderer.EnergyInfoArea;
import com.Infinity.Nexus.Core.renderer.FluidTankRenderer;
import com.Infinity.Nexus.Core.renderer.InfoArea;
import com.Infinity.Nexus.Core.renderer.RenderScreenTooltips;
import com.Infinity.Nexus.Core.utils.MouseUtil;
import com.Infinity.Nexus.Mod.config.ConfigUtils;
import com.Infinity.Nexus.Mod.screen.assembler.AssemblerMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.fluids.FluidStack;

public class AssemblerScreen
extends AbstractContainerScreen<AssemblerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("infinity_nexus_mod", "textures/gui/assembler_gui.png");
    private EnergyInfoArea energyInfoArea;
    private FluidTankRenderer fluidRenderer;

    public AssemblerScreen(AssemblerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = 10000;
        this.f_97729_ = 10000;
        this.assignEnergyInfoArea();
        this.assignFluidTank();
    }

    private void assignFluidTank() {
        this.fluidRenderer = new FluidTankRenderer((long)ConfigUtils.assembler_fluid_storage_capacity, true, 6, 62);
    }

    private void assignEnergyInfoArea() {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.energyInfoArea = new EnergyInfoArea(x + 159, y + 6, ((AssemblerMenu)this.f_97732_).getBlockEntity().getEnergyStorage());
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280430_(this.f_96547_, this.f_169604_, 8, 74, 0xFFFFFF);
        pGuiGraphics.m_280430_(this.f_96547_, this.f_96539_, 8, -9, 0xFFFFFF);
        this.renderEnergyAreaTooltips(pGuiGraphics, pMouseX, pMouseY, x, y);
        this.renderFluidAreaTooltips(pGuiGraphics, pMouseX, pMouseY, x, y, ((AssemblerMenu)this.f_97732_).blockEntity.getFluid(), 146, 6, this.fluidRenderer);
        this.renderTooltips(pGuiGraphics, pMouseX, pMouseY, x, y);
        InfoArea.draw((GuiGraphics)pGuiGraphics);
        super.m_280003_(pGuiGraphics, pMouseX, pMouseY);
    }

    private void renderFluidAreaTooltips(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int x, int y, FluidStack stack, int offsetX, int offsetY, FluidTankRenderer renderer) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, offsetX, offsetY, renderer)) {
            guiGraphics.m_280677_(this.f_96547_, renderer.getTooltip(stack, (TooltipFlag)TooltipFlag.Default.f_256752_), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void renderEnergyAreaTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 159, 6, 6, 62)) {
            pGuiGraphics.m_280677_(this.f_96547_, this.energyInfoArea.getTooltips(), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void renderTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (Screen.m_96638_()) {
            if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, -12, 10, 17, 53)) {
                RenderScreenTooltips.renderUpgradeSlotTooltipAndItems((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 7, 28, 17, 17)) {
                RenderScreenTooltips.renderComponentSlotTooltipAndItems((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 145, 6, 6, 62)) {
                List<MutableComponent> components = List.of(Component.m_237113_((String)"Lubricant"));
                RenderScreenTooltips.renderTooltipArea((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 124, 6, 17, 17)) {
                List<MutableComponent> components = List.of(Component.m_237113_((String)"Lubricant Input"));
                RenderScreenTooltips.renderTooltipArea((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 124, 52, 17, 17)) {
                List<MutableComponent> components = List.of(Component.m_237113_((String)"Lubricant Output"));
                RenderScreenTooltips.renderTooltipArea((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 57, 6, 17, 17) || this.isMouseAboveArea(pMouseX, pMouseY, x, y, 57, 28, 17, 17) || this.isMouseAboveArea(pMouseX, pMouseY, x, y, 57, 52, 17, 17) || this.isMouseAboveArea(pMouseX, pMouseY, x, y, 80, 6, 17, 17) || this.isMouseAboveArea(pMouseX, pMouseY, x, y, 80, 52, 17, 17) || this.isMouseAboveArea(pMouseX, pMouseY, x, y, 103, 6, 17, 17) || this.isMouseAboveArea(pMouseX, pMouseY, x, y, 103, 28, 17, 17) || this.isMouseAboveArea(pMouseX, pMouseY, x, y, 103, 52, 17, 17)) {
                List<MutableComponent> components = List.of(Component.m_237113_((String)"Input Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 80, 28, 17, 17)) {
                List<MutableComponent> components = List.of(Component.m_237113_((String)"Output Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            }
        } else {
            pGuiGraphics.m_280203_(((AssemblerMenu)this.f_97732_).blockEntity.getResultItem(), 81, 29);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (Screen.m_96638_() || this.isMouseAboveArea(pMouseX, pMouseY, x, y, -15, 10, 17, 54)) {
            RenderScreenTooltips.renderComponentSlotTooltip((GuiGraphics)guiGraphics, (ResourceLocation)TEXTURE, (int)(x - 15), (int)(y + 10), (int)193, (int)84, (int)18, (int)131);
        } else {
            RenderScreenTooltips.renderComponentSlotTooltip((GuiGraphics)guiGraphics, (ResourceLocation)TEXTURE, (int)(x - 3), (int)(y + 10), (int)193, (int)84, (int)18, (int)131);
        }
        guiGraphics.m_280218_(TEXTURE, x + 2, y - 14, 2, 167, 174, 64);
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderProgressArrow(guiGraphics, x, y);
        this.energyInfoArea.render(guiGraphics);
        this.fluidRenderer.render(guiGraphics, x + 146, y + 6, ((AssemblerMenu)this.f_97732_).blockEntity.getFluid());
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((AssemblerMenu)this.f_97732_).isCrafting()) {
            guiGraphics.m_280218_(TEXTURE, x + 58, y + 6, 176, 0, 62, ((AssemblerMenu)this.f_97732_).getScaledProgress());
            guiGraphics.m_280218_(TEXTURE, x + 58, y + 6, 176, 0, ((AssemblerMenu)this.f_97732_).getScaledProgress(), 62);
            guiGraphics.m_280218_(TEXTURE, x + 120, y + 68, 238, 62, -62, -((AssemblerMenu)this.f_97732_).getScaledProgress());
            guiGraphics.m_280218_(TEXTURE, x + 120, y + 68, 238, 62, -((AssemblerMenu)this.f_97732_).getScaledProgress(), -62);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, FluidTankRenderer renderer) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)renderer.getWidth(), (int)renderer.getHeight());
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)width, (int)height);
    }
}

