/*
 * Decompiled with CFR 0.152.
 */
package com.Infinity.Nexus.Mod.screen.mobcrusher;

import com.Infinity.Nexus.Core.items.ModItems;
import com.Infinity.Nexus.Core.renderer.EnergyInfoArea;
import com.Infinity.Nexus.Core.renderer.FluidTankRenderer;
import com.Infinity.Nexus.Core.renderer.InfoArea;
import com.Infinity.Nexus.Core.renderer.RenderScreenTooltips;
import com.Infinity.Nexus.Core.utils.MouseUtil;
import com.Infinity.Nexus.Mod.block.entity.MobCrusherBlockEntity;
import com.Infinity.Nexus.Mod.item.ModItemsAdditions;
import com.Infinity.Nexus.Mod.networking.ModMessages;
import com.Infinity.Nexus.Mod.networking.packet.ToggleAreaC2SPacket;
import com.Infinity.Nexus.Mod.screen.mobcrusher.MobCrusherMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class MobCrusherScreen
extends AbstractContainerScreen<MobCrusherMenu>
implements GuiEventListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("infinity_nexus_mod", "textures/gui/mob_crusher_gui.png");
    private static final int ENERGY_BAR_X_OFFSET = 159;
    private static final int ENERGY_BAR_Y_OFFSET = 6;
    private EnergyInfoArea energyInfoArea;
    private FluidTankRenderer fluidRenderer;
    private static boolean showArea;
    private Button areaButton;

    public MobCrusherScreen(MobCrusherMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = 10000;
        this.f_97729_ = 10000;
        this.assignEnergyInfoArea();
        this.assignFluidTank();
        this.initializeAreaButton();
    }

    private void initializeAreaButton() {
        showArea = ((MobCrusherMenu)this.f_97732_).blockEntity.shouldShowArea();
        this.areaButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)" "), this::onAreaButtonClick).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)(showArea ? "gui.infinity_nexus_mod.mob_crusher.hide_area" : "gui.infinity_nexus_mod.mob_crusher.show_area")))).m_252987_(this.f_97735_ + 151, this.f_97736_ - 10, 8, 9).m_253046_(8, 9).m_253136_());
        this.areaButton.m_93650_(0.0f);
    }

    private void onAreaButtonClick(Button button) {
        showArea = !showArea;
        System.out.println("Area: " + showArea);
        button.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(showArea ? "gui.infinity_nexus_mod.mob_crusher.hide_area" : "gui.infinity_nexus_mod.mob_crusher.show_area"))));
        ModMessages.sendToServer(new ToggleAreaC2SPacket(((MobCrusherMenu)this.f_97732_).blockEntity.m_58899_(), showArea));
    }

    private void assignFluidTank() {
        this.fluidRenderer = new FluidTankRenderer(MobCrusherBlockEntity.getFluidCapacity(), true, 6, 62);
    }

    private void assignEnergyInfoArea() {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.energyInfoArea = new EnergyInfoArea(x + 159, y + 6, ((MobCrusherMenu)this.f_97732_).getBlockEntity().getEnergyStorage());
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        this.setupRenderSystem();
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (Screen.m_96638_() || this.isMouseAboveArea(pMouseX, pMouseY, x, y, -15, 10, 17, 54)) {
            RenderScreenTooltips.renderComponentSlotTooltip((GuiGraphics)guiGraphics, (ResourceLocation)TEXTURE, (int)(x - 15), (int)(y + 10), (int)193, (int)84, (int)18, (int)131);
        } else {
            RenderScreenTooltips.renderComponentSlotTooltip((GuiGraphics)guiGraphics, (ResourceLocation)TEXTURE, (int)(x - 3), (int)(y + 10), (int)193, (int)84, (int)18, (int)131);
        }
        this.renderMainGui(guiGraphics, x, y);
        this.renderProgressArrow(guiGraphics, x, y);
        this.energyInfoArea.render(guiGraphics);
        this.fluidRenderer.render(guiGraphics, x + 146, y + 6, ((MobCrusherMenu)this.f_97732_).blockEntity.getFluid());
    }

    private void setupRenderSystem() {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
    }

    private void renderMainGui(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280218_(TEXTURE, x + 2, y - 14, 2, 167, 174, 64);
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((MobCrusherMenu)this.f_97732_).isCrafting()) {
            guiGraphics.m_280218_(TEXTURE, x + 81, y + 29, 176, 0, 16, ((MobCrusherMenu)this.f_97732_).getScaledProgress());
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int y;
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int index = y = (this.f_96544_ - this.f_97727_) / 2;
        int hasRedstoneSignal = ((MobCrusherMenu)this.f_97732_).getBlockEntity().getHasRedstoneSignal();
        int hasComponent = ((MobCrusherMenu)this.f_97732_).getBlockEntity().getHasComponent();
        int hasEnoughEnergy = ((MobCrusherMenu)this.f_97732_).getBlockEntity().getHasEnoughEnergy();
        int hasSlotFree = ((MobCrusherMenu)this.f_97732_).getBlockEntity().getHasSlotFree();
        int hasRecipe = ((MobCrusherMenu)this.f_97732_).getBlockEntity().getHasRecipe();
        String hasLink = ((MobCrusherMenu)this.f_97732_).getBlockEntity().getHasLink();
        ItemStack linkedBlock = ((MobCrusherMenu)this.f_97732_).getBlockEntity().getLikedBlock();
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        if (hasComponent == 0) {
            guiGraphics.m_280488_(this.f_96547_, "Component: [Missing]", x + 196, index, 0xFF0000);
            guiGraphics.m_280203_(new ItemStack((ItemLike)ModItems.REDSTONE_COMPONENT.get()), x + 178, index - 4);
            index += 15;
        } else {
            guiGraphics.m_280488_(this.f_96547_, "Component: [Ok]", x + 196, index, 65280);
            guiGraphics.m_280203_(new ItemStack((ItemLike)ModItems.REDSTONE_COMPONENT.get()), x + 178, index - 4);
            index += 15;
        }
        if (hasRecipe == 1) {
            guiGraphics.m_280488_(this.f_96547_, "Mobs: [Scanning]", x + 196, index, 11992832);
            guiGraphics.m_280203_(new ItemStack((ItemLike)Items.f_41960_), x + 178, index - 4);
            index += 15;
        } else {
            guiGraphics.m_280488_(this.f_96547_, "Mobs: [Scanning]", x + 196, index, 11992832);
            guiGraphics.m_280203_(new ItemStack((ItemLike)Items.f_41960_), x + 178, index - 4);
            index += 15;
        }
        if (hasComponent >= 1) {
            int range = hasComponent - 1;
            guiGraphics.m_280488_(this.f_96547_, "Range: " + (range + range + 1) + "x3x" + (range + range + 1), x + 196, index, 11992832);
            guiGraphics.m_280203_(new ItemStack((ItemLike)ModItemsAdditions.TERRAIN_MARKER.get()), x + 178, index - 4);
            index += 15;
        } else {
            guiGraphics.m_280488_(this.f_96547_, "Range: 0", x + 196, index, 11992832);
            guiGraphics.m_280203_(new ItemStack((ItemLike)ModItemsAdditions.TERRAIN_MARKER.get()), x + 178, index - 4);
            index += 15;
        }
        if (linkedBlock != null && linkedBlock.m_41720_() != Items.f_41852_) {
            guiGraphics.m_280488_(this.f_96547_, hasLink, x + 196, index, 65280);
            guiGraphics.m_280203_(linkedBlock, x + 178, index - 4);
            index += 15;
        } else {
            guiGraphics.m_280488_(this.f_96547_, hasLink, x + 196, index, 11992832);
            guiGraphics.m_280203_(new ItemStack((ItemLike)ModItems.LINKING_TOOL.get()), x + 178, index - 4);
            index += 15;
        }
    }

    private void renderFluidAreaTooltips(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int x, int y, FluidStack stack, int offsetX, int offsetY, FluidTankRenderer renderer) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, offsetX, offsetY, renderer)) {
            guiGraphics.m_280677_(this.f_96547_, renderer.getTooltip(stack, (TooltipFlag)TooltipFlag.Default.f_256752_), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void renderEnergyAreaTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 159, 6, 6, 62)) {
            pGuiGraphics.m_280677_(this.f_96547_, this.energyInfoArea.getTooltips(), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void renderTooltips(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (Screen.m_96638_()) {
            if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, -12, 10, 17, 53)) {
                RenderScreenTooltips.renderUpgradeSlotTooltipAndItems((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 7, 28, 17, 17)) {
                RenderScreenTooltips.renderComponentSlotTooltipAndItems((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 145, 6, 6, 62)) {
                List<MutableComponent> components = List.of(Component.m_237113_((String)"Experience"));
                RenderScreenTooltips.renderTooltipArea((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 79, 10, 53, 53)) {
                List<MutableComponent> components = List.of(Component.m_237113_((String)"Output Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 43, 10, 17, 17)) {
                List<MutableComponent> components = List.of(Component.m_237113_((String)"Sword Slot"));
                RenderScreenTooltips.renderTooltipArea((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, components, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 43, 28, 17, 17)) {
                List<MutableComponent> linkingTooltip = List.of(Component.m_237115_((String)"tooltip.infinity_nexus_miner.linking_slot_tooltip"));
                RenderScreenTooltips.renderTooltipArea((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, linkingTooltip, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            } else if (this.isMouseAboveArea(pMouseX, pMouseY, x, y, 43, 46, 17, 17)) {
                List<MutableComponent> fuelTooltip = List.of(Component.m_237115_((String)"tooltip.infinity_nexus_miner.fuel_slot_tooltip"));
                RenderScreenTooltips.renderTooltipArea((Font)this.f_96547_, (GuiGraphics)pGuiGraphics, fuelTooltip, (int)pMouseX, (int)pMouseY, (int)x, (int)y);
            }
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280430_(this.f_96547_, this.f_169604_, 8, 74, 0xFFFFFF);
        pGuiGraphics.m_280430_(this.f_96547_, this.f_96539_, 8, -9, 0xFFFFFF);
        this.renderEnergyAreaTooltips(pGuiGraphics, pMouseX, pMouseY, x, y);
        this.renderFluidAreaTooltips(pGuiGraphics, pMouseX, pMouseY, x, y, ((MobCrusherMenu)this.f_97732_).blockEntity.getFluid(), 146, 6, this.fluidRenderer);
        this.renderTooltips(pGuiGraphics, pMouseX, pMouseY, x, y);
        InfoArea.draw((GuiGraphics)pGuiGraphics);
        super.m_280003_(pGuiGraphics, pMouseX, pMouseY);
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, FluidTankRenderer renderer) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)renderer.getWidth(), (int)renderer.getHeight());
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver((double)pMouseX, (double)pMouseY, (int)(x + offsetX), (int)(y + offsetY), (int)width, (int)height);
    }

    public void m_7861_() {
        super.m_7861_();
        if (((MobCrusherMenu)this.f_97732_).blockEntity.shouldShowArea() != showArea) {
            ModMessages.sendToServer(new ToggleAreaC2SPacket(((MobCrusherMenu)this.f_97732_).blockEntity.m_58899_(), showArea));
        }
    }
}

