/*
 * Decompiled with CFR 0.152.
 */
package me.minecraft.plugin.betterskyblockdrops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.minecraft.plugin.betterskyblockdrops.SkyblockDropsMain;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ChristmasEvent
implements Listener {
    private final SkyblockDropsMain plugin;
    private final NamespacedKey KEY_PRESENT;
    private final NamespacedKey KEY_TIER;
    private final NamespacedKey KEY_UUID;
    private final Map<UUID, Long> clickCooldown = new HashMap<UUID, Long>();
    private final List<ItemStack> commonRewards = new ArrayList<ItemStack>();
    private final List<ItemStack> rareRewards = new ArrayList<ItemStack>();
    private final List<ItemStack> legendaryRewards = new ArrayList<ItemStack>();
    private static final ThreadLocalRandom RNG = ThreadLocalRandom.current();

    public ChristmasEvent(SkyblockDropsMain plugin) {
        this.plugin = plugin;
        this.KEY_PRESENT = new NamespacedKey((Plugin)plugin, "present_mark");
        this.KEY_TIER = new NamespacedKey((Plugin)plugin, "present_tier");
        this.KEY_UUID = new NamespacedKey((Plugin)plugin, "present_uuid");
        this.initializeRewards();
    }

    @EventHandler
    public void christmasEventSpawn(EntitySpawnEvent e) {
        boolean christmasEnabled = this.plugin.getConfig().getBoolean("christmas_event", true);
        Random random = new Random();
        if (christmasEnabled) {
            LivingEntity ent;
            if (e.getEntity() instanceof LivingEntity && ((ent = (LivingEntity)e.getEntity()).getType() == EntityType.ZOMBIE || ent.getType() == EntityType.HUSK || ent.getType() == EntityType.WITHER_SKELETON || ent.getType() == EntityType.ZOMBIFIED_PIGLIN || ent.getType() == EntityType.SKELETON)) {
                int number1 = random.nextInt(100);
                if (number1 > 85) {
                    ItemStack orangeHelmet = new ItemStack(Material.LEATHER_HELMET, 1);
                    LeatherArmorMeta orangeHelmetMeta = (LeatherArmorMeta)orangeHelmet.getItemMeta();
                    orangeHelmetMeta.setColor(Color.fromRGB((int)245, (int)116, (int)2));
                    orangeHelmet.setItemMeta((ItemMeta)orangeHelmetMeta);
                    Objects.requireNonNull(ent.getEquipment()).setHelmet(orangeHelmet);
                }
                if (number1 < 25) {
                    ItemStack greenHelmet = new ItemStack(Material.LEATHER_HELMET, 1);
                    LeatherArmorMeta greenHelmetMeta = (LeatherArmorMeta)greenHelmet.getItemMeta();
                    greenHelmetMeta.setColor(Color.fromRGB((int)102, (int)227, (int)48));
                    greenHelmet.setItemMeta((ItemMeta)greenHelmetMeta);
                    Objects.requireNonNull(ent.getEquipment()).setHelmet(greenHelmet);
                }
                if (number1 == 0 && ent.getType() == EntityType.ZOMBIE) {
                    ItemStack redHelmet = new ItemStack(Material.LEATHER_HELMET, 1);
                    LeatherArmorMeta redHelmetMeta = (LeatherArmorMeta)redHelmet.getItemMeta();
                    redHelmetMeta.setColor(Color.fromRGB((int)227, (int)34, (int)34));
                    redHelmet.setItemMeta((ItemMeta)redHelmetMeta);
                    Objects.requireNonNull(ent.getEquipment()).setHelmet(redHelmet);
                    ent.setCustomName("\u00a7cSanta Claus");
                    ent.setCustomNameVisible(true);
                    ent.setRemoveWhenFarAway(false);
                    ent.addScoreboardTag("santa_claus");
                }
            }
            if (e.getEntity() instanceof LivingEntity && ((ent = (LivingEntity)e.getEntity()).getType() == EntityType.ZOMBIE || ent.getType() == EntityType.HUSK || ent.getType() == EntityType.WITHER_SKELETON || ent.getType() == EntityType.ZOMBIFIED_PIGLIN || ent.getType() == EntityType.SKELETON)) {
                ItemMeta itemStackMeta;
                int number2 = random.nextInt(100);
                if (number2 < 30) {
                    ItemStack candies = new ItemStack(Material.SWEET_BERRIES, 1);
                    itemStackMeta = candies.getItemMeta();
                    itemStackMeta.setDisplayName(String.valueOf(ChatColor.DARK_PURPLE) + "Sweet Candies");
                    candies.setItemMeta(itemStackMeta);
                    Objects.requireNonNull(ent.getEquipment()).setItemInMainHand(candies);
                }
                if (number2 < 15) {
                    ItemStack cookies = new ItemStack(Material.COOKIE, 1);
                    itemStackMeta = cookies.getItemMeta();
                    itemStackMeta.setDisplayName(String.valueOf(ChatColor.DARK_PURPLE) + "Gingerbread Cookies");
                    cookies.setItemMeta(itemStackMeta);
                    Objects.requireNonNull(ent.getEquipment()).setItemInMainHand(cookies);
                }
            }
        }
    }

    public ItemStack createPresent(int tier) {
        ItemStack present = new ItemStack(Material.CHEST);
        ItemMeta meta = present.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Present");
            meta.setLore(Arrays.asList(String.valueOf(ChatColor.AQUA) + "Right-click to open!", String.valueOf(ChatColor.GRAY) + "What could be inside?"));
            PersistentDataContainer data = meta.getPersistentDataContainer();
            data.set(this.KEY_PRESENT, PersistentDataType.BYTE, (Object)1);
            data.set(this.KEY_TIER, PersistentDataType.BYTE, (Object)((byte)Math.max(0, Math.min(2, tier))));
            data.set(this.KEY_UUID, PersistentDataType.STRING, (Object)UUID.randomUUID().toString());
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS});
            present.setItemMeta(meta);
        }
        return present;
    }

    public ItemStack createCommonPresent() {
        return this.createPresent(0);
    }

    public ItemStack createRarePresent() {
        return this.createPresent(1);
    }

    public ItemStack createLegendaryPresent() {
        return this.createPresent(2);
    }

    private boolean isPresent(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        Byte mark = (Byte)meta.getPersistentDataContainer().get(this.KEY_PRESENT, PersistentDataType.BYTE);
        return mark != null && mark == 1;
    }

    private int getPresentTier(ItemStack item) {
        if (!this.isPresent(item)) {
            return -1;
        }
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        Byte t = (Byte)meta.getPersistentDataContainer().get(this.KEY_TIER, PersistentDataType.BYTE);
        return t == null ? 0 : Math.max(0, Math.min(2, t.byteValue()));
    }

    private boolean onCooldown(Player p) {
        long now = System.currentTimeMillis();
        Long last = this.clickCooldown.get(p.getUniqueId());
        if (last != null && now - last < 150L) {
            return true;
        }
        this.clickCooldown.put(p.getUniqueId(), now);
        return false;
    }

    private void playPresentParticles(Player p, int tier) {
        Location loc = p.getLocation().add(0.0, 1.0, 0.0);
        World w = p.getWorld();
        switch (tier) {
            case 0: {
                Particle.DustOptions red = new Particle.DustOptions(Color.fromRGB((int)200, (int)30, (int)30), 1.2f);
                Particle.DustOptions green = new Particle.DustOptions(Color.fromRGB((int)30, (int)200, (int)60), 1.2f);
                w.spawnParticle(Particle.DUST, loc, 25, 0.5, 0.6, 0.5, 0.0, (Object)red);
                w.spawnParticle(Particle.DUST, loc, 25, 0.5, 0.6, 0.5, 0.0, (Object)green);
                w.spawnParticle(Particle.FIREWORK, loc, 20, 0.4, 0.5, 0.4, 0.01);
                break;
            }
            case 1: {
                w.spawnParticle(Particle.FIREWORK, loc, 40, 0.5, 0.6, 0.5, 0.01);
                w.spawnParticle(Particle.HAPPY_VILLAGER, loc, 15, 0.4, 0.5, 0.4, 0.0);
                w.spawnParticle(Particle.END_ROD, loc, 12, 0.25, 0.35, 0.25, 0.0);
                break;
            }
            case 2: {
                w.spawnParticle(Particle.TOTEM_OF_UNDYING, loc, 40, 0.6, 0.7, 0.6, 0.0);
                w.spawnParticle(Particle.FIREWORK, loc, 60, 0.7, 0.8, 0.7, 0.02);
                w.spawnParticle(Particle.END_ROD, loc, 20, 0.3, 0.4, 0.3, 0.0);
                w.spawnParticle(Particle.EXPLOSION, loc, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void giveTo(Player p, ItemStack item) {
        HashMap overflow = p.getInventory().addItem(new ItemStack[]{item});
        overflow.values().forEach(it -> p.getWorld().dropItemNaturally(p.getLocation(), it));
    }

    @EventHandler
    public void onPresentPlace(BlockPlaceEvent e) {
        if (this.isPresent(e.getItemInHand())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPresentUse(PlayerInteractEvent e) {
        ItemStack held;
        Action a = e.getAction();
        if (a != Action.RIGHT_CLICK_AIR && a != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player p = e.getPlayer();
        EquipmentSlot hand = e.getHand();
        ItemStack itemStack = held = hand == EquipmentSlot.HAND ? p.getInventory().getItemInMainHand() : p.getInventory().getItemInOffHand();
        if (!this.isPresent(held)) {
            return;
        }
        if (this.onCooldown(p)) {
            return;
        }
        e.setUseItemInHand(Event.Result.DENY);
        e.setUseInteractedBlock(Event.Result.DENY);
        e.setCancelled(true);
        int tier = this.getPresentTier(held);
        if (held.getAmount() <= 1) {
            if (hand == EquipmentSlot.HAND) {
                p.getInventory().setItemInMainHand(null);
            } else {
                p.getInventory().setItemInOffHand(null);
            }
        } else {
            held.setAmount(held.getAmount() - 1);
            if (hand == EquipmentSlot.HAND) {
                p.getInventory().setItemInMainHand(held);
            } else {
                p.getInventory().setItemInOffHand(held);
            }
        }
        switch (tier) {
            case 2: {
                this.openLegendary(p);
                break;
            }
            case 1: {
                this.openRare(p);
                break;
            }
            default: {
                this.openCommon(p);
            }
        }
    }

    public void initializeRewards() {
        this.commonRewards.add(new ItemStack(Material.SNOWBALL, 8));
        this.commonRewards.add(new ItemStack(Material.COOKIE, 3));
        this.commonRewards.add(new ItemStack(Material.SWEET_BERRIES, 2));
        this.commonRewards.add(new ItemStack(Material.HONEY_BOTTLE, 1));
        this.commonRewards.add(new ItemStack(Material.GLOW_BERRIES, 2));
        this.commonRewards.add(new ItemStack(Material.COAL, 4));
        this.commonRewards.add(new ItemStack(Material.EMERALD, 1));
        this.commonRewards.add(new ItemStack(Material.PACKED_ICE, 3));
        this.commonRewards.add(new ItemStack(Material.SPRUCE_SAPLING, 1));
        this.commonRewards.add(new ItemStack(Material.GOLD_NUGGET, 2));
        this.commonRewards.add(new ItemStack(Material.IRON_NUGGET, 2));
        this.commonRewards.add(new ItemStack(Material.PUMPKIN_PIE, 1));
        this.commonRewards.add(new ItemStack(Material.AMETHYST_SHARD, 2));
        this.rareRewards.add(new ItemStack(Material.GOLDEN_CARROT, 4));
        this.rareRewards.add(new ItemStack(Material.LEAD, 3));
        this.rareRewards.add(new ItemStack(Material.POWDER_SNOW_BUCKET, 1));
        this.rareRewards.add(new ItemStack(Material.ICE, 12));
        this.rareRewards.add(new ItemStack(Material.TURTLE_SCUTE, 2));
        this.rareRewards.add(new ItemStack(Material.EXPERIENCE_BOTTLE, 8));
        this.rareRewards.add(new ItemStack(Material.RED_DYE, 6));
        this.rareRewards.add(new ItemStack(Material.GREEN_DYE, 6));
        this.rareRewards.add(new ItemStack(Material.DARK_OAK_SAPLING, 2));
        this.legendaryRewards.add(new ItemStack(Material.NAME_TAG, 3));
        this.legendaryRewards.add(new ItemStack(Material.NETHER_STAR, 1));
        this.legendaryRewards.add(new ItemStack(Material.TRIDENT, 1));
        this.legendaryRewards.add(new ItemStack(Material.TOTEM_OF_UNDYING, 1));
        this.legendaryRewards.add(new ItemStack(Material.GOLDEN_APPLE, 2));
        this.legendaryRewards.add(new ItemStack(Material.ENCHANTED_GOLDEN_APPLE, 1));
    }

    private ItemStack getRandomCommonRewards() {
        if (this.commonRewards.isEmpty()) {
            return null;
        }
        int randomIndexC = ThreadLocalRandom.current().nextInt(this.commonRewards.size());
        return this.commonRewards.get(randomIndexC).clone();
    }

    private List<ItemStack> getCommonRewards(int amount) {
        ArrayList<ItemStack> randomCommonRewards = new ArrayList<ItemStack>();
        for (int i = 0; i < amount; ++i) {
            randomCommonRewards.add(this.getRandomCommonRewards());
        }
        return randomCommonRewards;
    }

    private ItemStack getRandomRareReward() {
        if (this.rareRewards.isEmpty()) {
            return null;
        }
        int randomIndexR = ThreadLocalRandom.current().nextInt(this.rareRewards.size());
        return this.rareRewards.get(randomIndexR).clone();
    }

    private List<ItemStack> getRareRewards(int amount) {
        ArrayList<ItemStack> randomRareRewards = new ArrayList<ItemStack>();
        for (int i = 0; i < amount; ++i) {
            randomRareRewards.add(this.getRandomRareReward());
        }
        return randomRareRewards;
    }

    private ItemStack getRandomLegendaryRewards() {
        if (this.legendaryRewards.isEmpty()) {
            return null;
        }
        int randomIndexC = ThreadLocalRandom.current().nextInt(this.legendaryRewards.size());
        return this.legendaryRewards.get(randomIndexC).clone();
    }

    private List<ItemStack> getLegendaryRewards(int amount) {
        ArrayList<ItemStack> randomLegendaryRewards = new ArrayList<ItemStack>();
        for (int i = 0; i < amount; ++i) {
            randomLegendaryRewards.add(this.getRandomLegendaryRewards());
        }
        return randomLegendaryRewards;
    }

    private ItemStack pickOne(List<ItemStack> pool) {
        if (pool == null || pool.isEmpty()) {
            return null;
        }
        int i = RNG.nextInt(pool.size());
        return pool.get(i).clone();
    }

    private List<ItemStack> pickMany(List<ItemStack> pool, int count) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>(Math.max(0, count));
        if (pool == null || pool.isEmpty() || count <= 0) {
            return out;
        }
        for (int k = 0; k < count; ++k) {
            out.add(this.pickOne(pool));
        }
        return out;
    }

    private void openCommon(Player p) {
        int count = RNG.nextInt(1, 3);
        List<ItemStack> items = this.pickMany(this.commonRewards, count);
        if (items.isEmpty()) {
            items = List.of(new ItemStack(Material.COOKIE, 2));
        }
        items.forEach(it -> this.giveTo(p, (ItemStack)it));
        this.playPresentParticles(p, 0);
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.0f);
    }

    private void openRare(Player p) {
        List<ItemStack> items = this.pickMany(this.rareRewards, 1);
        if (items.isEmpty()) {
            items = List.of(new ItemStack(Material.GOLDEN_CARROT, 2));
        }
        items.forEach(it -> this.giveTo(p, (ItemStack)it));
        this.playPresentParticles(p, 1);
        p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.5f);
    }

    private void openLegendary(Player p) {
        ItemStack it = this.pickOne(this.legendaryRewards);
        if (it == null) {
            it = new ItemStack(Material.DIAMOND);
        }
        this.giveTo(p, it);
        this.playPresentParticles(p, 2);
        p.playSound(p.getLocation(), Sound.ITEM_TOTEM_USE, 0.8f, 1.0f);
    }

    @EventHandler
    public void christmasEventDeath(EntityDeathEvent e) {
        boolean christmasEnabled = this.plugin.getConfig().getBoolean("christmas_event", true);
        if (!christmasEnabled) {
            return;
        }
        LivingEntity ent = e.getEntity();
        if (ent.getScoreboardTags().contains("santa_claus")) {
            e.getDrops().add(this.createLegendaryPresent());
            return;
        }
        if (Math.random() < 0.08) {
            e.getDrops().add(this.createCommonPresent());
        }
        if (Math.random() > 0.08 && Math.random() < 0.15) {
            e.getDrops().add(this.createRarePresent());
        }
    }
}

