/*
 * Decompiled with CFR 0.152.
 */
package me.minecraft.plugin.skyblockdrops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Skyblockdrops
extends JavaPlugin
implements Listener {
    private final List<ItemStack> commonRewards = new ArrayList<ItemStack>();
    private final List<ItemStack> rareRewards = new ArrayList<ItemStack>();

    public void onEnable() {
        Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_GREEN + "BetterSkyblockDrops >> Plugin has been enabled!");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        FileConfiguration config = this.getConfig();
        config.addDefault("gravel_perc", (Object)10);
        config.addDefault("gravel_amount", (Object)1);
        config.addDefault("gravel_drop", (Object)true);
        config.addDefault("sand_perc", (Object)10);
        config.addDefault("sand_amount", (Object)1);
        config.addDefault("sand_drop", (Object)true);
        config.addDefault("quartz_perc", (Object)10);
        config.addDefault("quartz_amount", (Object)1);
        config.addDefault("quartz_drop", (Object)true);
        config.addDefault("soul_sand_perc", (Object)10);
        config.addDefault("soul_sand_amount", (Object)1);
        config.addDefault("soul_sand_drop", (Object)true);
        config.addDefault("ancient_debris_perc", (Object)100);
        config.addDefault("ancient_debris_amount", (Object)4);
        config.addDefault("ancient_debris_drop", (Object)true);
        config.addDefault("magma_cream_perc", (Object)10);
        config.addDefault("magma_cream_amount", (Object)1);
        config.addDefault("magma_cream_drop", (Object)true);
        config.addDefault("glowstone_perc", (Object)10);
        config.addDefault("glowstone_amount", (Object)1);
        config.addDefault("glowstone_drop", (Object)true);
        config.addDefault("halloween_event", (Object)false);
        config.addDefault("christmas_event", (Object)false);
        this.initializeRewards();
    }

    @EventHandler
    public void onMobKill(EntityDeathEvent e) {
        int gravel_perc = this.getConfig().getInt("gravel_perc", 10);
        int gravel_amount = this.getConfig().getInt("gravel_amount", 1);
        String gravel_drop = this.getConfig().getString("gravel_drop", "true");
        int sand_perc = this.getConfig().getInt("sand_perc", 10);
        int sand_amount = this.getConfig().getInt("sand_amount", 1);
        String sand_drop = this.getConfig().getString("sand_drop", "true");
        int quartz_perc = this.getConfig().getInt("quartz_perc", 10);
        int quartz_amount = this.getConfig().getInt("quartz_amount", 1);
        String quartz_drop = this.getConfig().getString("quartz_drop", "true");
        int soul_sand_perc = this.getConfig().getInt("soul_sand_perc", 10);
        int soul_sand_amount = this.getConfig().getInt("soul_sand_amount", 1);
        String soul_sand_drop = this.getConfig().getString("soul_sand_drop", "true");
        int ancient_debris_perc = this.getConfig().getInt("ancient_debris_perc", 100);
        int ancient_debris_amount = this.getConfig().getInt("ancient_debris_amount", 4);
        String ancient_debris_drop = this.getConfig().getString("ancient_debris_drop", "true");
        int magma_cream_perc = this.getConfig().getInt("magma_cream_perc", 10);
        int magma_cream_amount = this.getConfig().getInt("magma_cream_amount", 1);
        String magma_cream_drop = this.getConfig().getString("magma_cream_drop", "true");
        int glowstone_perc = this.getConfig().getInt("glowstone_perc", 10);
        int glowstone_amount = this.getConfig().getInt("glowstone_amount", 1);
        String glowstone_drop = this.getConfig().getString("glowstone_drop", "true");
        LivingEntity ent = e.getEntity();
        Random ran = new Random();
        int num = ran.nextInt(100);
        if (ent.getType() == EntityType.ZOMBIE && gravel_drop.equals("true")) {
            if (gravel_perc > 100 || gravel_perc < 1) {
                gravel_perc = 10;
            }
            if (gravel_amount > 10 || gravel_amount < 1) {
                gravel_amount = 1;
            }
            if (num <= gravel_perc) {
                e.getDrops().add(new ItemStack(Material.GRAVEL, gravel_amount));
            }
        }
        if (ent.getType() == EntityType.HUSK && sand_drop.equals("true")) {
            if (sand_perc > 100 || sand_perc < 1) {
                sand_perc = 10;
            }
            if (sand_amount > 10 || sand_amount < 1) {
                sand_amount = 1;
            }
            if (num <= sand_perc) {
                e.getDrops().add(new ItemStack(Material.SAND, sand_amount));
            }
        }
        if (ent.getType() == EntityType.BLAZE && quartz_drop.equals("true")) {
            if (quartz_perc > 100 || quartz_perc < 1) {
                quartz_perc = 10;
            }
            if (quartz_amount > 10 || quartz_amount < 1) {
                quartz_amount = 1;
            }
            if (num <= quartz_perc) {
                e.getDrops().add(new ItemStack(Material.QUARTZ, quartz_amount));
            }
        }
        if (ent.getType() == EntityType.WITHER_SKELETON && soul_sand_drop.equals("true")) {
            if (soul_sand_perc > 100 || soul_sand_perc < 1) {
                soul_sand_perc = 10;
            }
            if (soul_sand_amount > 10 || soul_sand_amount < 1) {
                soul_sand_amount = 1;
            }
            if (num <= soul_sand_perc) {
                e.getDrops().add(new ItemStack(Material.SOUL_SAND, soul_sand_amount));
            }
        }
        if (ent.getType() == EntityType.WITHER && ancient_debris_drop.equals("true")) {
            if (ancient_debris_perc > 100 || ancient_debris_perc < 1) {
                ancient_debris_perc = 100;
            }
            if (ancient_debris_amount > 10 || ancient_debris_amount < 1) {
                ancient_debris_amount = 4;
            }
            if (num <= ancient_debris_perc) {
                e.getDrops().add(new ItemStack(Material.ANCIENT_DEBRIS, ancient_debris_amount));
            }
        }
        if (ent.getType() == EntityType.ZOMBIFIED_PIGLIN && magma_cream_drop.equals("true")) {
            if (magma_cream_perc > 100 || magma_cream_perc < 1) {
                magma_cream_perc = 10;
            }
            if (magma_cream_amount > 10 || magma_cream_amount < 1) {
                magma_cream_amount = 1;
            }
            if (num <= magma_cream_perc) {
                e.getDrops().add(new ItemStack(Material.MAGMA_CREAM, magma_cream_amount));
            }
        }
        if (ent.getType() == EntityType.SKELETON && glowstone_drop.equals("true")) {
            if (glowstone_perc > 100 || glowstone_perc < 1) {
                glowstone_perc = 10;
            }
            if (glowstone_amount > 10 || glowstone_amount < 1) {
                glowstone_amount = 1;
            }
            if (num <= glowstone_perc) {
                e.getDrops().add(new ItemStack(Material.GLOWSTONE_DUST, glowstone_amount));
            }
        }
    }

    @EventHandler
    public void halloweenEventSpawn(EntitySpawnEvent e) {
        String halloween_event = this.getConfig().getString("halloween_event", "false");
        ItemStack pumpkin = new ItemStack(Material.CARVED_PUMPKIN);
        ItemStack fancy_pumpkin = new ItemStack(Material.JACK_O_LANTERN);
        Random random = new Random();
        int number = random.nextInt(100);
        if (e.getEntity() instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)e.getEntity();
            if (halloween_event.equals("true") && (ent.getType() == EntityType.ZOMBIE || ent.getType() == EntityType.HUSK || ent.getType() == EntityType.WITHER_SKELETON || ent.getType() == EntityType.ZOMBIFIED_PIGLIN || ent.getType() == EntityType.SKELETON)) {
                if (number > 60) {
                    Objects.requireNonNull(ent.getEquipment()).setHelmet(pumpkin);
                }
                if (number < 10) {
                    Objects.requireNonNull(ent.getEquipment()).setHelmet(fancy_pumpkin);
                }
            }
        }
    }

    @EventHandler
    public void halloweenEventDeath(EntityDeathEvent e) {
        String halloween_event = this.getConfig().getString("halloween_event", "false");
        Random random = new Random();
        int number = random.nextInt(1000);
        LivingEntity ent = e.getEntity();
        if (halloween_event.equals("true") && (ent.getType() == EntityType.ZOMBIE || ent.getType() == EntityType.HUSK || ent.getType() == EntityType.BLAZE || ent.getType() == EntityType.WITHER_SKELETON || ent.getType() == EntityType.WITHER || ent.getType() == EntityType.ZOMBIFIED_PIGLIN || ent.getType() == EntityType.SKELETON) && number == 1) {
            e.getDrops().add(new ItemStack(Material.DIAMOND));
        }
    }

    @EventHandler
    public void christmasEventSpawn(EntitySpawnEvent e) {
        String christmas_event = this.getConfig().getString("christmas_event", "false");
        Random random = new Random();
        if (christmas_event.equals("true")) {
            LivingEntity ent;
            if (e.getEntity() instanceof LivingEntity && ((ent = (LivingEntity)e.getEntity()).getType() == EntityType.ZOMBIE || ent.getType() == EntityType.HUSK || ent.getType() == EntityType.WITHER_SKELETON || ent.getType() == EntityType.ZOMBIFIED_PIGLIN || ent.getType() == EntityType.SKELETON)) {
                int number1 = random.nextInt(100);
                if (number1 > 85) {
                    ItemStack redHelmet = new ItemStack(Material.LEATHER_HELMET, 1);
                    LeatherArmorMeta redHelmetMeta = (LeatherArmorMeta)redHelmet.getItemMeta();
                    redHelmetMeta.setColor(Color.fromRGB((int)255, (int)0, (int)0));
                    redHelmetMeta.setDisplayName(ChatColor.GOLD + "Santa's Hat");
                    redHelmet.setItemMeta((ItemMeta)redHelmetMeta);
                    Objects.requireNonNull(ent.getEquipment()).setHelmet(redHelmet);
                }
                if (number1 < 25) {
                    ItemStack greenHelmet = new ItemStack(Material.LEATHER_HELMET, 1);
                    LeatherArmorMeta greenHelmetMeta = (LeatherArmorMeta)greenHelmet.getItemMeta();
                    greenHelmetMeta.setColor(Color.fromRGB((int)69, (int)230, (int)0));
                    greenHelmetMeta.setDisplayName(ChatColor.DARK_PURPLE + "Santa's Helper's Hat");
                    greenHelmet.setItemMeta((ItemMeta)greenHelmetMeta);
                    Objects.requireNonNull(ent.getEquipment()).setHelmet(greenHelmet);
                }
            }
            if (e.getEntity() instanceof LivingEntity && ((ent = (LivingEntity)e.getEntity()).getType() == EntityType.ZOMBIE || ent.getType() == EntityType.HUSK || ent.getType() == EntityType.WITHER_SKELETON || ent.getType() == EntityType.ZOMBIFIED_PIGLIN || ent.getType() == EntityType.SKELETON)) {
                ItemMeta itemStackMeta;
                int number2 = random.nextInt(100);
                if (number2 < 30) {
                    ItemStack candies = new ItemStack(Material.SWEET_BERRIES, 1);
                    itemStackMeta = candies.getItemMeta();
                    itemStackMeta.setDisplayName(ChatColor.DARK_PURPLE + "Sweet Candies");
                    candies.setItemMeta(itemStackMeta);
                    Objects.requireNonNull(ent.getEquipment()).setItemInMainHand(candies);
                }
                if (number2 < 15) {
                    ItemStack cookies = new ItemStack(Material.COOKIE, 1);
                    itemStackMeta = cookies.getItemMeta();
                    itemStackMeta.setDisplayName(ChatColor.DARK_PURPLE + "Gingerbread Cookies");
                    cookies.setItemMeta(itemStackMeta);
                    Objects.requireNonNull(ent.getEquipment()).setItemInMainHand(cookies);
                }
            }
        }
    }

    public ItemStack createPresent() {
        ItemStack present = new ItemStack(Material.CHEST);
        ItemMeta meta = present.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ChatColor.GOLD + "Present");
            meta.setLore(Arrays.asList(ChatColor.AQUA + "Right-click to open!", ChatColor.GRAY + "Contains a surprise!"));
            PersistentDataContainer data = meta.getPersistentDataContainer();
            data.set(new NamespacedKey((Plugin)this, "uniqueID"), PersistentDataType.STRING, (Object)UUID.randomUUID().toString());
            present.setItemMeta(meta);
        }
        return present;
    }

    private boolean isPresent(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer data = meta.getPersistentDataContainer();
        return data.has(new NamespacedKey((Plugin)this, "uniqueID"), PersistentDataType.STRING);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        Player player = e.getPlayer();
        ItemStack item = e.getItemInHand();
        if (this.isPresent(item)) {
            e.setCancelled(true);
        }
    }

    public void initializeRewards() {
        this.commonRewards.add(new ItemStack(Material.GLOW_BERRIES, 2));
        this.commonRewards.add(new ItemStack(Material.SNOWBALL, 3));
        this.commonRewards.add(new ItemStack(Material.EGG));
        this.commonRewards.add(new ItemStack(Material.WHEAT_SEEDS, 2));
        this.commonRewards.add(new ItemStack(Material.KELP));
        this.commonRewards.add(new ItemStack(Material.INK_SAC, 2));
        this.commonRewards.add(new ItemStack(Material.GLASS_BOTTLE));
        this.commonRewards.add(new ItemStack(Material.BOWL));
        this.commonRewards.add(new ItemStack(Material.SUGAR, 3));
        this.commonRewards.add(new ItemStack(Material.YELLOW_DYE));
        this.rareRewards.add(new ItemStack(Material.DIAMOND));
        this.rareRewards.add(new ItemStack(Material.ENDER_PEARL, 2));
        this.rareRewards.add(new ItemStack(Material.EMERALD, 5));
        this.rareRewards.add(new ItemStack(Material.ANCIENT_DEBRIS));
        this.rareRewards.add(new ItemStack(Material.COPPER_INGOT, 10));
        this.rareRewards.add(new ItemStack(Material.ENCHANTED_GOLDEN_APPLE));
    }

    private ItemStack getRandomCommonRewards() {
        if (this.commonRewards.isEmpty()) {
            return null;
        }
        int randomIndexC = ThreadLocalRandom.current().nextInt(this.commonRewards.size());
        return this.commonRewards.get(randomIndexC).clone();
    }

    private List<ItemStack> getCommonRewards(int amount) {
        ArrayList<ItemStack> randomCommonRewards = new ArrayList<ItemStack>();
        for (int i = 0; i < amount; ++i) {
            randomCommonRewards.add(this.getRandomCommonRewards());
        }
        return randomCommonRewards;
    }

    private ItemStack getRandomRareReward() {
        if (this.rareRewards.isEmpty()) {
            return null;
        }
        int randomIndexR = ThreadLocalRandom.current().nextInt(this.rareRewards.size());
        return this.rareRewards.get(randomIndexR).clone();
    }

    private List<ItemStack> getRareRewards(int amount) {
        ArrayList<ItemStack> randomRareRewards = new ArrayList<ItemStack>();
        for (int i = 0; i < amount; ++i) {
            randomRareRewards.add(this.getRandomRareReward());
        }
        return randomRareRewards;
    }

    @EventHandler
    public void onPlayerInteraction(PlayerInteractEvent e) {
        block2: {
            int number;
            Player player;
            block3: {
                player = e.getPlayer();
                Action action = e.getAction();
                ItemStack item = e.getItem();
                if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK || !this.isPresent(item)) break block2;
                e.setCancelled(true);
                player.getInventory().removeItem(new ItemStack[]{item});
                Random random = new Random();
                number = random.nextInt(100);
                if (number >= 85) break block3;
                int rewardCount = ThreadLocalRandom.current().nextInt(1, 3);
                List<ItemStack> randomCommonRewards = this.getCommonRewards(rewardCount);
                for (ItemStack reward : randomCommonRewards) {
                    player.getInventory().addItem(new ItemStack[]{reward});
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.0f);
                }
                break block2;
            }
            if (number <= 85) break block2;
            int rewardCount = 1;
            List<ItemStack> randomRareReward = this.getRareRewards(rewardCount);
            for (ItemStack reward : randomRareReward) {
                player.getInventory().addItem(new ItemStack[]{reward});
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.5f);
            }
        }
    }

    @EventHandler
    public void christmasEventDeath(EntityDeathEvent e) {
        String christmas_event = this.getConfig().getString("christmas_event", "false");
        if (christmas_event.equals("true") && Math.random() < 0.1) {
            e.getDrops().add(this.createPresent());
        }
    }
}

