/*
 * Decompiled with CFR 0.152.
 */
package me.minecraft.plugin.betterskyblockdrops;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.minecraft.plugin.betterskyblockdrops.BloodMoonManager;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BloodMoonListener
implements Listener {
    private final JavaPlugin plugin;
    private final BloodMoonManager manager;
    private final Map<UUID, BukkitTask> auras = new HashMap<UUID, BukkitTask>();

    private static boolean isHostile(LivingEntity e) {
        return e instanceof Monster;
    }

    public BloodMoonListener(JavaPlugin plugin, BloodMoonManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onSpawn(CreatureSpawnEvent e) {
        if (!this.plugin.getConfig().getBoolean("halloween_event", false)) {
            return;
        }
        if (this.manager == null) {
            return;
        }
        World w = e.getLocation().getWorld();
        if (w == null || !this.manager.isActive(w)) {
            return;
        }
        CreatureSpawnEvent.SpawnReason r = e.getSpawnReason();
        if (r == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            return;
        }
        LivingEntity mob = e.getEntity();
        if (!BloodMoonListener.isHostile(mob)) {
            return;
        }
        mob.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, 6000, 0, true, false, true));
        mob.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 6000, 0, true, false, true));
        mob.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 600, 0, true, false, true));
        Location loc = mob.getLocation().add(0.0, 1.0, 0.0);
        mob.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, loc, 40, 0.4, 0.6, 0.4, 0.01);
        mob.getWorld().spawnParticle(Particle.SOUL, loc, 20, 0.4, 0.4, 0.4, 0.0);
        this.startAura(mob);
    }

    private void startAura(final LivingEntity mob) {
        final UUID id = mob.getUniqueId();
        if (this.auras.containsKey(id)) {
            return;
        }
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                if (!mob.isValid() || mob.isDead()) {
                    this.stop();
                    return;
                }
                Location loc = mob.getLocation().add(0.0, 1.0, 0.0);
                Particle.DustOptions red = new Particle.DustOptions(Color.fromRGB((int)200, (int)20, (int)20), 1.1f);
                mob.getWorld().spawnParticle(Particle.DUST, loc, 6, 0.2, 0.3, 0.2, 0.0, (Object)red);
                mob.getWorld().spawnParticle(Particle.ASH, loc, 2, 0.2, 0.3, 0.2, 0.0);
            }

            private void stop() {
                BukkitTask t = BloodMoonListener.this.auras.remove(id);
                if (t != null) {
                    t.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
        this.auras.put(id, task);
    }

    public void shutdown() {
        for (BukkitTask t : this.auras.values()) {
            if (t == null) continue;
            t.cancel();
        }
        this.auras.clear();
    }
}

