/*
 * Decompiled with CFR 0.152.
 */
package me.minecraft.plugin.betterskyblockdrops;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class BloodMoonManager {
    private final JavaPlugin plugin;
    private final Set<World> active = new HashSet<World>();
    private final Map<UUID, BossBar> bars = new HashMap<UUID, BossBar>();
    private final Map<UUID, Boolean> wasNight = new HashMap<UUID, Boolean>();
    private BukkitTask watcher;
    private volatile boolean enabled = true;

    public BloodMoonManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.runWorldTickWatcher();
    }

    public void shutdown() {
        this.bars.values().forEach(bar -> {
            bar.removeAll();
            bar.setVisible(false);
        });
        this.bars.clear();
    }

    public void setEnabled(boolean on) {
        this.enabled = on;
        if (!on) {
            for (World w : Bukkit.getWorlds()) {
                this.endBloodMoon(w);
            }
            return;
        }
        this.reevaluateNow();
    }

    public void reevaluateNow() {
        for (World w : Bukkit.getWorlds()) {
            long time = w.getTime();
            boolean isNight = time >= 13000L || time < 1000L;
            long day = w.getFullTime() / 24000L;
            int phase = (int)(day % 8L);
            if (this.enabled && isNight && phase == 0) {
                this.startBloodMoon(w);
                continue;
            }
            this.endBloodMoon(w);
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.handleJoinOrWorldChange(p);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isActive(World w) {
        return this.active.contains(w);
    }

    private void runWorldTickWatcher() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (World w : Bukkit.getWorlds()) {
                long time = w.getTime();
                boolean isNight = time >= 13000L || time < 0L;
                boolean prev = this.wasNight.getOrDefault(w.getUID(), false);
                if (isNight && !prev) {
                    long day = w.getFullTime() / 24000L;
                    int phase = (int)(day % 8L);
                    if (phase == 0) {
                        this.startBloodMoon(w);
                    } else {
                        this.endBloodMoon(w);
                    }
                }
                if (!isNight && prev) {
                    this.endBloodMoon(w);
                }
                this.wasNight.put(w.getUID(), isNight);
            }
        }, 20L, 40L);
    }

    private void startBloodMoon(World w) {
        if (this.active.add(w)) {
            BossBar bar = Bukkit.createBossBar((String)"\u00a7cBLOOD MOON", (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            bar.setProgress(1.0);
            this.bars.put(w.getUID(), bar);
            for (Player p : w.getPlayers()) {
                bar.addPlayer(p);
            }
            w.playSound(w.getSpawnLocation(), Sound.AMBIENT_NETHER_WASTES_MOOD, 1.0f, 0.6f);
            Bukkit.broadcastMessage((String)"\u00a7cThe Blood Moon rises... the cursed walk freely!");
        }
    }

    private void endBloodMoon(World w) {
        if (this.active.remove(w)) {
            BossBar bar = this.bars.remove(w.getUID());
            if (bar != null) {
                for (Player p : w.getPlayers()) {
                    bar.removePlayer(p);
                }
                bar.setVisible(false);
            }
            Bukkit.broadcastMessage((String)"\u00a77Dawn breaks. The Blood Moon fades...");
        }
    }

    public void handleJoinOrWorldChange(Player p) {
        UUID worldId = p.getWorld().getUID();
        BossBar current = this.bars.get(worldId);
        if (current != null) {
            current.addPlayer(p);
        }
        for (Map.Entry<UUID, BossBar> entry : this.bars.entrySet()) {
            if (entry.getKey().equals(worldId)) continue;
            entry.getValue().removePlayer(p);
        }
    }
}

