/*
 * Decompiled with CFR 0.152.
 */
package me.minecraft.plugin.betterskyblockdrops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.minecraft.plugin.betterskyblockdrops.SkyblockDropsMain;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ChristmasEvent
implements Listener {
    private final SkyblockDropsMain plugin;
    private final NamespacedKey PRESENT_KEY;
    private final List<ItemStack> commonRewards = new ArrayList<ItemStack>();
    private final List<ItemStack> rareRewards = new ArrayList<ItemStack>();

    public ChristmasEvent(SkyblockDropsMain plugin) {
        this.plugin = plugin;
        this.PRESENT_KEY = new NamespacedKey((Plugin)plugin, "present");
        this.initializeRewards();
    }

    public boolean reloadSettings() {
        FileConfiguration cfg = this.plugin.getConfig();
        return cfg.getBoolean("christmas_event", false);
    }

    @EventHandler
    public void christmasEventSpawn(EntitySpawnEvent e) {
        boolean christmasEnabled = this.plugin.getConfig().getBoolean("christmas_event", false);
        Random random = new Random();
        if (christmasEnabled) {
            LivingEntity ent;
            if (e.getEntity() instanceof LivingEntity && ((ent = (LivingEntity)e.getEntity()).getType() == EntityType.ZOMBIE || ent.getType() == EntityType.HUSK || ent.getType() == EntityType.WITHER_SKELETON || ent.getType() == EntityType.ZOMBIFIED_PIGLIN || ent.getType() == EntityType.SKELETON)) {
                int number1 = random.nextInt(100);
                if (number1 > 85) {
                    ItemStack redHelmet = new ItemStack(Material.LEATHER_HELMET, 1);
                    LeatherArmorMeta redHelmetMeta = (LeatherArmorMeta)redHelmet.getItemMeta();
                    redHelmetMeta.setColor(Color.fromRGB((int)255, (int)0, (int)0));
                    redHelmetMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Santa's Hat");
                    redHelmet.setItemMeta((ItemMeta)redHelmetMeta);
                    Objects.requireNonNull(ent.getEquipment()).setHelmet(redHelmet);
                }
                if (number1 < 25) {
                    ItemStack greenHelmet = new ItemStack(Material.LEATHER_HELMET, 1);
                    LeatherArmorMeta greenHelmetMeta = (LeatherArmorMeta)greenHelmet.getItemMeta();
                    greenHelmetMeta.setColor(Color.fromRGB((int)69, (int)230, (int)0));
                    greenHelmetMeta.setDisplayName(String.valueOf(ChatColor.DARK_PURPLE) + "Santa's Helper's Hat");
                    greenHelmet.setItemMeta((ItemMeta)greenHelmetMeta);
                    Objects.requireNonNull(ent.getEquipment()).setHelmet(greenHelmet);
                }
            }
            if (e.getEntity() instanceof LivingEntity && ((ent = (LivingEntity)e.getEntity()).getType() == EntityType.ZOMBIE || ent.getType() == EntityType.HUSK || ent.getType() == EntityType.WITHER_SKELETON || ent.getType() == EntityType.ZOMBIFIED_PIGLIN || ent.getType() == EntityType.SKELETON)) {
                ItemMeta itemStackMeta;
                int number2 = random.nextInt(100);
                if (number2 < 30) {
                    ItemStack candies = new ItemStack(Material.SWEET_BERRIES, 1);
                    itemStackMeta = candies.getItemMeta();
                    itemStackMeta.setDisplayName(String.valueOf(ChatColor.DARK_PURPLE) + "Sweet Candies");
                    candies.setItemMeta(itemStackMeta);
                    Objects.requireNonNull(ent.getEquipment()).setItemInMainHand(candies);
                }
                if (number2 < 15) {
                    ItemStack cookies = new ItemStack(Material.COOKIE, 1);
                    itemStackMeta = cookies.getItemMeta();
                    itemStackMeta.setDisplayName(String.valueOf(ChatColor.DARK_PURPLE) + "Gingerbread Cookies");
                    cookies.setItemMeta(itemStackMeta);
                    Objects.requireNonNull(ent.getEquipment()).setItemInMainHand(cookies);
                }
            }
        }
    }

    public ItemStack createPresent() {
        ItemStack present = new ItemStack(Material.CHEST);
        ItemMeta meta = present.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Present");
            meta.setLore(Arrays.asList(String.valueOf(ChatColor.AQUA) + "Right-click to open!", String.valueOf(ChatColor.GRAY) + "Contains a surprise!"));
            PersistentDataContainer data = meta.getPersistentDataContainer();
            data.set(new NamespacedKey((Plugin)this.plugin, "uniqueID"), PersistentDataType.STRING, (Object)UUID.randomUUID().toString());
            present.setItemMeta(meta);
        }
        return present;
    }

    private boolean isPresent(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer data = meta.getPersistentDataContainer();
        return data.has(new NamespacedKey((Plugin)this.plugin, "uniqueID"), PersistentDataType.STRING);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        Player player = e.getPlayer();
        ItemStack item = e.getItemInHand();
        if (this.isPresent(item)) {
            e.setCancelled(true);
        }
    }

    public void initializeRewards() {
        this.commonRewards.add(new ItemStack(Material.GLOW_BERRIES, 2));
        this.commonRewards.add(new ItemStack(Material.SNOWBALL, 3));
        this.commonRewards.add(new ItemStack(Material.EGG));
        this.commonRewards.add(new ItemStack(Material.WHEAT_SEEDS, 2));
        this.commonRewards.add(new ItemStack(Material.KELP));
        this.commonRewards.add(new ItemStack(Material.INK_SAC, 2));
        this.commonRewards.add(new ItemStack(Material.GLASS_BOTTLE));
        this.commonRewards.add(new ItemStack(Material.BOWL));
        this.commonRewards.add(new ItemStack(Material.SUGAR, 3));
        this.commonRewards.add(new ItemStack(Material.YELLOW_DYE));
        this.rareRewards.add(new ItemStack(Material.DIAMOND));
        this.rareRewards.add(new ItemStack(Material.ENDER_PEARL, 2));
        this.rareRewards.add(new ItemStack(Material.EMERALD, 5));
        this.rareRewards.add(new ItemStack(Material.ANCIENT_DEBRIS));
        this.rareRewards.add(new ItemStack(Material.COPPER_INGOT, 10));
        this.rareRewards.add(new ItemStack(Material.ENCHANTED_GOLDEN_APPLE));
    }

    private ItemStack getRandomCommonRewards() {
        if (this.commonRewards.isEmpty()) {
            return null;
        }
        int randomIndexC = ThreadLocalRandom.current().nextInt(this.commonRewards.size());
        return this.commonRewards.get(randomIndexC).clone();
    }

    private List<ItemStack> getCommonRewards(int amount) {
        ArrayList<ItemStack> randomCommonRewards = new ArrayList<ItemStack>();
        for (int i = 0; i < amount; ++i) {
            randomCommonRewards.add(this.getRandomCommonRewards());
        }
        return randomCommonRewards;
    }

    private ItemStack getRandomRareReward() {
        if (this.rareRewards.isEmpty()) {
            return null;
        }
        int randomIndexR = ThreadLocalRandom.current().nextInt(this.rareRewards.size());
        return this.rareRewards.get(randomIndexR).clone();
    }

    private List<ItemStack> getRareRewards(int amount) {
        ArrayList<ItemStack> randomRareRewards = new ArrayList<ItemStack>();
        for (int i = 0; i < amount; ++i) {
            randomRareRewards.add(this.getRandomRareReward());
        }
        return randomRareRewards;
    }

    @EventHandler
    public void onPlayerInteraction(PlayerInteractEvent e) {
        block2: {
            int number;
            Player player;
            block3: {
                player = e.getPlayer();
                Action action = e.getAction();
                ItemStack item = e.getItem();
                if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK || !this.isPresent(item)) break block2;
                e.setCancelled(true);
                player.getInventory().removeItem(new ItemStack[]{item});
                Random random = new Random();
                number = random.nextInt(100);
                if (number >= 85) break block3;
                int rewardCount = ThreadLocalRandom.current().nextInt(1, 3);
                List<ItemStack> randomCommonRewards = this.getCommonRewards(rewardCount);
                for (ItemStack reward : randomCommonRewards) {
                    player.getInventory().addItem(new ItemStack[]{reward});
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.0f);
                }
                break block2;
            }
            if (number <= 85) break block2;
            int rewardCount = 1;
            List<ItemStack> randomRareReward = this.getRareRewards(rewardCount);
            for (ItemStack reward : randomRareReward) {
                player.getInventory().addItem(new ItemStack[]{reward});
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 1.5f);
            }
        }
    }

    @EventHandler
    public void christmasEventDeath(EntityDeathEvent e) {
        boolean christmasEnabled = this.plugin.getConfig().getBoolean("christmas_event", false);
        if (christmasEnabled && Math.random() < 0.1) {
            e.getDrops().add(this.createPresent());
        }
    }
}

