/*
 * Decompiled with CFR 0.152.
 */
package me.minecraft.plugin.betterskyblockdrops;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class CreepyMessageScheduler {
    private final JavaPlugin plugin;
    private BukkitTask task;
    private final List<String> messages = List.of("I can hear footsteps behind you...", "Don\u2019t look up. It sees you.", "Something moved in the darkness.", "The cave is whispering your name.", "You weren\u2019t alone in that tunnel.", "It\u2019s getting closer.", "I saw eyes in the fog.", "Why did the torch go out?", "The shadows are counting your steps\u2026", "There was another torch here. Who took it?", "Something is breathing just out of sight.", "Your name echoed back\u2026 but you didn\u2019t say it.", "The wind is blowing against you\u2026 underground.", "A door closed. There are no doors here.", "You left five torches. There are four.", "I saw a figure at the edge of your render distance.", "Cold fingers brushed your shoulder.", "It stopped moving when you looked at it.");

    public CreepyMessageScheduler(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void start() {
        long periodTicks = 1728000L;
        long initialDelay = ThreadLocalRandom.current().nextLong(36000L, 216000L);
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::broadcastOnce, initialDelay, periodTicks);
    }

    public void shutdown() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    private void broadcastOnce() {
        if (!this.plugin.getConfig().getBoolean("halloween_event", false)) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty() || this.messages.isEmpty()) {
            return;
        }
        String msg = this.messages.get(ThreadLocalRandom.current().nextInt(this.messages.size()));
        String styled = String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.ITALIC) + msg;
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.sendMessage(styled);
            p.playSound(p.getLocation(), Sound.AMBIENT_CAVE, 0.6f, 0.8f);
        }
    }
}

