/*
 * Decompiled with CFR 0.152.
 */
package me.minecraft.plugin.betterskyblockdrops;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import me.minecraft.plugin.betterskyblockdrops.SkyblockDropsMain;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class HalloweenEvent
implements Listener {
    private final SkyblockDropsMain plugin;
    private final NamespacedKey PRESENT_KEY;
    private final Map<UUID, BukkitTask> auras = new HashMap<UUID, BukkitTask>();
    private final List<ItemStack> commonRewards = new ArrayList<ItemStack>();
    private final List<ItemStack> rareRewards = new ArrayList<ItemStack>();
    private final List<ItemStack> legendaryRewards = new ArrayList<ItemStack>();

    public HalloweenEvent(SkyblockDropsMain plugin) {
        this.plugin = plugin;
        this.PRESENT_KEY = new NamespacedKey((Plugin)plugin, "present");
        this.initializeRewards();
    }

    public boolean reloadSettings() {
        FileConfiguration cfg = this.plugin.getConfig();
        return cfg.getBoolean("halloween_event", false);
    }

    private void startPumpkinAura(final LivingEntity mob) {
        final UUID id = mob.getUniqueId();
        if (this.auras.containsKey(id)) {
            return;
        }
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                if (!mob.isValid() || mob.isDead() || mob.getEquipment() == null) {
                    this.stop();
                    return;
                }
                ItemStack h = mob.getEquipment().getHelmet();
                if (h == null) {
                    this.stop();
                    return;
                }
                Material m = h.getType();
                if (m != Material.CARVED_PUMPKIN && m != Material.JACK_O_LANTERN) {
                    this.stop();
                    return;
                }
                Location loc = mob.getLocation().add(0.0, 1.0, 0.0);
                if (m == Material.JACK_O_LANTERN) {
                    mob.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, loc, 4, 0.15, 0.25, 0.15, 0.0);
                    mob.getWorld().spawnParticle(Particle.SOUL, loc, 2, 0.15, 0.15, 0.15, 0.0);
                } else {
                    Particle.DustOptions orange = new Particle.DustOptions(Color.fromRGB((int)255, (int)140, (int)0), 1.1f);
                    mob.getWorld().spawnParticle(Particle.DUST, loc, 6, 0.2, 0.3, 0.2, 0.0, (Object)orange);
                }
            }

            private void stop() {
                BukkitTask t = HalloweenEvent.this.auras.remove(id);
                if (t != null) {
                    t.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
        this.auras.put(id, task);
    }

    @EventHandler
    public void halloweenEventSpawn(CreatureSpawnEvent e) {
        if (!this.plugin.getConfig().getBoolean("halloween_event", false)) {
            return;
        }
        if (e.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            return;
        }
        LivingEntity mob = e.getEntity();
        EntityType type = mob.getType();
        if (type != EntityType.ZOMBIE && type != EntityType.HUSK && type != EntityType.WITHER_SKELETON && type != EntityType.ZOMBIFIED_PIGLIN && type != EntityType.SKELETON) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            boolean carved;
            if (!mob.isValid() || mob.isDead()) {
                return;
            }
            if (mob.getEquipment() == null) {
                return;
            }
            int roll = ThreadLocalRandom.current().nextInt(100);
            boolean jack = roll < 10;
            boolean bl = carved = !jack && roll < 50;
            if (!jack && !carved) {
                return;
            }
            ItemStack helm = new ItemStack(jack ? Material.JACK_O_LANTERN : Material.CARVED_PUMPKIN);
            mob.getEquipment().setHelmet(helm);
            mob.getEquipment().setHelmetDropChance(0.0f);
            Location loc = mob.getLocation().add(0.0, 1.0, 0.0);
            if (jack) {
                mob.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, loc, 40, 0.4, 0.6, 0.4, 0.01);
                mob.getWorld().spawnParticle(Particle.SOUL, loc, 20, 0.4, 0.4, 0.4, 0.0);
            } else {
                Particle.DustOptions orange = new Particle.DustOptions(Color.fromRGB((int)255, (int)140, (int)0), 1.3f);
                mob.getWorld().spawnParticle(Particle.DUST, loc, 60, 0.5, 0.6, 0.5, 0.0, (Object)orange);
            }
            this.startPumpkinAura(mob);
        }, 5L);
    }

    public ItemStack createHalloweenPresent() {
        ItemStack present = new ItemStack(Material.PUMPKIN);
        ItemMeta meta = present.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Trick or Treat!");
            meta.setLore(Arrays.asList(String.valueOf(ChatColor.AQUA) + "Right-click to open!", String.valueOf(ChatColor.GRAY) + "Contains a surprise!"));
            PersistentDataContainer data = meta.getPersistentDataContainer();
            data.set(new NamespacedKey((Plugin)this.plugin, "uniqueID"), PersistentDataType.STRING, (Object)UUID.randomUUID().toString());
            meta.addEnchant(Enchantment.LOOTING, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES});
            present.setItemMeta(meta);
        }
        return present;
    }

    private boolean isHalloweenPresent(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer data = meta.getPersistentDataContainer();
        return data.has(new NamespacedKey((Plugin)this.plugin, "uniqueID"), PersistentDataType.STRING);
    }

    @EventHandler
    public void onHalloweenPresentPlace(BlockPlaceEvent e) {
        Player player = e.getPlayer();
        ItemStack item = e.getItemInHand();
        if (this.isHalloweenPresent(item)) {
            e.setCancelled(true);
        }
    }

    public void initializeRewards() {
        this.commonRewards.add(new ItemStack(Material.ROTTEN_FLESH, 2));
        this.commonRewards.add(new ItemStack(Material.SPIDER_EYE, 2));
        this.commonRewards.add(new ItemStack(Material.CARVED_PUMPKIN, 1));
        this.commonRewards.add(new ItemStack(Material.BONE, 2));
        this.commonRewards.add(new ItemStack(Material.GUNPOWDER, 2));
        this.commonRewards.add(new ItemStack(Material.COOKED_BEEF, 1));
        this.commonRewards.add(new ItemStack(Material.POISONOUS_POTATO, 1));
        this.commonRewards.add(new ItemStack(Material.BLACK_DYE, 1));
        this.commonRewards.add(new ItemStack(Material.COOKED_CHICKEN, 1));
        this.commonRewards.add(new ItemStack(Material.WHEAT, 2));
        this.rareRewards.add(new ItemStack(Material.ENDER_PEARL, 1));
        this.rareRewards.add(new ItemStack(Material.EMERALD, 1));
        this.rareRewards.add(new ItemStack(Material.EXPERIENCE_BOTTLE, 2));
        this.rareRewards.add(new ItemStack(Material.SLIME_BALL, 1));
        this.rareRewards.add(new ItemStack(Material.IRON_SWORD, 1));
        this.rareRewards.add(new ItemStack(Material.FERMENTED_SPIDER_EYE, 1));
        this.rareRewards.add(new ItemStack(Material.SKELETON_SKULL, 1));
        this.rareRewards.add(new ItemStack(Material.ZOMBIE_HEAD, 1));
        this.legendaryRewards.add(new ItemStack(Material.DIAMOND, 1));
        this.legendaryRewards.add(new ItemStack(Material.NETHERITE_SCRAP, 1));
        this.legendaryRewards.add(new ItemStack(Material.WITHER_SKELETON_SKULL, 1));
        this.legendaryRewards.add(new ItemStack(Material.TRIDENT, 1));
        ItemStack book1 = new ItemStack(Material.ENCHANTED_BOOK, 1);
        EnchantmentStorageMeta metaBook1 = (EnchantmentStorageMeta)book1.getItemMeta();
        if (metaBook1 != null) {
            metaBook1.addStoredEnchant(Enchantment.UNBREAKING, 1, true);
            book1.setItemMeta((ItemMeta)metaBook1);
        }
        this.rareRewards.add(book1);
        ItemStack book2 = new ItemStack(Material.ENCHANTED_BOOK, 1);
        EnchantmentStorageMeta metaBook2 = (EnchantmentStorageMeta)book2.getItemMeta();
        if (metaBook2 != null) {
            metaBook2.addStoredEnchant(Enchantment.PROTECTION, 1, true);
            book2.setItemMeta((ItemMeta)metaBook2);
        }
        this.rareRewards.add(book2);
        ItemStack book3 = new ItemStack(Material.ENCHANTED_BOOK, 1);
        EnchantmentStorageMeta metaBook3 = (EnchantmentStorageMeta)book3.getItemMeta();
        if (metaBook3 != null) {
            metaBook3.addStoredEnchant(Enchantment.SHARPNESS, 1, true);
            book3.setItemMeta((ItemMeta)metaBook3);
        }
        this.rareRewards.add(book3);
        ItemStack book4 = new ItemStack(Material.ENCHANTED_BOOK, 1);
        EnchantmentStorageMeta metaBook4 = (EnchantmentStorageMeta)book4.getItemMeta();
        if (metaBook4 != null) {
            metaBook4.addStoredEnchant(Enchantment.LUCK_OF_THE_SEA, 1, true);
            book4.setItemMeta((ItemMeta)metaBook4);
        }
        this.rareRewards.add(book4);
    }

    private ItemStack getRandomCommonRewards() {
        if (this.commonRewards.isEmpty()) {
            return null;
        }
        int randomIndexC = ThreadLocalRandom.current().nextInt(this.commonRewards.size());
        return this.commonRewards.get(randomIndexC).clone();
    }

    private List<ItemStack> getCommonRewards(int amount) {
        ArrayList<ItemStack> randomCommonRewards = new ArrayList<ItemStack>();
        for (int i = 0; i < amount; ++i) {
            randomCommonRewards.add(this.getRandomCommonRewards());
        }
        return randomCommonRewards;
    }

    private ItemStack getRandomRareRewards() {
        if (this.rareRewards.isEmpty()) {
            return null;
        }
        int randomIndexC = ThreadLocalRandom.current().nextInt(this.rareRewards.size());
        return this.rareRewards.get(randomIndexC).clone();
    }

    private List<ItemStack> getRareRewards(int amount) {
        ArrayList<ItemStack> randomRareRewards = new ArrayList<ItemStack>();
        for (int i = 0; i < amount; ++i) {
            randomRareRewards.add(this.getRandomRareRewards());
        }
        return randomRareRewards;
    }

    private ItemStack getRandomLegendaryRewards() {
        if (this.legendaryRewards.isEmpty()) {
            return null;
        }
        int randomIndexC = ThreadLocalRandom.current().nextInt(this.legendaryRewards.size());
        return this.legendaryRewards.get(randomIndexC).clone();
    }

    private List<ItemStack> getLegendaryRewards(int amount) {
        ArrayList<ItemStack> randomLegendaryRewards = new ArrayList<ItemStack>();
        for (int i = 0; i < amount; ++i) {
            randomLegendaryRewards.add(this.getRandomLegendaryRewards());
        }
        return randomLegendaryRewards;
    }

    @EventHandler
    public void onPlayerInteraction(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        Action action = e.getAction();
        ItemStack item = e.getItem();
        if ((action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) && this.isHalloweenPresent(item)) {
            int rewardCount;
            e.setCancelled(true);
            player.getInventory().removeItem(new ItemStack[]{item});
            Random random = new Random();
            int number = random.nextInt(100);
            if (number >= 25) {
                rewardCount = ThreadLocalRandom.current().nextInt(1, 4);
                List<ItemStack> randomCommonRewards = this.getCommonRewards(rewardCount);
                for (ItemStack reward : randomCommonRewards) {
                    player.getInventory().addItem(new ItemStack[]{reward});
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 1.5f);
                }
            }
            if (number < 25 && number >= 1) {
                rewardCount = ThreadLocalRandom.current().nextInt(1, 2);
                List<ItemStack> randomRareRewards = this.getRareRewards(rewardCount);
                for (ItemStack reward : randomRareRewards) {
                    player.getInventory().addItem(new ItemStack[]{reward});
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 1.5f);
                }
            }
            if (number == 0) {
                rewardCount = ThreadLocalRandom.current().nextInt(1, 1);
                List<ItemStack> randomLegendaryRewards = this.getLegendaryRewards(rewardCount);
                for (ItemStack reward : randomLegendaryRewards) {
                    player.getInventory().addItem(new ItemStack[]{reward});
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 2.0f, 1.5f);
                }
            }
        }
    }

    @EventHandler
    public void halloweenEventDeath(EntityDeathEvent e) {
        boolean halloweenEnabled = this.plugin.getConfig().getBoolean("halloween_event", false);
        Random random = new Random();
        int number = random.nextInt(100);
        LivingEntity ent = e.getEntity();
        if (halloweenEnabled && (ent.getType() == EntityType.ZOMBIE || ent.getType() == EntityType.HUSK || ent.getType() == EntityType.BLAZE || ent.getType() == EntityType.WITHER_SKELETON || ent.getType() == EntityType.WITHER || ent.getType() == EntityType.ZOMBIFIED_PIGLIN || ent.getType() == EntityType.SKELETON) && number < 30) {
            e.getDrops().add(this.createHalloweenPresent());
        }
    }
}

