/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.proxy.shared.resolver;

import app.simplecloud.plugin.proxy.shared.config.motd.MaxPlayerDisplayType;
import app.simplecloud.plugin.proxy.shared.config.motd.MotdLayoutConfiguration;
import app.simplecloud.plugin.proxy.shared.config.placeholder.PingColor;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005J\u0006\u0010\u0013\u001a\u00020\u0006J\u001e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u0006\u00a8\u0006\u0017"}, d2={"Lapp/simplecloud/plugin/proxy/shared/resolver/TagResolverHelper;", "", "<init>", "()V", "getDefaultTagResolvers", "", "Lnet/kyori/adventure/text/minimessage/tag/resolver/TagResolver;", "serverName", "", "ping", "", "pingColors", "Lapp/simplecloud/plugin/proxy/shared/config/placeholder/PingColor;", "onlinePlayers", "", "realMaxPlayers", "motdConfiguration", "Lapp/simplecloud/plugin/proxy/shared/config/motd/MotdLayoutConfiguration;", "getPingTagResolver", "getDateTagResolver", "getMaxPlayersTagResolver", "getOnlinePlayersTagResolver", "getEnvTagResolver", "proxy-shared"})
@SourceDebugExtension(value={"SMAP\nTagResolverHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TagResolverHelper.kt\napp/simplecloud/plugin/proxy/shared/resolver/TagResolverHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n295#2,2:77\n*S KotlinDebug\n*F\n+ 1 TagResolverHelper.kt\napp/simplecloud/plugin/proxy/shared/resolver/TagResolverHelper\n*L\n37#1:77,2\n*E\n"})
public final class TagResolverHelper {
    @NotNull
    public static final TagResolverHelper INSTANCE = new TagResolverHelper();

    private TagResolverHelper() {
    }

    @NotNull
    public final List<TagResolver> getDefaultTagResolvers(@NotNull String serverName, long ping, @NotNull List<PingColor> pingColors, int onlinePlayers, int realMaxPlayers, @NotNull MotdLayoutConfiguration motdConfiguration) {
        Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
        Intrinsics.checkNotNullParameter(pingColors, (String)"pingColors");
        Intrinsics.checkNotNullParameter((Object)motdConfiguration, (String)"motdConfiguration");
        Object[] objectArray = new TagResolver[]{Placeholder.unparsed((String)"server_name", (String)serverName), this.getPingTagResolver(ping, pingColors), this.getDateTagResolver(), this.getOnlinePlayersTagResolver(onlinePlayers), this.getMaxPlayersTagResolver(onlinePlayers, realMaxPlayers, motdConfiguration), this.getEnvTagResolver()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final TagResolver getPingTagResolver(long ping, @NotNull List<PingColor> pingColors) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(pingColors, (String)"pingColors");
            Iterable $this$firstOrNull$iv = pingColors;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PingColor it = (PingColor)element$iv;
                boolean bl = false;
                if (!((long)it.getPing() <= ping)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (PingColor)v0) == null || (object = ((PingColor)object).getColor()) == null) {
            object = "<dark_red>";
        }
        Object pingColor = object;
        TagResolver.Single single = Placeholder.parsed((String)"ping", (String)((String)pingColor + ping));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"parsed(...)");
        return (TagResolver)single;
    }

    @NotNull
    public final TagResolver getDateTagResolver() {
        LocalDateTime now = LocalDateTime.now(ZoneId.systemDefault());
        TagResolver tagResolver = Formatter.date((String)"date", (TemporalAccessor)now);
        Intrinsics.checkNotNullExpressionValue((Object)tagResolver, (String)"date(...)");
        return tagResolver;
    }

    @NotNull
    public final TagResolver getMaxPlayersTagResolver(int onlinePlayers, int realMaxPlayers, @NotNull MotdLayoutConfiguration motdConfiguration) {
        Intrinsics.checkNotNullParameter((Object)motdConfiguration, (String)"motdConfiguration");
        MaxPlayerDisplayType maxPlayerDisplayType = motdConfiguration.getMaxPlayerDisplayType();
        int maxPlayers = switch (maxPlayerDisplayType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[maxPlayerDisplayType.ordinal()]) {
            case 1 -> realMaxPlayers;
            case 2 -> onlinePlayers + motdConfiguration.getDynamicPlayerRange();
            case -1 -> realMaxPlayers;
            default -> throw new NoWhenBranchMatchedException();
        };
        TagResolver.Single single = Placeholder.unparsed((String)"max_players", (String)String.valueOf(maxPlayers));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"unparsed(...)");
        return (TagResolver)single;
    }

    @NotNull
    public final TagResolver getOnlinePlayersTagResolver(int onlinePlayers) {
        TagResolver.Single single = Placeholder.unparsed((String)"online_players", (String)String.valueOf(onlinePlayers));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"unparsed(...)");
        return (TagResolver)single;
    }

    @NotNull
    public final TagResolver getEnvTagResolver() {
        TagResolver tagResolver = TagResolver.resolver((String)"env", TagResolverHelper::getEnvTagResolver$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)tagResolver, (String)"resolver(...)");
        return tagResolver;
    }

    private static final Tag getEnvTagResolver$lambda$1(ArgumentQueue args, Context context) {
        String string;
        Object envDefault;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string2 = args.popOr("env name expected").value();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value(...)");
        String envName = string2;
        Object object = args.peek();
        if (object == null || (object = object.value()) == null) {
            object = envDefault = "";
        }
        if ((string = System.getenv(envName)) == null) {
            string = envDefault;
        }
        String env = string;
        return (Tag)Tag.preProcessParsed((String)env);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MaxPlayerDisplayType.values().length];
            try {
                nArray[MaxPlayerDisplayType.REAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MaxPlayerDisplayType.DYNAMIC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

