/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.proxy.shared.handler;

import app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.CommentedConfigurationNode;
import app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.ConfigurationNode;
import app.simplecloud.plugin.proxy.shared.ProxyPlugin;
import app.simplecloud.plugin.proxy.shared.config.YamlConfig;
import app.simplecloud.plugin.proxy.shared.config.motd.MotdLayoutConfiguration;
import app.simplecloud.plugin.proxy.shared.config.state.JoinState;
import io.leangen.geantyref.TypeToken;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0006\u0010\u0019\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lapp/simplecloud/plugin/proxy/shared/handler/MotdLayoutHandler;", "", "yamlConfig", "Lapp/simplecloud/plugin/proxy/shared/config/YamlConfig;", "proxyPlugin", "Lapp/simplecloud/plugin/proxy/shared/ProxyPlugin;", "<init>", "(Lapp/simplecloud/plugin/proxy/shared/config/YamlConfig;Lapp/simplecloud/plugin/proxy/shared/ProxyPlugin;)V", "loadedMotdLayouts", "", "", "Lapp/simplecloud/plugin/proxy/shared/config/motd/MotdLayoutConfiguration;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "Ljava/util/logging/Logger;", "loadMotdLayouts", "", "initializeLayoutDirectory", "loadLayoutsFromDirectory", "createDefaultLayoutsIfEmpty", "createAndSaveDefaultLayout", "layoutName", "getMotdLayout", "name", "getCurrentMotdLayout", "proxy-shared"})
@SourceDebugExtension(value={"SMAP\nMotdLayoutHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MotdLayoutHandler.kt\napp/simplecloud/plugin/proxy/shared/handler/MotdLayoutHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 YamlConfig.kt\napp/simplecloud/plugin/proxy/shared/config/YamlConfig\n+ 4 ConfigurationNodeExtensions.kt\norg/spongepowered/configurate/kotlin/extensions/ConfigurationNodeExtensionsKt\n+ 5 ObjectMapping.kt\norg/spongepowered/configurate/kotlin/ObjectMappingKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n13409#2:63\n13410#2:68\n34#3,2:64\n61#4:66\n76#5:67\n1863#6,2:69\n*S KotlinDebug\n*F\n+ 1 MotdLayoutHandler.kt\napp/simplecloud/plugin/proxy/shared/handler/MotdLayoutHandler\n*L\n32#1:63\n32#1:68\n33#1:64,2\n33#1:66\n33#1:67\n42#1:69,2\n*E\n"})
public final class MotdLayoutHandler {
    @NotNull
    private final YamlConfig yamlConfig;
    @NotNull
    private final ProxyPlugin proxyPlugin;
    @NotNull
    private final Map<String, MotdLayoutConfiguration> loadedMotdLayouts;
    private final Logger logger;

    public MotdLayoutHandler(@NotNull YamlConfig yamlConfig, @NotNull ProxyPlugin proxyPlugin) {
        Intrinsics.checkNotNullParameter((Object)yamlConfig, (String)"yamlConfig");
        Intrinsics.checkNotNullParameter((Object)proxyPlugin, (String)"proxyPlugin");
        this.yamlConfig = yamlConfig;
        this.proxyPlugin = proxyPlugin;
        this.loadedMotdLayouts = new LinkedHashMap();
        this.logger = Logger.getLogger(MotdLayoutHandler.class.getName());
    }

    public final void loadMotdLayouts() {
        this.loadedMotdLayouts.clear();
        this.initializeLayoutDirectory();
        this.loadLayoutsFromDirectory();
        this.createDefaultLayoutsIfEmpty();
    }

    private final void initializeLayoutDirectory() {
        File directory = new File(this.yamlConfig.getDirPath() + "/layout");
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadLayoutsFromDirectory() {
        block1: {
            File[] fileArray = new File(this.yamlConfig.getDirPath() + "/layout").listFiles();
            if (fileArray == null) break block1;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                MotdLayoutConfiguration layout;
                void this_$iv;
                File element$iv;
                File file = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                YamlConfig yamlConfig = this.yamlConfig;
                Intrinsics.checkNotNull((Object)file);
                String path$iv = "layout/" + FilesKt.getNameWithoutExtension((File)file);
                boolean $i$f$load = false;
                CommentedConfigurationNode node$iv = (CommentedConfigurationNode)this_$iv.buildNode(path$iv).getFirst();
                ConfigurationNode $this$get$iv$iv = node$iv;
                boolean $i$f$get = false;
                boolean $i$f$typeTokenOf = false;
                if ((MotdLayoutConfiguration)$this$get$iv$iv.get((TypeToken)new TypeToken<MotdLayoutConfiguration>(){}) == null) continue;
                boolean bl2 = false;
                this.loadedMotdLayouts.put(FilesKt.getNameWithoutExtension((File)file), layout);
                this.logger.info("Loaded MOTD layout: " + FilesKt.getNameWithoutExtension((File)file));
            }
        }
    }

    private final void createDefaultLayoutsIfEmpty() {
        if (this.loadedMotdLayouts.isEmpty()) {
            Iterable $this$forEach$iv = this.proxyPlugin.getJoinStateConfiguration().getJoinStates();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JoinState it = (JoinState)element$iv;
                boolean bl = false;
                this.createAndSaveDefaultLayout(it.getMotdLayoutByProxy());
            }
        }
    }

    private final void createAndSaveDefaultLayout(String layoutName) {
        MotdLayoutConfiguration defaultLayout = new MotdLayoutConfiguration(null, null, null, null, null, null, 0, 127, null);
        this.yamlConfig.save("layout/" + layoutName, defaultLayout);
        this.loadedMotdLayouts.put(layoutName, defaultLayout);
        this.logger.info("Created and saved default layout: " + layoutName);
    }

    private final MotdLayoutConfiguration getMotdLayout(String name) {
        MotdLayoutConfiguration motdLayoutConfiguration = this.loadedMotdLayouts.get(name);
        if (motdLayoutConfiguration == null) {
            motdLayoutConfiguration = new MotdLayoutConfiguration(null, null, null, null, null, null, 0, 127, null);
        }
        return motdLayoutConfiguration;
    }

    @NotNull
    public final MotdLayoutConfiguration getCurrentMotdLayout() {
        return this.getMotdLayout(this.proxyPlugin.getJoinStateHandler().getLocalState());
    }
}

