/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.kyori.adventure.text.minimessage.tag.resolver;

import app.simplecloud.relocate.kyori.adventure.text.Component;
import app.simplecloud.relocate.kyori.adventure.text.ComponentLike;
import app.simplecloud.relocate.kyori.adventure.text.JoinConfiguration;
import app.simplecloud.relocate.kyori.adventure.text.minimessage.tag.Tag;
import app.simplecloud.relocate.kyori.adventure.text.minimessage.tag.TagPattern;
import app.simplecloud.relocate.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public final class Formatter {
    private Formatter() {
    }

    @NotNull
    public static TagResolver number(@TagPattern @NotNull String key, @NotNull Number number) {
        return TagResolver.resolver(key, (argumentQueue, context) -> {
            NumberFormat decimalFormat;
            if (argumentQueue.hasNext()) {
                String locale = argumentQueue.pop().value();
                if (argumentQueue.hasNext()) {
                    String format = argumentQueue.pop().value();
                    decimalFormat = new DecimalFormat(format, new DecimalFormatSymbols(Locale.forLanguageTag(locale)));
                } else {
                    decimalFormat = locale.contains(".") ? new DecimalFormat(locale, DecimalFormatSymbols.getInstance()) : DecimalFormat.getInstance(Locale.forLanguageTag(locale));
                }
            } else {
                decimalFormat = DecimalFormat.getInstance();
            }
            return Tag.inserting(context.deserialize(decimalFormat.format(number)));
        });
    }

    @NotNull
    public static TagResolver date(@TagPattern @NotNull String key, @NotNull TemporalAccessor time) {
        return TagResolver.resolver(key, (argumentQueue, context) -> {
            String format = argumentQueue.popOr("Format expected.").value();
            return Tag.inserting(context.deserialize(DateTimeFormatter.ofPattern(format).format(time)));
        });
    }

    @NotNull
    public static TagResolver choice(@TagPattern @NotNull String key, Number number) {
        return TagResolver.resolver(key, (argumentQueue, context) -> {
            String format = argumentQueue.popOr("Format expected.").value();
            ChoiceFormat choiceFormat = new ChoiceFormat(format);
            return Tag.inserting(context.deserialize(choiceFormat.format(number)));
        });
    }

    public static TagResolver booleanChoice(@TagPattern @NotNull String key, boolean value) {
        return TagResolver.resolver(key, (argumentQueue, context) -> {
            String trueCase = argumentQueue.popOr("True format expected.").value();
            String falseCase = argumentQueue.popOr("False format expected.").value();
            return Tag.inserting(context.deserialize(value ? trueCase : falseCase));
        });
    }

    public static TagResolver joining(@TagPattern @NotNull String key, @NotNull Iterable<? extends ComponentLike> components) {
        return TagResolver.resolver(key, (argumentQueue, context) -> {
            if (!argumentQueue.hasNext()) {
                return Tag.inserting(Component.join(JoinConfiguration.noSeparators(), components));
            }
            String separator = argumentQueue.pop().value();
            JoinConfiguration.Builder configBuilder = JoinConfiguration.builder().separator(context.deserialize(separator));
            if (argumentQueue.hasNext()) {
                String lastSeparator = argumentQueue.pop().value();
                configBuilder.lastSeparator(context.deserialize(lastSeparator));
            }
            if (argumentQueue.hasNext()) {
                String lastSeparatorIfSerial = argumentQueue.pop().value();
                configBuilder.lastSeparatorIfSerial(context.deserialize(lastSeparatorIfSerial));
            }
            JoinConfiguration config = (JoinConfiguration)configBuilder.build();
            return Tag.inserting(Component.join(config, components));
        });
    }

    public static TagResolver joining(@TagPattern @NotNull String key, ComponentLike ... components) {
        return Formatter.joining(key, Arrays.asList(components));
    }
}

