/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.objectmapping.meta;

import app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.objectmapping.meta.Localization;
import app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.objectmapping.meta.Matches;
import app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.serialize.SerializationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Constraint<V> {
    public void validate(@Nullable V var1) throws SerializationException;

    public static <T extends Annotation> Factory<T, Object> required() {
        return (data, type) -> value -> {
            if (value == null) {
                throw new SerializationException("A value is required for this field");
            }
        };
    }

    public static Factory<Matches, String> pattern() {
        return (data, type) -> {
            Pattern test = Pattern.compile(data.value(), data.flags());
            MessageFormat format = new MessageFormat(data.failureMessage(), Locale.getDefault());
            return value -> {
                Matcher match;
                if (value != null && !(match = test.matcher((CharSequence)value)).matches()) {
                    throw new SerializationException(format.format(new Object[]{value, data.value()}));
                }
            };
        };
    }

    public static Factory<Matches, String> localizedPattern(ResourceBundle bundle) {
        return (data, type) -> {
            Pattern test = Pattern.compile(data.value(), data.flags());
            MessageFormat format = new MessageFormat(Localization.key(bundle, data.failureMessage()), bundle.getLocale());
            return value -> {
                Matcher match;
                if (value != null && !(match = test.matcher((CharSequence)value)).matches()) {
                    throw new SerializationException(format.format(new Object[]{value, data.value()}));
                }
            };
        };
    }

    public static interface Factory<A extends Annotation, V> {
        public Constraint<V> make(A var1, Type var2);
    }
}

