/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.proxy.relocate.incendo.cloud.bungee.parser;

import app.simplecloud.plugin.proxy.relocate.incendo.cloud.bungee.BungeeCaptionKeys;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.caption.CaptionVariable;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.exception.parsing.ParserException;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.parser.ParserDescriptor;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.suggestion.BlockingSuggestionProvider;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PlayerParser<C>
implements ArgumentParser<C, ProxiedPlayer>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, ProxiedPlayer> playerParser() {
        return ParserDescriptor.of(new PlayerParser<C>(), ProxiedPlayer.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, ProxiedPlayer> playerComponent() {
        return CommandComponent.builder().parser(PlayerParser.playerParser());
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull ProxiedPlayer> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        ProxiedPlayer player = ((ProxyServer)commandContext.get("ProxyServer")).getPlayer(input);
        if (player == null) {
            return ArgumentParseResult.failure(new PlayerParseException(input, commandContext));
        }
        return ArgumentParseResult.success(player);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return ((ProxyServer)commandContext.get("ProxyServer")).getPlayers().stream().map(ProxiedPlayer::getDisplayName).collect(Collectors.toList());
    }

    public static final class PlayerParseException
    extends ParserException {
        private PlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(PlayerParser.class, context, BungeeCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, CaptionVariable.of("input", input));
        }
    }
}

