/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.proxy.shared.handler;

import app.simplecloud.plugin.proxy.relocate.plugin.api.shared.repository.YamlDirectoryRepository;
import app.simplecloud.plugin.proxy.shared.ProxyPlugin;
import app.simplecloud.plugin.proxy.shared.config.motd.MotdLayoutConfiguration;
import app.simplecloud.plugin.proxy.shared.config.state.JoinState;
import java.nio.file.Path;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0006\u0010\u0015\u001a\u00020\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0016"}, d2={"Lapp/simplecloud/plugin/proxy/shared/handler/MotdLayoutHandler;", "Lapp/simplecloud/plugin/proxy/relocate/plugin/api/shared/repository/YamlDirectoryRepository;", "Lapp/simplecloud/plugin/proxy/shared/config/motd/MotdLayoutConfiguration;", "directory", "Ljava/nio/file/Path;", "proxyPlugin", "Lapp/simplecloud/plugin/proxy/shared/ProxyPlugin;", "<init>", "(Ljava/nio/file/Path;Lapp/simplecloud/plugin/proxy/shared/ProxyPlugin;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "Ljava/util/logging/Logger;", "loadMotdLayouts", "", "createDefaultLayoutsIfEmpty", "createAndSaveDefaultLayout", "layoutName", "", "getMotdLayout", "name", "getCurrentMotdLayout", "proxy-shared"})
@SourceDebugExtension(value={"SMAP\nMotdLayoutHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MotdLayoutHandler.kt\napp/simplecloud/plugin/proxy/shared/handler/MotdLayoutHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1863#2,2:48\n*S KotlinDebug\n*F\n+ 1 MotdLayoutHandler.kt\napp/simplecloud/plugin/proxy/shared/handler/MotdLayoutHandler\n*L\n26#1:48,2\n*E\n"})
public final class MotdLayoutHandler
extends YamlDirectoryRepository<MotdLayoutConfiguration> {
    @NotNull
    private final Path directory;
    @NotNull
    private final ProxyPlugin proxyPlugin;
    private final Logger logger;

    public MotdLayoutHandler(@NotNull Path directory, @NotNull ProxyPlugin proxyPlugin) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)proxyPlugin, (String)"proxyPlugin");
        super(directory, MotdLayoutConfiguration.class);
        this.directory = directory;
        this.proxyPlugin = proxyPlugin;
        this.logger = Logger.getLogger(MotdLayoutHandler.class.getName());
    }

    public final void loadMotdLayouts() {
        this.load();
        this.createDefaultLayoutsIfEmpty();
    }

    private final void createDefaultLayoutsIfEmpty() {
        if (this.getEntities().isEmpty()) {
            Iterable $this$forEach$iv = this.proxyPlugin.getJoinStateConfiguration().get().getJoinStates();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JoinState it = (JoinState)element$iv;
                boolean bl = false;
                this.createAndSaveDefaultLayout(it.getMotdLayoutByProxy());
            }
        }
    }

    private final void createAndSaveDefaultLayout(String layoutName) {
        MotdLayoutConfiguration defaultLayout = new MotdLayoutConfiguration(null, null, null, null, null, null, 0, 127, null);
        this.save(layoutName + ".yml", defaultLayout);
        this.logger.info("Created and saved default layout: " + layoutName);
    }

    private final MotdLayoutConfiguration getMotdLayout(String name) {
        MotdLayoutConfiguration motdLayoutConfiguration = (MotdLayoutConfiguration)this.getEntities().get(this.directory.resolve(name + ".yml").toFile());
        if (motdLayoutConfiguration == null) {
            motdLayoutConfiguration = new MotdLayoutConfiguration(null, null, null, null, null, null, 0, 127, null);
        }
        return motdLayoutConfiguration;
    }

    @NotNull
    public final MotdLayoutConfiguration getCurrentMotdLayout() {
        return this.getMotdLayout(this.proxyPlugin.getJoinStateHandler().getLocalState());
    }
}

