/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.proxy.bungeecord.handler;

import app.simplecloud.plugin.proxy.bungeecord.ProxyBungeeCordPlugin;
import app.simplecloud.plugin.proxy.shared.config.tablis.TabList;
import app.simplecloud.plugin.proxy.shared.config.tablis.TabListConfiguration;
import app.simplecloud.plugin.proxy.shared.config.tablis.TabListGroup;
import app.simplecloud.relocate.kyori.adventure.audience.Audience;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lapp/simplecloud/plugin/proxy/bungeecord/handler/TabListHandler;", "", "plugin", "Lapp/simplecloud/plugin/proxy/bungeecord/ProxyBungeeCordPlugin;", "<init>", "(Lapp/simplecloud/plugin/proxy/bungeecord/ProxyBungeeCordPlugin;)V", "tabListIndex", "", "", "", "task", "Lnet/md_5/bungee/api/scheduler/ScheduledTask;", "startTabListTask", "", "stopTabListTask", "updateTabListForPlayer", "player", "Lnet/md_5/bungee/api/connection/ProxiedPlayer;", "proxy-bungeecord"})
@SourceDebugExtension(value={"SMAP\nTabListHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TabListHandler.kt\napp/simplecloud/plugin/proxy/bungeecord/handler/TabListHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,92:1\n1863#2,2:93\n216#3,2:95\n*S KotlinDebug\n*F\n+ 1 TabListHandler.kt\napp/simplecloud/plugin/proxy/bungeecord/handler/TabListHandler\n*L\n18#1:93,2\n21#1:95,2\n*E\n"})
public final class TabListHandler {
    @NotNull
    private final ProxyBungeeCordPlugin plugin;
    @NotNull
    private final Map<String, Integer> tabListIndex;
    private ScheduledTask task;

    public TabListHandler(@NotNull ProxyBungeeCordPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        this.tabListIndex = new LinkedHashMap();
    }

    public final void startTabListTask() {
        this.task = this.plugin.getProxy().getScheduler().schedule((Plugin)this.plugin, () -> TabListHandler.startTabListTask$lambda$2(this), 1L, this.plugin.getProxyPlugin().getTabListConfiguration().getTabListUpdateTime(), TimeUnit.MILLISECONDS);
    }

    public final void stopTabListTask() {
        if (this.task == null) {
            System.out.println((Object)"Can't stop tablist task because it is not initialized");
            return;
        }
        ScheduledTask scheduledTask = this.task;
        if (scheduledTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"task");
            scheduledTask = null;
        }
        scheduledTask.cancel();
    }

    public final void updateTabListForPlayer(@NotNull ProxiedPlayer player) {
        Object v0;
        TabListGroup group;
        Iterable iterable;
        String serviceName;
        TabListConfiguration configuration;
        block10: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            if (player.getServer() == null) {
                return;
            }
            if (player.getServer().getInfo() == null) {
                return;
            }
            configuration = this.plugin.getProxyPlugin().getTabListConfiguration();
            serviceName = player.getServer().getInfo().getName();
            iterable = configuration.getGroups();
            for (Object t : iterable) {
                group = (TabListGroup)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)serviceName);
                if (!StringsKt.startsWith((String)serviceName, (String)group.getGroupOrService(), (boolean)true)) continue;
                v0 = t;
                break block10;
            }
            v0 = null;
        }
        TabListGroup tabListGroup = v0;
        if (tabListGroup == null) {
            Object v1;
            block11: {
                iterable = configuration.getGroups();
                for (Object t : iterable) {
                    group = (TabListGroup)t;
                    boolean bl = false;
                    if (!StringsKt.equals((String)group.getGroupOrService(), (String)serviceName, (boolean)true)) continue;
                    v1 = t;
                    break block11;
                }
                v1 = null;
            }
            tabListGroup = v1;
        }
        if (tabListGroup == null) {
            Object v2;
            block12: {
                iterable = configuration.getGroups();
                for (Object t : iterable) {
                    group = (TabListGroup)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)group.getGroupOrService(), (Object)"*")) continue;
                    v2 = t;
                    break block12;
                }
                v2 = null;
            }
            tabListGroup = v2;
        }
        if (tabListGroup == null || tabListGroup.getTabLists().isEmpty()) {
            return;
        }
        if (tabListGroup.getTabLists().size() <= ((Number)this.tabListIndex.getOrDefault(tabListGroup.getGroupOrService(), 0)).intValue() + 1) {
            this.tabListIndex.put(tabListGroup.getGroupOrService(), 0);
        }
        if (!this.tabListIndex.containsKey(tabListGroup.getGroupOrService())) {
            this.tabListIndex.put(tabListGroup.getGroupOrService(), 0);
        }
        TabList tabList = tabListGroup.getTabLists().get(((Number)this.tabListIndex.getOrDefault(tabListGroup.getGroupOrService(), 0)).intValue());
        String header = CollectionsKt.joinToString$default((Iterable)tabList.getHeader(), (CharSequence)"<newline>", null, null, (int)0, null, null, (int)62, null);
        String footer = CollectionsKt.joinToString$default((Iterable)tabList.getFooter(), (CharSequence)"<newline>", null, null, (int)0, null, null, (int)62, null);
        Audience audience = this.plugin.adventure().player(player);
        Intrinsics.checkNotNullExpressionValue((Object)audience, (String)"player(...)");
        Audience audience2 = audience;
        audience2.sendPlayerListHeaderAndFooter(this.plugin.deserializeToComponent(header, player), this.plugin.deserializeToComponent(footer, player));
    }

    private static final void startTabListTask$lambda$2(TabListHandler this$0) {
        Object element$iv;
        Collection collection = this$0.plugin.getProxy().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPlayers(...)");
        Object $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            ProxiedPlayer it = (ProxiedPlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this$0.updateTabListForPlayer(it);
        }
        $this$forEach$iv = this$0.tabListIndex;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            String key = (String)object.getKey();
            int value = ((Number)object.getValue()).intValue();
            this$0.tabListIndex.put(key, value + 1);
        }
    }
}

