/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.proxy.relocate.spongepowered.configurate;

import app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.AutoValue_ConfigurationOptions;
import app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.serialize.TypeSerializerCollection;
import app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.util.MapFactories;
import app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.util.MapFactory;
import app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.util.Types;
import app.simplecloud.plugin.proxy.relocate.spongepowered.configurate.util.UnmodifiableCollections;
import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

@CheckReturnValue
@AutoValue
public abstract class ConfigurationOptions {
    ConfigurationOptions() {
    }

    public static ConfigurationOptions defaults() {
        return Lazy.DEFAULTS;
    }

    public abstract MapFactory mapFactory();

    public ConfigurationOptions mapFactory(MapFactory mapFactory) {
        Objects.requireNonNull(mapFactory, "mapFactory");
        if (this.mapFactory() == mapFactory) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(mapFactory, this.header(), this.serializers(), this.nativeTypes(), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public abstract @Nullable String header();

    public ConfigurationOptions header(@Nullable String header) {
        if (Objects.equals(this.header(), header)) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), header, this.serializers(), this.nativeTypes(), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public abstract TypeSerializerCollection serializers();

    public ConfigurationOptions serializers(TypeSerializerCollection serializers) {
        Objects.requireNonNull(serializers, "serializers");
        if (this.serializers().equals(serializers)) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), serializers, this.nativeTypes(), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public final ConfigurationOptions serializers(Consumer<TypeSerializerCollection.Builder> serializerBuilder) {
        Objects.requireNonNull(serializerBuilder, "serializerBuilder");
        TypeSerializerCollection.Builder builder = this.serializers().childBuilder();
        serializerBuilder.accept(builder);
        return this.serializers(builder.build());
    }

    abstract @Nullable Set<Class<?>> nativeTypes();

    public ConfigurationOptions nativeTypes(@Nullable Set<Class<?>> nativeTypes) {
        if (Objects.equals(this.nativeTypes(), nativeTypes)) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), this.serializers(), nativeTypes == null ? null : UnmodifiableCollections.copyOf(nativeTypes), this.shouldCopyDefaults(), this.implicitInitialization());
    }

    public final boolean acceptsType(Class<?> type) {
        Objects.requireNonNull(type, "type");
        @Nullable Set<Class<?>> nativeTypes = this.nativeTypes();
        if (nativeTypes == null) {
            return true;
        }
        if (nativeTypes.contains(type)) {
            return true;
        }
        if (type.isPrimitive() && nativeTypes.contains(Types.box(type))) {
            return true;
        }
        Type unboxed = Types.unbox(type);
        if (unboxed != type && nativeTypes.contains(unboxed)) {
            return true;
        }
        for (Class<?> clazz : nativeTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean shouldCopyDefaults();

    public ConfigurationOptions shouldCopyDefaults(boolean shouldCopyDefaults) {
        if (this.shouldCopyDefaults() == shouldCopyDefaults) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), this.serializers(), this.nativeTypes(), shouldCopyDefaults, this.implicitInitialization());
    }

    public abstract boolean implicitInitialization();

    public ConfigurationOptions implicitInitialization(boolean implicitInitialization) {
        if (this.implicitInitialization() == implicitInitialization) {
            return this;
        }
        return new AutoValue_ConfigurationOptions(this.mapFactory(), this.header(), this.serializers(), this.nativeTypes(), this.shouldCopyDefaults(), implicitInitialization);
    }

    static class Lazy {
        static final ConfigurationOptions DEFAULTS = new AutoValue_ConfigurationOptions(MapFactories.insertionOrdered(), null, TypeSerializerCollection.defaults(), null, true, true);

        Lazy() {
        }
    }
}

