/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.kyori.adventure.text.serializer.gson;

import app.simplecloud.relocate.kyori.adventure.util.Index;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

final class IndexedSerializer<E>
extends TypeAdapter<E> {
    private final String name;
    private final Index<String, E> map;
    private final boolean throwOnUnknownKey;

    public static <E> TypeAdapter<E> strict(String name, Index<String, E> map2) {
        return new IndexedSerializer<E>(name, map2, true).nullSafe();
    }

    public static <E> TypeAdapter<E> lenient(String name, Index<String, E> map2) {
        return new IndexedSerializer<E>(name, map2, false).nullSafe();
    }

    private IndexedSerializer(String name, Index<String, E> map2, boolean throwOnUnknownKey) {
        this.name = name;
        this.map = map2;
        this.throwOnUnknownKey = throwOnUnknownKey;
    }

    public void write(JsonWriter out, E value) throws IOException {
        out.value(this.map.key(value));
    }

    public E read(JsonReader in) throws IOException {
        String string = in.nextString();
        E value = this.map.value(string);
        if (value != null) {
            return value;
        }
        if (this.throwOnUnknownKey) {
            throw new JsonParseException("invalid " + this.name + ":  " + string);
        }
        return null;
    }
}

