/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.proxy.relocate.incendo.cloud.velocity.parser;

import app.simplecloud.plugin.proxy.relocate.incendo.cloud.brigadier.suggestion.TooltipSuggestion;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.caption.CaptionVariable;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.component.CommandComponent;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.context.CommandContext;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.context.CommandInput;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.exception.parsing.ParserException;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.parser.ArgumentParseResult;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.parser.ArgumentParser;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.parser.ParserDescriptor;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.suggestion.BlockingSuggestionProvider;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.suggestion.Suggestion;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.velocity.VelocityCaptionKeys;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.velocity.VelocityContextKeys;
import com.mojang.brigadier.Message;
import com.velocitypowered.api.command.VelocityBrigadierMessage;
import com.velocitypowered.api.proxy.Player;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PlayerParser<C>
implements ArgumentParser<C, Player>,
BlockingSuggestionProvider<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Player> playerParser() {
        return ParserDescriptor.of(new PlayerParser<C>(), Player.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, Player> playerComponent() {
        return CommandComponent.builder().parser(PlayerParser.playerParser());
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull Player> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        Player player = commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getPlayer(input).orElse(null);
        if (player == null) {
            return ArgumentParseResult.failure(new PlayerParseException(input, commandContext));
        }
        return ArgumentParseResult.success(player);
    }

    @Override
    public @NonNull Iterable<? extends @NonNull Suggestion> suggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return commandContext.get(VelocityContextKeys.PROXY_SERVER_KEY).getAllPlayers().stream().map(player -> TooltipSuggestion.suggestion(player.getUsername(), (Message)VelocityBrigadierMessage.tooltip((Component)Component.text((String)player.getUniqueId().toString())))).collect(Collectors.toList());
    }

    public static final class PlayerParseException
    extends ParserException {
        private PlayerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(PlayerParser.class, context, VelocityCaptionKeys.ARGUMENT_PARSE_FAILURE_PLAYER, CaptionVariable.of("input", input));
        }
    }
}

