/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.plugin.proxy.velocity;

import app.simplecloud.plugin.proxy.relocate.incendo.cloud.SenderMapper;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.execution.ExecutionCoordinator;
import app.simplecloud.plugin.proxy.relocate.incendo.cloud.velocity.VelocityCommandManager;
import app.simplecloud.plugin.proxy.shared.ProxyPlugin;
import app.simplecloud.plugin.proxy.shared.handler.command.CommandSender;
import app.simplecloud.plugin.proxy.shared.handler.command.JoinStateCommandHandler;
import app.simplecloud.plugin.proxy.velocity.VelocityCommandSender;
import app.simplecloud.plugin.proxy.velocity.event.ConfigureTagResolversEvent;
import app.simplecloud.plugin.proxy.velocity.handler.TabListHandler;
import app.simplecloud.plugin.proxy.velocity.listener.ConfigureTagResolversListener;
import app.simplecloud.plugin.proxy.velocity.listener.ProxyPingListener;
import app.simplecloud.plugin.proxy.velocity.listener.ServerPreConnectListener;
import com.google.inject.Inject;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020#H\u0007J\u001a\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lapp/simplecloud/plugin/proxy/velocity/ProxyVelocityPlugin;", "Lapp/simplecloud/plugin/proxy/shared/ProxyPlugin;", "proxyServer", "Lcom/velocitypowered/api/proxy/ProxyServer;", "dataDirectory", "Ljava/nio/file/Path;", "logger", "Lorg/slf4j/Logger;", "pluginContainer", "Lcom/velocitypowered/api/plugin/PluginContainer;", "<init>", "(Lcom/velocitypowered/api/proxy/ProxyServer;Ljava/nio/file/Path;Lorg/slf4j/Logger;Lcom/velocitypowered/api/plugin/PluginContainer;)V", "getProxyServer", "()Lcom/velocitypowered/api/proxy/ProxyServer;", "getDataDirectory", "()Ljava/nio/file/Path;", "getLogger", "()Lorg/slf4j/Logger;", "getPluginContainer", "()Lcom/velocitypowered/api/plugin/PluginContainer;", "tabListHandler", "Lapp/simplecloud/plugin/proxy/velocity/handler/TabListHandler;", "getTabListHandler", "()Lapp/simplecloud/plugin/proxy/velocity/handler/TabListHandler;", "commandManager", "Lapp/simplecloud/plugin/proxy/relocate/incendo/cloud/velocity/VelocityCommandManager;", "Lapp/simplecloud/plugin/proxy/shared/handler/command/CommandSender;", "miniMessage", "Lnet/kyori/adventure/text/minimessage/MiniMessage;", "Lorg/jetbrains/annotations/NotNull;", "onProxyInitialize", "", "event", "Lcom/velocitypowered/api/event/proxy/ProxyInitializeEvent;", "onProxyShutdown", "Lcom/velocitypowered/api/event/proxy/ProxyShutdownEvent;", "deserializeToComponent", "Lnet/kyori/adventure/text/Component;", "text", "", "player", "Lcom/velocitypowered/api/proxy/Player;", "proxy-velocity"})
@SourceDebugExtension(value={"SMAP\nProxyVelocityPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyVelocityPlugin.kt\napp/simplecloud/plugin/proxy/velocity/ProxyVelocityPlugin\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,90:1\n37#2,2:91\n*S KotlinDebug\n*F\n+ 1 ProxyVelocityPlugin.kt\napp/simplecloud/plugin/proxy/velocity/ProxyVelocityPlugin\n*L\n86#1:91,2\n*E\n"})
public final class ProxyVelocityPlugin
extends ProxyPlugin {
    @NotNull
    private final ProxyServer proxyServer;
    @NotNull
    private final Path dataDirectory;
    @NotNull
    private final Logger logger;
    @NotNull
    private final PluginContainer pluginContainer;
    @NotNull
    private final TabListHandler tabListHandler;
    private VelocityCommandManager<CommandSender> commandManager;
    @NotNull
    private final MiniMessage miniMessage;

    @Inject
    public ProxyVelocityPlugin(@NotNull ProxyServer proxyServer, @DataDirectory @NotNull Path dataDirectory, @NotNull Logger logger, @NotNull PluginContainer pluginContainer) {
        Intrinsics.checkNotNullParameter((Object)proxyServer, (String)"proxyServer");
        Intrinsics.checkNotNullParameter((Object)dataDirectory, (String)"dataDirectory");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)pluginContainer, (String)"pluginContainer");
        super(((Object)dataDirectory).toString());
        this.proxyServer = proxyServer;
        this.dataDirectory = dataDirectory;
        this.logger = logger;
        this.pluginContainer = pluginContainer;
        this.tabListHandler = new TabListHandler(this);
        MiniMessage miniMessage = MiniMessage.miniMessage();
        Intrinsics.checkNotNullExpressionValue((Object)miniMessage, (String)"miniMessage(...)");
        this.miniMessage = miniMessage;
    }

    @NotNull
    public final ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    @NotNull
    public final Path getDataDirectory() {
        return this.dataDirectory;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    @NotNull
    public final TabListHandler getTabListHandler() {
        return this.tabListHandler;
    }

    @Subscribe
    public final void onProxyInitialize(@NotNull ProxyInitializeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.getConfig().save("tablist", this.getTabListConfiguration());
        this.getConfig().save("placeholder", this.getPlaceHolderConfiguration());
        this.getConfig().save("messages", this.getMessagesConfiguration());
        this.getConfig().save("joinstate", this.getJoinStateConfiguration());
        this.getMotdLayoutHandler().loadMotdLayouts();
        this.proxyServer.getEventManager().register((Object)this, (Object)new ProxyPingListener(this));
        this.proxyServer.getEventManager().register((Object)this, (Object)new ConfigureTagResolversListener(this));
        this.proxyServer.getEventManager().register((Object)this, (Object)new ServerPreConnectListener(this));
        if (this.getTabListConfiguration().get().getTabListUpdateTime() > 0L) {
            this.tabListHandler.startTabListTask();
        } else {
            this.logger.info("Tablist update time is set to 0, tablist will not be updated automatically");
        }
        ExecutionCoordinator executionCoordinator = ExecutionCoordinator.simpleCoordinator();
        Intrinsics.checkNotNullExpressionValue(executionCoordinator, (String)"simpleCoordinator(...)");
        ExecutionCoordinator executionCoordinator2 = executionCoordinator;
        SenderMapper<CommandSource, CommandSender> senderMapper = SenderMapper.create(arg_0 -> ProxyVelocityPlugin.onProxyInitialize$lambda$0(this, arg_0), ProxyVelocityPlugin::onProxyInitialize$lambda$1);
        Intrinsics.checkNotNullExpressionValue(senderMapper, (String)"create(...)");
        SenderMapper<CommandSource, CommandSender> senderMapper2 = senderMapper;
        this.commandManager = new VelocityCommandManager<CommandSender>(this.pluginContainer, this.proxyServer, executionCoordinator2, senderMapper2);
        VelocityCommandManager<CommandSender> velocityCommandManager = this.commandManager;
        if (velocityCommandManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"commandManager");
            velocityCommandManager = null;
        }
        JoinStateCommandHandler proxyCommandHandler = new JoinStateCommandHandler(velocityCommandManager, this);
        proxyCommandHandler.loadCommands();
    }

    @Subscribe
    public final void onProxyShutdown(@NotNull ProxyShutdownEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.tabListHandler.stopTabListTask();
    }

    @NotNull
    public final Component deserializeToComponent(@NotNull String text, @Nullable Player player) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ConfigureTagResolversEvent configureTagResolversEvent = (ConfigureTagResolversEvent)this.proxyServer.getEventManager().fire((Object)new ConfigureTagResolversEvent(player, null, 2, null)).get();
        Collection $this$toTypedArray$iv = configureTagResolversEvent.getTagResolvers();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TagResolver[] tagResolverArray = thisCollection$iv.toArray(new TagResolver[0]);
        Component component = this.miniMessage.deserialize(text, Arrays.copyOf(tagResolverArray, tagResolverArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"deserialize(...)");
        return component;
    }

    public static /* synthetic */ Component deserializeToComponent$default(ProxyVelocityPlugin proxyVelocityPlugin, String string, Player player, int n, Object object) {
        if ((n & 2) != 0) {
            player = null;
        }
        return proxyVelocityPlugin.deserializeToComponent(string, player);
    }

    private static final CommandSender onProxyInitialize$lambda$0(ProxyVelocityPlugin this$0, CommandSource commandSender) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        return new VelocityCommandSender(commandSender, this$0);
    }

    private static final CommandSource onProxyInitialize$lambda$1(CommandSender commandSender) {
        Intrinsics.checkNotNullParameter((Object)commandSender, (String)"commandSender");
        return ((VelocityCommandSender)commandSender).getCommandSource();
    }
}

