/*
 * Decompiled with CFR 0.152.
 */
package net.elton.modifiedtornadodamage.mixin;

import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.block.ModBlocks;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.entity.ModEntities;
import dev.protomanly.pmweather.entity.MovingBlock;
import dev.protomanly.pmweather.weather.Storm;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.protomanly.pmweather.weather.WindEngine;
import net.elton.modifiedtornadodamage.DamageConfig;
import net.elton.modifiedtornadodamage.DamageUtil.DamageUtil;
import net.elton.modifiedtornadodamage.ModifiedTornadoDamage;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Storm.class})
public class StormMixin {
    private boolean pmwExtraLoaded = ModifiedTornadoDamage.CommonModEvents.pmwExtraIsLoaded;
    Entity entity;
    @Shadow
    public Level level;
    public WeatherHandler weatherHandler;

    @ModifyVariable(method={"doDamage"}, at=@At(value="HEAD"), argsOnly=true, index=3)
    private double newEltonWind(double windEffect, LevelChunk levelChunk, BlockPos blockPosTop) {
        if (!this.pmwExtraLoaded && DamageConfig.realWindDamage) {
            windEffect = WindEngine.getWind((Vec3)new Vec3((double)blockPosTop.getX(), (double)blockPosTop.getY(), (double)blockPosTop.getZ()), (Level)this.level, (boolean)false, (boolean)false, (boolean)false, (boolean)true).length();
        }
        if (!DamageConfig.blockDestruction) {
            windEffect = 0.0;
        }
        return windEffect;
    }

    @ModifyConstant(method={"doDamage"}, constant={@Constant(doubleValue=200.0)})
    private double scourHeavy(double scour_heavy) {
        int s = 999999;
        if (DamageConfig.groundScouring) {
            s = 250;
        }
        return s;
    }

    @ModifyConstant(method={"doDamage"}, constant={@Constant(doubleValue=140.0)})
    private double scourLight(double scour_light) {
        int s = 999999;
        if (DamageConfig.groundScouring) {
            s = 150;
        }
        return s;
    }

    @ModifyConstant(method={"doDamage"}, constant={@Constant(doubleValue=170.0)})
    private double scourMedium(double scour_medium) {
        int s = 999999;
        if (DamageConfig.groundScouring) {
            s = 200;
        }
        return s;
    }

    @ModifyConstant(method={"getBlockStrength"}, constant={@Constant(floatValue=60.0f)})
    private static float modifyStrength(float blockstrength_factor) {
        return (float)DamageConfig.blockstrengthModifier * blockstrength_factor;
    }

    @ModifyVariable(method={"tick"}, at=@At(value="STORE"))
    private boolean cancelDamage(boolean cancelDamage) {
        if (!DamageConfig.blockDestruction) {
            cancelDamage = false;
        }
        return cancelDamage;
    }

    @Inject(method={"pull (Lnet/minecraft/world/entity/Entity;F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void injected(Entity entity, float multiplier, CallbackInfo ci) {
        if (!DamageConfig.entityGrabbing) {
            ci.cancel();
        }
    }

    @Inject(method={"doDamage"}, at={@At(value="RETURN")}, cancellable=true)
    private void TwoFaceRule(LevelChunk chunk, BlockPos blockPosTop, double windEffect, float percAdj, int windfieldWidth, CallbackInfo callbackInfo) {
        if (DamageConfig.modGrabbing) {
            if (DamageConfig.overhangGrabbing && windEffect > 130.0) {
                int height = Math.clamp((long)(blockPosTop.getY() + 64), 0, (int)DamageConfig.downScanning);
                for (int i = 1; i < height; ++i) {
                    if (PMWeather.RANDOM.nextInt(7) != 3) continue;
                    BlockPos blockPosBelow = blockPosTop.below(i);
                    BlockPos blockPosBelow2 = null;
                    if (DamageUtil.canWindAffectLight(blockPosBelow.getCenter(), this.level) || windEffect > 250.0 && (DamageUtil.canWindAffectHeavy(blockPosBelow.getCenter(), this.level) || DamageUtil.canWindAffectLight(blockPosBelow.getCenter(), this.level))) {
                        blockPosBelow2 = blockPosBelow;
                    }
                    if (blockPosBelow2 == null) continue;
                    BlockState stateBelow = chunk.getBlockState(blockPosBelow2);
                    Block blockBelow = stateBelow.getBlock();
                    float blockStrengthBelow = Storm.getBlockStrength((Block)blockBelow, (Level)this.level, (BlockPos)blockPosBelow2);
                    if (ServerConfig.blockStrengths.containsKey(blockBelow)) {
                        blockStrengthBelow = ((Float)ServerConfig.blockStrengths.get(blockBelow)).floatValue();
                    }
                    if (DamageConfig.doorOpening && (stateBelow.is(BlockTags.DOORS) || stateBelow.is(BlockTags.TRAPDOORS)) && PMWeather.RANDOM.nextInt(2) == 1) {
                        if (stateBelow.is(BlockTags.MOB_INTERACTABLE_DOORS) || stateBelow.is(BlockTags.WOODEN_TRAPDOORS)) {
                            BlockState door = (BlockState)stateBelow.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(true));
                            this.level.setBlockAndUpdate(blockPosBelow2, door);
                            return;
                        }
                        if (windEffect >= 170.0 && !stateBelow.is(BlockTags.WOODEN_DOORS)) {
                            BlockState door = (BlockState)stateBelow.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(true));
                            this.level.setBlockAndUpdate(blockPosBelow2, door);
                            return;
                        }
                        if (windEffect >= 200.0 && stateBelow.is(BlockTags.TRAPDOORS) && !stateBelow.is(BlockTags.WOODEN_TRAPDOORS)) {
                            BlockState door = (BlockState)stateBelow.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(true));
                            this.level.setBlockAndUpdate(blockPosBelow2, door);
                            return;
                        }
                    }
                    if (stateBelow.isAir() || !(blockBelow.defaultDestroyTime() >= 0.0f) || ServerConfig.blacklistedBlocks.contains(blockBelow)) continue;
                    boolean blacklistedBelow = false;
                    for (TagKey tag : ServerConfig.blacklistedBlockTags) {
                        if (!blockBelow.defaultBlockState().is(tag)) continue;
                        blacklistedBelow = true;
                        break;
                    }
                    if (windEffect >= (double)blockStrengthBelow && blockBelow.defaultDestroyTime() > 0.0f && !ServerConfig.blacklistedBlocks.contains(blockBelow) && !blacklistedBelow && stateBelow.getFluidState().isEmpty()) {
                        this.level.removeBlock(blockPosBelow2, false);
                        continue;
                    }
                    if (!(windEffect >= (double)blockStrengthBelow) || !(blockBelow.defaultDestroyTime() > 0.0f) || ServerConfig.blacklistedBlocks.contains(blockBelow) || !blacklistedBelow || !stateBelow.getFluidState().isEmpty() || !DamageConfig.dirtGrabbing) continue;
                    BlockState aboveState = chunk.getBlockState(blockPosBelow2.above());
                    BlockState belowState = chunk.getBlockState(blockPosBelow2.below());
                    BlockState eastState = chunk.getBlockState(blockPosBelow2.east());
                    BlockState westState = chunk.getBlockState(blockPosBelow2.west());
                    BlockState northState = chunk.getBlockState(blockPosBelow2.north());
                    BlockState southState = chunk.getBlockState(blockPosBelow2.south());
                    BlockState belowState2 = chunk.getBlockState(blockPosBelow2.below(2));
                    BlockState eastState2 = chunk.getBlockState(blockPosBelow2.east(2));
                    BlockState westState2 = chunk.getBlockState(blockPosBelow2.west(2));
                    BlockState northState2 = chunk.getBlockState(blockPosBelow2.north(2));
                    BlockState southState2 = chunk.getBlockState(blockPosBelow2.south(2));
                    if (aboveState.isAir() && belowState.isAir() || southState.isAir() && northState.isAir() || eastState.isAir() && westState.isAir()) {
                        this.level.removeBlock(blockPosBelow2, false);
                    }
                    if (!(windEffect > 270.0) || !(aboveState.isAir() && belowState2.isAir() || southState2.isAir() && northState.isAir() || southState.isAir() && northState2.isAir() || eastState2.isAir() && westState.isAir()) && (!eastState.isAir() || !westState2.isAir())) continue;
                    this.level.removeBlock(blockPosBelow2, false);
                }
            }
            if (DamageConfig.dirtGrabbing) {
                BlockState state = chunk.getBlockState(blockPosTop);
                Block block = state.getBlock();
                float blockStrength = Storm.getBlockStrength((Block)block, (Level)this.level, (BlockPos)blockPosTop);
                if (ServerConfig.blockStrengths.containsKey(block)) {
                    blockStrength = ((Float)ServerConfig.blockStrengths.get(block)).floatValue();
                }
                if (DamageConfig.groundScouring) {
                    if (block.defaultDestroyTime() >= 0.0f && !ServerConfig.blacklistedBlocks.contains(block) && state.is(Blocks.MOSS_BLOCK)) {
                        double percChance = Math.clamp((windEffect - 140.0) / 80.0, 0.0, 1.0);
                        if ((double)PMWeather.RANDOM.nextFloat() <= percChance * (double)(0.02f * percAdj)) {
                            this.level.setBlockAndUpdate(blockPosTop, Blocks.DIRT.defaultBlockState());
                            return;
                        }
                    }
                    boolean blacklisted = true;
                    for (TagKey tag : ServerConfig.blacklistedBlockTags) {
                        if (!block.defaultBlockState().is(tag)) continue;
                        blacklisted = false;
                        break;
                    }
                    if (state.is(Blocks.DIRT) || state.is(Blocks.GRASS_BLOCK) || state.is((Block)ModBlocks.SCOURED_GRASS.get()) || state.is((Block)ModBlocks.MEDIUM_SCOURING.get()) || state.is((Block)ModBlocks.HEAVY_SCOURING.get())) {
                        blacklisted = false;
                    }
                    if (!state.isAir() && windEffect >= (double)blockStrength && block.defaultDestroyTime() > 0.0f && !ServerConfig.blacklistedBlocks.contains(block) && !blacklisted && state.getFluidState().isEmpty()) {
                        MovingBlock movingBlock;
                        BlockState aboveState = chunk.getBlockState(blockPosTop.above());
                        BlockState belowState = chunk.getBlockState(blockPosTop.below());
                        BlockState eastState = chunk.getBlockState(blockPosTop.east());
                        BlockState westState = chunk.getBlockState(blockPosTop.west());
                        BlockState northState = chunk.getBlockState(blockPosTop.north());
                        BlockState southState = chunk.getBlockState(blockPosTop.south());
                        BlockState belowState2 = chunk.getBlockState(blockPosTop.below(2));
                        BlockState eastState2 = chunk.getBlockState(blockPosTop.east(2));
                        BlockState westState2 = chunk.getBlockState(blockPosTop.west(2));
                        BlockState northState2 = chunk.getBlockState(blockPosTop.north(2));
                        BlockState southState2 = chunk.getBlockState(blockPosTop.south(2));
                        if ((aboveState.isAir() && belowState.isAir() || southState.isAir() && northState.isAir() || eastState.isAir() && westState.isAir()) && (movingBlock = (MovingBlock)((EntityType)ModEntities.MOVING_BLOCK.get()).create(this.level)) != null) {
                            movingBlock.setStartPos(blockPosTop);
                            movingBlock.setBlockState(state);
                            movingBlock.setPos((double)blockPosTop.getX(), (double)blockPosTop.getY(), (double)blockPosTop.getZ());
                            this.level.removeBlock(blockPosTop, false);
                            Player nearest = this.level.getNearestPlayer((double)blockPosTop.getX(), (double)blockPosTop.getY(), (double)blockPosTop.getZ(), 128.0, false);
                            if (PMWeather.RANDOM.nextInt(Math.max(1, windfieldWidth / 10)) == 0 && nearest != null && nearest.position().distanceTo(blockPosTop.getCenter()) < 128.0) {
                                if (this.level.isLoaded(blockPosTop)) {
                                    this.level.addFreshEntity((Entity)movingBlock);
                                } else {
                                    movingBlock.discard();
                                }
                            } else {
                                movingBlock.discard();
                            }
                        }
                        if (windEffect > 270.0 && (aboveState.isAir() && belowState2.isAir() || southState2.isAir() && northState.isAir() || southState.isAir() && northState2.isAir() || eastState2.isAir() && westState.isAir() || eastState.isAir() && westState2.isAir())) {
                            this.level.removeBlock(blockPosTop, false);
                        }
                    }
                }
            }
        }
    }
}

