/*
 * Decompiled with CFR 0.152.
 */
package net.elton.modifiedtornadodamage;

import net.elton.modifiedtornadodamage.ModifiedTornadoDamage;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="modifiedtornadodamage", bus=EventBusSubscriber.Bus.MOD)
public class DamageConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue BLOCK_DESTRUCTION;
    public static boolean blockDestruction;
    private static final ModConfigSpec.BooleanValue ENTITY_GRABBING;
    public static boolean entityGrabbing;
    private static final ModConfigSpec.BooleanValue OVERHANG_GRABBING;
    public static boolean overhangGrabbing;
    private static final ModConfigSpec.BooleanValue DIRT_GRABBING;
    public static boolean dirtGrabbing;
    private static final ModConfigSpec.BooleanValue GROUND_SCOURING;
    public static boolean groundScouring;
    private static final ModConfigSpec.BooleanValue DOOR_OPENING;
    public static boolean doorOpening;
    private static final ModConfigSpec.BooleanValue MOD_GRABBING;
    public static boolean modGrabbing;
    private static final ModConfigSpec.BooleanValue REAL_WIND_DAMAGE;
    public static boolean realWindDamage;
    private static final ModConfigSpec.BooleanValue WIND_ADJUST;
    public static boolean windAdjust;
    private static final ModConfigSpec.BooleanValue WIND_GUSTS;
    public static boolean windGusts;
    private static final ModConfigSpec.DoubleValue BLOCKSTRENGTH_MODIFIER;
    public static double blockstrengthModifier;
    private static final ModConfigSpec.IntValue DOWN_SCANNING;
    public static double downScanning;
    public static final ModConfigSpec SPEC;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC && !(event instanceof ModConfigEvent.Unloading)) {
            blockDestruction = (Boolean)BLOCK_DESTRUCTION.get();
            modGrabbing = (Boolean)MOD_GRABBING.get();
            entityGrabbing = (Boolean)ENTITY_GRABBING.get();
            dirtGrabbing = (Boolean)DIRT_GRABBING.get();
            overhangGrabbing = (Boolean)OVERHANG_GRABBING.get();
            realWindDamage = (Boolean)REAL_WIND_DAMAGE.get();
            windAdjust = (Boolean)WIND_ADJUST.get();
            windGusts = (Boolean)WIND_GUSTS.get();
            blockstrengthModifier = (Double)BLOCKSTRENGTH_MODIFIER.get();
            downScanning = ((Integer)DOWN_SCANNING.get()).intValue();
            doorOpening = (Boolean)DOOR_OPENING.get();
            groundScouring = (Boolean)GROUND_SCOURING.get();
        }
    }

    static {
        String message = "Whether tornadoes pick up blocks based on winds that anemometers see. This option has more accurate damage. Tornadoes can also stack.";
        if (ModifiedTornadoDamage.CommonModEvents.pmwExtraIsLoaded) {
            message = "PMW Extra is loaded, this option is ignored here, set it in the Extra config: Enhanced damage";
        }
        BLOCK_DESTRUCTION = BUILDER.comment("Turn all block destruction on or off").define("blockdestruction", true);
        MOD_GRABBING = BUILDER.comment("Turns on/off all additional methods for block grabbing").define("modgrabbing", true);
        ENTITY_GRABBING = BUILDER.comment("Turns on/off all living entity grabbing").define("modentitygrabbing", true);
        DIRT_GRABBING = BUILDER.comment("Adds some methods for blacklisted tags block grabbing (dirt)").define("dirtgrabbing", true);
        OVERHANG_GRABBING = BUILDER.comment("Enables block grabbing under overhangs").define("overhanggrabbing", true);
        GROUND_SCOURING = BUILDER.comment("Enables ground scouring (does not disable block grabbing)").define("groundscouring", true);
        REAL_WIND_DAMAGE = BUILDER.comment(message).define("realwinddamage", true);
        DOOR_OPENING = BUILDER.comment("If tornadoes are able to swing open the doors. If under overhang grabbing is disabled, this is also disabled").define("dooropening", true);
        WIND_GUSTS = BUILDER.comment("Enables wind gusts and more wind variance by height. Makes building in mountains more dangerous").define("windgusts", true);
        WIND_ADJUST = BUILDER.comment("Whether winds that anemometers see are closer to the tornadic destruction winds by value. This option is better for performance but less accurate. Tornadoes cannot stack. Real wind damage overrides this").define("windadjust", false);
        DOWN_SCANNING = BUILDER.comment("When trying to do destruction under overhangs, how far down from the roof should tornadoes scan blocks. Higher value will cause destruction in lower areas but lag much more").defineInRange("downscanning", 20, 0, 310);
        BLOCKSTRENGTH_MODIFIER = BUILDER.comment("Multiplier of block strengths").defineInRange("blockstrengthmultiplier", 1.0, 0.8, 1.5);
        SPEC = BUILDER.build();
    }
}

