/*
 * Decompiled with CFR 0.152.
 */
package net.elton.modifiedtornadodamage.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.protomanly.pmweather.weather.WindEngine;
import net.elton.modifiedtornadodamage.DamageConfig;
import net.elton.modifiedtornadodamage.event.GameBusEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={WindEngine.class})
public class WindEngineMixin {
    private static int max_height;
    private static Level level1;
    private Vec3 reading_position;

    @Inject(method={"getWind (Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;ZZZZ)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void injected(Vec3 position, Level level, boolean ignoreStorms, boolean ignoreTornadoes, boolean windCheck, boolean windAnyway, CallbackInfoReturnable ci) {
    }

    @Redirect(method={"getWind (Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;ZZZZ)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="net/minecraft/world/phys/Vec3.lerp (Lnet/minecraft/world/phys/Vec3;D)Lnet/minecraft/world/phys/Vec3;"), remap=false, order=10002)
    private static Vec3 ModifyWindMixin(Vec3 wind, Vec3 tornadicWind, double tornadicEffect, @Local(ordinal=0) Vec3 position, @Local(ordinal=0) Level level) {
        BlockPos pos = new BlockPos((int)position.x, (int)position.y, (int)position.z);
        max_height = level.getMaxBuildHeight();
        if (DamageConfig.windAdjust && !DamageConfig.realWindDamage) {
            tornadicEffect = Math.clamp(tornadicEffect, 0.0, 0.7);
        }
        wind = wind.lerp(tornadicWind, tornadicEffect);
        if (DamageConfig.windGusts) {
            double height_factor = 1.0;
            if (position.y != (double)(max_height + 1)) {
                boolean mountain_biome = level.getBiome(pos).is(BiomeTags.IS_MOUNTAIN);
                if (mountain_biome) {
                    if (position.y > 64.0) {
                        height_factor = Math.pow((Math.clamp(position.y, 64.0, 2000.0) - 14.0) / 50.0, 0.2);
                    }
                } else if (position.y > 64.0) {
                    height_factor = Math.pow((Math.clamp(position.y, 64.0, 2000.0) - 14.0) / 50.0, 0.143);
                }
                wind = wind.multiply(height_factor, 1.0, height_factor);
                if (GameBusEvents.gustTimeCounter > 0L) {
                    double windspeed = wind.length();
                    double factor_x = GameBusEvents.windx_mod_main <= 1.0 ? 1.0 / (GameBusEvents.windx_mod_incr * GameBusEvents.windx_mod_incr_times * Math.pow(windspeed, -0.402) + 1.0) : 1.0 + GameBusEvents.windx_mod_incr * GameBusEvents.windx_mod_incr_times * Math.pow(windspeed, -0.402);
                    double factor_z = GameBusEvents.windz_mod_main <= 1.0 ? 1.0 / (GameBusEvents.windz_mod_incr * GameBusEvents.windz_mod_incr_times * Math.pow(windspeed, -0.402) + 1.0) : 1.0 + GameBusEvents.windz_mod_incr * GameBusEvents.windz_mod_incr_times * Math.pow(windspeed, -0.402);
                    if (mountain_biome) {
                        factor_x *= factor_x;
                        factor_z *= factor_z;
                    }
                    wind = wind.multiply(factor_x, 1.0, factor_z);
                }
            }
        }
        if (Double.isNaN(wind.length())) {
            wind = new Vec3(1.0, 0.0, 1.0);
        }
        return wind;
    }
}

