/*
 * Decompiled with CFR 0.152.
 */
package net.elton.modifiedtornadodamage.DestructionMethods;

import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.block.ModBlocks;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.entity.ModEntities;
import dev.protomanly.pmweather.entity.MovingBlock;
import dev.protomanly.pmweather.weather.Storm;
import net.elton.modifiedtornadodamage.DamageConfig;
import net.elton.modifiedtornadodamage.DamageUtil.DamageUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;

public class DestructionMethods {
    public static void UnderDestruction(LevelChunk chunk, BlockPos blockPosTop, double windEffect, float percAdj, int windfieldWidth, Level level) {
        BlockPos blockPosBelow2 = null;
        if (windEffect > 130.0) {
            int height = blockPosTop.getY() + 64;
            for (int i = 1; i < height; ++i) {
                if (PMWeather.RANDOM.nextInt(4) != 3) continue;
                BlockPos blockPosBelow = blockPosTop.below(i);
                blockPosBelow2 = null;
                if (DamageUtil.canWindAffectLight(blockPosBelow.getCenter(), level)) {
                    blockPosBelow2 = blockPosBelow;
                }
                if (windEffect > 300.0 && (DamageUtil.canWindAffectHeavy(blockPosBelow.getCenter(), level) || DamageUtil.canWindAffectLight(blockPosBelow.getCenter(), level))) {
                    blockPosBelow2 = blockPosBelow;
                }
                if (blockPosBelow2 == null) continue;
                Block blockBelow = null;
                BlockState stateBelow = chunk.getBlockState(blockPosBelow2);
                blockBelow = stateBelow.getBlock();
                float blockStrengthBelow = Storm.getBlockStrength((Block)blockBelow, (Level)level, (BlockPos)blockPosBelow2);
                if (ServerConfig.blockStrengths.containsKey(blockBelow)) {
                    blockStrengthBelow = ((Float)ServerConfig.blockStrengths.get(blockBelow)).floatValue();
                }
                if (DamageConfig.doorOpening && (stateBelow.is(BlockTags.DOORS) || stateBelow.is(BlockTags.TRAPDOORS)) && PMWeather.RANDOM.nextInt(2) == 1) {
                    if (stateBelow.is(BlockTags.MOB_INTERACTABLE_DOORS) || stateBelow.is(BlockTags.WOODEN_TRAPDOORS)) {
                        BlockState door = (BlockState)stateBelow.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(true));
                        level.setBlockAndUpdate(blockPosBelow2, door);
                        return;
                    }
                    if (windEffect >= 170.0 && !stateBelow.is(BlockTags.WOODEN_DOORS)) {
                        BlockState door = (BlockState)stateBelow.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(true));
                        level.setBlockAndUpdate(blockPosBelow2, door);
                        return;
                    }
                    if (windEffect >= 200.0 && stateBelow.is(BlockTags.TRAPDOORS) && !stateBelow.is(BlockTags.WOODEN_TRAPDOORS)) {
                        BlockState door = (BlockState)stateBelow.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(true));
                        level.setBlockAndUpdate(blockPosBelow2, door);
                        return;
                    }
                }
                double stretchBelow = 35.0;
                if (stateBelow.is(BlockTags.LEAVES)) {
                    stretchBelow = 70.0;
                } else if (stateBelow.is(BlockTags.LOGS) || stateBelow.is(BlockTags.PLANKS)) {
                    stretchBelow = 50.0;
                }
                double perChanceBelow = Math.clamp(Math.pow(Math.clamp(Math.max(windEffect - (double)blockStrengthBelow, 0.0) / stretchBelow, 0.0, 1.0), 4.0) + 0.02, 0.0, 1.0) * 0.05 * (double)percAdj;
                if (windEffect < (double)blockStrengthBelow) {
                    perChanceBelow = 0.0;
                }
                if (!(blockBelow.defaultDestroyTime() >= 0.0f) || ServerConfig.blacklistedBlocks.contains(blockBelow) || !((double)PMWeather.RANDOM.nextFloat() <= perChanceBelow)) continue;
                boolean blacklistedBelow = false;
                for (TagKey tag : ServerConfig.blacklistedBlockTags) {
                    if (!blockBelow.defaultBlockState().is(tag)) continue;
                    blacklistedBelow = true;
                    break;
                }
                if (windEffect >= (double)blockStrengthBelow && blockBelow.defaultDestroyTime() > 0.0f && !ServerConfig.blacklistedBlocks.contains(blockBelow) && !blacklistedBelow && stateBelow.getFluidState().isEmpty() && (double)PMWeather.RANDOM.nextFloat() <= perChanceBelow) {
                    level.removeBlock(blockPosBelow2, false);
                    continue;
                }
                if (!(windEffect >= (double)blockStrengthBelow) || !(blockBelow.defaultDestroyTime() > 0.0f) || ServerConfig.blacklistedBlocks.contains(blockBelow) || !blacklistedBelow || !stateBelow.getFluidState().isEmpty() || !((double)PMWeather.RANDOM.nextFloat() <= perChanceBelow)) continue;
                BlockState aboveState = chunk.getBlockState(blockPosBelow2.above());
                BlockState belowState = chunk.getBlockState(blockPosBelow2.below());
                BlockState eastState = chunk.getBlockState(blockPosBelow2.east());
                BlockState westState = chunk.getBlockState(blockPosBelow2.west());
                BlockState northState = chunk.getBlockState(blockPosBelow2.north());
                BlockState southState = chunk.getBlockState(blockPosBelow2.south());
                BlockState belowState2 = chunk.getBlockState(blockPosBelow2.below(2));
                BlockState eastState2 = chunk.getBlockState(blockPosBelow2.east(2));
                BlockState westState2 = chunk.getBlockState(blockPosBelow2.west(2));
                BlockState northState2 = chunk.getBlockState(blockPosBelow2.north(2));
                BlockState southState2 = chunk.getBlockState(blockPosBelow2.south(2));
                if (aboveState.isAir() && belowState.isAir() || southState.isAir() && northState.isAir() || eastState.isAir() && westState.isAir()) {
                    level.removeBlock(blockPosBelow2, false);
                }
                if (!(windEffect > 300.0) || !(aboveState.isAir() && belowState2.isAir() || southState2.isAir() && northState.isAir() || southState.isAir() && northState2.isAir() || eastState2.isAir() && westState.isAir()) && (!eastState.isAir() || !westState2.isAir())) continue;
                level.removeBlock(blockPosBelow2, false);
            }
        }
    }

    public static void dirtDestruction(LevelChunk chunk, BlockPos blockPosTop, double windEffect, float percAdj, int windfieldWidth, Level level) {
        BlockState state = chunk.getBlockState(blockPosTop);
        Block block = state.getBlock();
        float blockStrength = Storm.getBlockStrength((Block)block, (Level)level, (BlockPos)blockPosTop);
        if (ServerConfig.blockStrengths.containsKey(block)) {
            blockStrength = ((Float)ServerConfig.blockStrengths.get(block)).floatValue();
        }
        double stretch = 35.0;
        if (state.is(BlockTags.LEAVES)) {
            stretch = 70.0;
        } else if (state.is(BlockTags.LOGS) || state.is(BlockTags.PLANKS)) {
            stretch = 50.0;
        }
        double perChance = Math.clamp(Math.pow(Math.clamp(Math.max(windEffect - (double)blockStrength, 0.0) / stretch, 0.0, 1.0), 4.0) + 0.02, 0.0, 1.0) * 0.05 * (double)percAdj;
        if (windEffect < (double)blockStrength) {
            perChance = 0.0;
        }
        if (block.defaultDestroyTime() >= 0.0f && !ServerConfig.blacklistedBlocks.contains(block) && (double)PMWeather.RANDOM.nextFloat() <= perChance) {
            boolean blacklisted = true;
            for (TagKey tag : ServerConfig.blacklistedBlockTags) {
                if (!block.defaultBlockState().is(tag)) continue;
                blacklisted = false;
                break;
            }
            if (state.is(Blocks.DIRT) || state.is(Blocks.GRASS_BLOCK) || state.is((Block)ModBlocks.SCOURED_GRASS.get()) || state.is((Block)ModBlocks.MEDIUM_SCOURING.get()) || state.is((Block)ModBlocks.HEAVY_SCOURING.get())) {
                blacklisted = false;
            }
            if (!state.isAir() && windEffect >= (double)blockStrength && block.defaultDestroyTime() > 0.0f && !ServerConfig.blacklistedBlocks.contains(block) && !blacklisted && state.getFluidState().isEmpty() && (double)PMWeather.RANDOM.nextFloat() <= perChance && windEffect >= (double)blockStrength && block.defaultDestroyTime() > 0.0f && !ServerConfig.blacklistedBlocks.contains(block) && !blacklisted && state.getFluidState().isEmpty() && (double)PMWeather.RANDOM.nextFloat() <= perChance) {
                MovingBlock movingBlock;
                BlockState aboveState = chunk.getBlockState(blockPosTop.above());
                BlockState belowState = chunk.getBlockState(blockPosTop.below());
                BlockState eastState = chunk.getBlockState(blockPosTop.east());
                BlockState westState = chunk.getBlockState(blockPosTop.west());
                BlockState northState = chunk.getBlockState(blockPosTop.north());
                BlockState southState = chunk.getBlockState(blockPosTop.south());
                BlockState belowState2 = chunk.getBlockState(blockPosTop.below(2));
                BlockState eastState2 = chunk.getBlockState(blockPosTop.east(2));
                BlockState westState2 = chunk.getBlockState(blockPosTop.west(2));
                BlockState northState2 = chunk.getBlockState(blockPosTop.north(2));
                BlockState southState2 = chunk.getBlockState(blockPosTop.south(2));
                if ((aboveState.isAir() && belowState.isAir() || southState.isAir() && northState.isAir() || eastState.isAir() && westState.isAir()) && (movingBlock = (MovingBlock)((EntityType)ModEntities.MOVING_BLOCK.get()).create(level)) != null) {
                    movingBlock.setStartPos(blockPosTop);
                    movingBlock.setBlockState(state);
                    movingBlock.setPos((double)blockPosTop.getX(), (double)blockPosTop.getY(), (double)blockPosTop.getZ());
                    level.removeBlock(blockPosTop, false);
                    Player nearest = level.getNearestPlayer((double)blockPosTop.getX(), (double)blockPosTop.getY(), (double)blockPosTop.getZ(), 128.0, false);
                    if (PMWeather.RANDOM.nextInt(Math.max(1, windfieldWidth / 10)) == 0 && nearest != null && nearest.position().distanceTo(blockPosTop.getCenter()) < 128.0) {
                        if (level.isLoaded(blockPosTop)) {
                            level.addFreshEntity((Entity)movingBlock);
                        } else {
                            movingBlock.discard();
                        }
                    } else {
                        movingBlock.discard();
                    }
                }
                if (windEffect > 300.0 && (aboveState.isAir() && belowState2.isAir() || southState2.isAir() && northState.isAir() || southState.isAir() && northState2.isAir() || eastState2.isAir() && westState.isAir() || eastState.isAir() && westState2.isAir())) {
                    level.removeBlock(blockPosTop, false);
                }
            }
        }
    }
}

