/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.mobxp.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import games.polarbearbytes.mobxp.MobXP;
import games.polarbearbytes.mobxp.config.MobXPConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "mobxp.json");
    private static MobXPConfig config = null;

    public static void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            config = new MobXPConfig();
            ConfigManager.saveConfig();
        } else {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (MobXPConfig)GSON.fromJson((Reader)reader, MobXPConfig.class);
            }
            catch (IOException e) {
                MobXP.LOGGER.error(e.getMessage());
                config = new MobXPConfig();
            }
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            MobXP.LOGGER.warn(e.getMessage());
        }
    }

    public static MobXPConfig getConfig() {
        if (config == null) {
            ConfigManager.loadConfig();
        }
        return config;
    }
}

