/*
 * Decompiled with CFR 0.152.
 */
package org.midar1000.falls;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="falls")
public class Falls {
    public static final String MODID = "falls";
    private static final Minecraft mc = Minecraft.getInstance();
    private static final Random random = new Random();
    private static final List<FallingImage> fallingObjects = new ArrayList<FallingImage>();
    private static final List<ResourceLocation> textures = new ArrayList<ResourceLocation>();

    public Falls(IEventBus modEventBus) {
        modEventBus.addListener(this::onClientSetup);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        this.loadTextures();
        NeoForge.EVENT_BUS.addListener(this::onRenderGui);
    }

    private void onRenderGui(ScreenEvent.Render.Post event) {
        int screenWidth = event.getScreen().width;
        int screenHeight = event.getScreen().height;
        float spawnChance = 0.03f;
        if (event.getScreen() instanceof TitleScreen) {
            spawnChance = 0.12f;
        } else if (event.getScreen() instanceof AbstractContainerScreen) {
            spawnChance = 0.02f;
        }
        if (!textures.isEmpty() && random.nextFloat() < spawnChance) {
            ResourceLocation texture = textures.get(random.nextInt(textures.size()));
            float x = random.nextInt(screenWidth);
            float speed = event.getScreen() instanceof AbstractContainerScreen ? 0.15f + random.nextFloat() * 0.3f : 0.5f + random.nextFloat() * 1.5f;
            float scale = 0.8f + random.nextFloat() * 0.4f;
            fallingObjects.add(new FallingImage(texture, x, -20.0f, speed, scale));
        }
        double mouseX = Falls.mc.mouseHandler.xpos() / mc.getWindow().getGuiScale();
        double mouseY = Falls.mc.mouseHandler.ypos() / mc.getWindow().getGuiScale();
        Iterator<FallingImage> iterator = fallingObjects.iterator();
        while (iterator.hasNext()) {
            double maxRadius;
            FallingImage obj = iterator.next();
            obj.update();
            if (obj.y > (float)(screenHeight + 40)) {
                iterator.remove();
                continue;
            }
            double dx = (double)obj.x - mouseX;
            double dy = (double)obj.y - mouseY;
            double dist = Math.sqrt(dx * dx + dy * dy);
            if (dist < (maxRadius = 30.0) && dist > 1.0E-4) {
                double strength = (1.0 - dist / maxRadius) * 6.0;
                obj.x = (float)((double)obj.x + dx / dist * strength);
                obj.y = (float)((double)obj.y + dy / dist * strength);
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)obj.texture);
            int size = Math.round(16.0f * obj.scale);
            if (size > 24) {
                size = 24;
            }
            event.getGuiGraphics().blit(obj.texture, (int)obj.x, (int)obj.y, 0.0f, 0.0f, size, size, size, size);
        }
    }

    private void loadTextures() {
        try {
            String path = "/assets/falls/textures/gui/falling/";
            URL url = this.getClass().getResource(path);
            if (url != null) {
                Path dir = Paths.get(url.toURI());
                List files = Files.list(dir).map(p -> p.getFileName().toString()).filter(name -> name.endsWith(".png")).collect(Collectors.toList());
                for (String file : files) {
                    textures.add(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)("textures/gui/falling/" + file)));
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static class FallingImage {
        ResourceLocation texture;
        float x;
        float y;
        float speed;
        float time;
        float scale;
        float angle;

        public FallingImage(ResourceLocation texture, float x, float y, float speed, float scale) {
            this.texture = texture;
            this.x = x;
            this.y = y;
            this.speed = speed;
            this.scale = scale;
            this.time = 0.0f;
            this.angle = random.nextFloat() * 360.0f;
        }

        public void update() {
            this.y += this.speed;
            this.time += 0.05f;
            this.x += (float)Math.sin(this.time) * 0.5f;
            this.angle += 0.8f;
        }
    }
}

