/*
 * Decompiled with CFR 0.152.
 */
package com.draconicarcher.extremehordemoon;

import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="extremehordemoon")
public class Extremehordemoon {
    public Extremehordemoon() {
        MinecraftForge.EVENT_BUS.addListener(this::onZombieSpawn);
    }

    private void onZombieSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        if (!(mob instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)mob;
        if (event.getSpawnType() != MobSpawnType.NATURAL) {
            return;
        }
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (!(serverLevelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)serverLevelAccessor;
        try {
            Optional dataOpt = EnhancedCelestials.lunarForecastWorldData((Level)serverLevel);
            if (dataOpt.isEmpty()) {
                return;
            }
            EnhancedCelestialsLunarForecastWorldData data = (EnhancedCelestialsLunarForecastWorldData)dataOpt.get();
            LunarEvent currentEvent = data.currentLunarEvent();
            if (currentEvent == null) {
                return;
            }
            Holder holder = data.currentLunarEventHolder();
            ResourceKey eventKey = holder.m_203543_().orElse(null);
            if (eventKey == null) {
                return;
            }
            ResourceLocation id = eventKey.m_135782_();
            if (id.equals((Object)new ResourceLocation("enhancedcelestials", "extreme_zombie_moon"))) {
                zombie.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
                zombie.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
                zombie.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
                zombie.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
                zombie.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
            }
        }
        catch (Exception e) {
            System.out.println("ZombieMoon: could not check lunar event: " + e);
        }
    }
}

