/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.chatshot.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;

public class Config {
    private static final File configFile = new File("./config/chatshot.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static Config INSTANCE = Config.load();
    public boolean shadow = false;
    public int scale = 2;
    public boolean tooltip = true;
    public CopyType clickAction = CopyType.TEXT;
    public CopyType shiftClickAction = CopyType.IMAGE;
    public boolean saveImage = true;
    public boolean showCopyMessage = true;

    public static void save() {
        if (INSTANCE == null) {
            return;
        }
        try {
            String json = GSON.toJson((Object)INSTANCE);
            FileUtils.write((File)configFile, (CharSequence)json, (Charset)null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Config load() {
        if (!configFile.exists()) {
            return new Config();
        }
        try {
            String json = FileUtils.readFileToString((File)configFile, (Charset)null);
            return (Config)GSON.fromJson(json, Config.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Config();
        }
    }

    public static enum CopyType {
        TEXT,
        IMAGE;

    }
}

