/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.chatshot.mixins;

import dev.dediamondpro.chatshot.compat.CompatCore;
import dev.dediamondpro.chatshot.config.Config;
import dev.dediamondpro.chatshot.data.ChatHudLocals;
import dev.dediamondpro.chatshot.mixins.ChatHudAccessor;
import dev.dediamondpro.chatshot.util.ChatCopyUtil;
import dev.dediamondpro.chatshot.util.Textures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
public abstract class ChatScreenMixin
extends Screen {
    @Unique
    private boolean mouseClicked = false;

    protected ChatScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")})
    void onDraw(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.drawLineButton(context, mouseX, mouseY);
        this.drawScreenshotButton(context, mouseX, mouseY);
        this.mouseClicked = false;
    }

    @Unique
    private void drawLineButton(GuiGraphics context, int mouseX, int mouseY) {
        ChatComponent chatHud = this.getChatHud();
        ChatHudAccessor chatHudA = this.getChatHudA();
        ChatHudLocals chatHudL = (ChatHudLocals)chatHud;
        float chatScale = (float)chatHud.getScale();
        int chatLineY = (int)chatHudA.toChatLineYA(mouseY);
        int messageIndex = chatHudA.getMessageIndexA(0.0, chatLineY);
        int buttonX = (int)((float)chatHud.getWidth() + 14.0f * chatScale);
        if (messageIndex == -1 || (float)mouseX > (float)buttonX + 14.0f * chatScale) {
            return;
        }
        int color = chatHudL.chatShot$getChatBackgroundColor();
        int chatY = chatHudL.chatShot$getChatY();
        if (chatY == -1) {
            chatY = (int)((float)(this.height - 40) / chatScale);
            color = (int)((Double)this.minecraft.options.textBackgroundOpacity().get() * 255.0) << 24;
        }
        int buttonSize = (int)(9.0f * chatScale);
        int lineHeight = chatHudA.getLineHeightA();
        int scaledButtonX = (int)((float)chatHud.getWidth() / chatScale + 14.0f);
        int scaledButtonY = chatY - (chatLineY + 1) * lineHeight + (int)Math.ceil((double)(lineHeight - 9) / 2.0);
        float buttonY = (float)scaledButtonY * chatScale;
        boolean hovering = mouseX >= buttonX && mouseX <= buttonX + buttonSize && (float)mouseY >= buttonY && (float)mouseY <= buttonY + (float)buttonSize;
        context.pose().pushPose();
        context.pose().scale(chatScale, chatScale, 1.0f);
        context.fill(scaledButtonX, scaledButtonY, scaledButtonX + 9, scaledButtonY + 9, hovering ? 0xFFFFFF | color : color);
        context.blit(RenderType::guiTextured, Textures.COPY, scaledButtonX, scaledButtonY, 0.0f, 0.0f, 9, 9, 9, 9);
        context.pose().popPose();
        if (hovering && Config.INSTANCE.tooltip) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"chatshot.copy"));
            tooltip.add(Component.translatable((String)("chatshot.click" + (Config.INSTANCE.clickAction == Config.CopyType.TEXT ? "Text" : "Image"))));
            tooltip.add(Component.translatable((String)("chatshot.shiftClick" + (Config.INSTANCE.shiftClickAction == Config.CopyType.TEXT ? "Text" : "Image"))));
            context.renderComponentTooltip(this.minecraft.font, tooltip, mouseX, mouseY);
        }
        if (hovering && this.mouseClicked) {
            context.flush();
            List<GuiMessage.Line> visibleMessages = chatHudA.getVisibleMessages();
            ArrayList<GuiMessage.Line> messageParts = new ArrayList<GuiMessage.Line>();
            messageParts.add(visibleMessages.get(messageIndex));
            for (int i = messageIndex + 1; i < visibleMessages.size() && !visibleMessages.get(i).endOfEntry(); ++i) {
                messageParts.addFirst(visibleMessages.get(i));
            }
            if (messageParts.isEmpty()) {
                return;
            }
            ChatCopyUtil.copy(messageParts, this.minecraft);
        }
    }

    @Unique
    private void drawScreenshotButton(GuiGraphics context, int mouseX, int mouseY) {
        int buttonX = this.width - 12 - CompatCore.INSTANCE.getButtonOffset();
        int buttonY = this.height - 26;
        boolean hovering = mouseX >= buttonX && mouseX <= buttonX + 10 && mouseY >= buttonY && mouseY <= buttonY + 10;
        int color = this.minecraft.options.getBackgroundColor(Integer.MIN_VALUE);
        context.fill(buttonX, buttonY, buttonX + 10, buttonY + 10, hovering ? 0xFFFFFF + color : color);
        context.blit(RenderType::guiTextured, Textures.SCREENSHOT, buttonX, buttonY, 0.0f, 0.0f, 10, 10, 10, 10);
        if (hovering && Config.INSTANCE.tooltip) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"chatshot.copy"));
            tooltip.add(Component.translatable((String)"chatshot.clickImage"));
            context.renderComponentTooltip(this.minecraft.font, tooltip, mouseX, mouseY);
        }
        if (this.mouseClicked && hovering) {
            context.flush();
            ArrayList<GuiMessage.Line> lines = new ArrayList<GuiMessage.Line>();
            int scrolledLines = this.getChatHudA().getScrolledLines();
            List<GuiMessage.Line> visibleMessages = this.getChatHudA().getVisibleMessages();
            for (int i = scrolledLines; i < visibleMessages.size() && i < this.getChatHud().getLinesPerPage() + scrolledLines; ++i) {
                lines.add(0, visibleMessages.get(i));
            }
            ChatCopyUtil.copyImage(lines, this.minecraft);
        }
    }

    @Inject(method={"mouseClicked(DDI)Z"}, at={@At(value="HEAD")})
    void onMouseClick(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (button != 0) {
            return;
        }
        this.mouseClicked = true;
    }

    @Unique
    private ChatComponent getChatHud() {
        return this.minecraft.gui.getChat();
    }

    @Unique
    private ChatHudAccessor getChatHudA() {
        return (ChatHudAccessor)this.getChatHud();
    }
}

