/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.chatshot.mixins;

import dev.dediamondpro.chatshot.compat.CompatCore;
import dev.dediamondpro.chatshot.config.Config;
import dev.dediamondpro.chatshot.data.ChatHudLocals;
import dev.dediamondpro.chatshot.mixins.ChatHudAccessor;
import dev.dediamondpro.chatshot.util.ChatCopyUtil;
import dev.dediamondpro.chatshot.util.Textures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_303;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_408.class})
public abstract class ChatScreenMixin
extends class_437 {
    @Unique
    private boolean mouseClicked = false;

    protected ChatScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    void onDraw(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.drawLineButton(context, mouseX, mouseY);
        this.drawScreenshotButton(context, mouseX, mouseY);
        this.mouseClicked = false;
    }

    @Unique
    private void drawLineButton(class_332 context, int mouseX, int mouseY) {
        class_338 chatHud = this.getChatHud();
        ChatHudAccessor chatHudA = this.getChatHudA();
        ChatHudLocals chatHudL = (ChatHudLocals)chatHud;
        float chatScale = (float)chatHud.method_1814();
        int chatLineY = (int)chatHudA.toChatLineYA(mouseY);
        int messageIndex = chatHudA.getMessageIndexA(0.0, chatLineY);
        int buttonX = (int)((float)chatHud.method_1811() + 14.0f * chatScale);
        if (messageIndex == -1 || (float)mouseX > (float)buttonX + 14.0f * chatScale) {
            return;
        }
        int color = chatHudL.chatShot$getChatBackgroundColor();
        int chatY = chatHudL.chatShot$getChatY();
        if (chatY == -1) {
            chatY = (int)((float)(this.field_22790 - 40) / chatScale);
            color = (int)((Double)this.field_22787.field_1690.method_42550().method_41753() * 255.0) << 24;
        }
        int buttonSize = (int)(9.0f * chatScale);
        int lineHeight = chatHudA.getLineHeightA();
        int scaledButtonX = (int)((float)chatHud.method_1811() / chatScale + 14.0f);
        int scaledButtonY = chatY - (chatLineY + 1) * lineHeight + (int)Math.ceil((double)(lineHeight - 9) / 2.0);
        float buttonY = (float)scaledButtonY * chatScale;
        boolean hovering = mouseX >= buttonX && mouseX <= buttonX + buttonSize && (float)mouseY >= buttonY && (float)mouseY <= buttonY + (float)buttonSize;
        context.method_51448().method_22903();
        context.method_51448().method_22905(chatScale, chatScale, 1.0f);
        context.method_25294(scaledButtonX, scaledButtonY, scaledButtonX + 9, scaledButtonY + 9, hovering ? 0xFFFFFF | color : color);
        context.method_25290(class_1921::method_62277, Textures.COPY, scaledButtonX, scaledButtonY, 0.0f, 0.0f, 9, 9, 9, 9);
        context.method_51448().method_22909();
        if (hovering && Config.INSTANCE.tooltip) {
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            tooltip.add(class_2561.method_43471((String)"chatshot.copy"));
            tooltip.add(class_2561.method_43471((String)("chatshot.click" + (Config.INSTANCE.clickAction == Config.CopyType.TEXT ? "Text" : "Image"))));
            tooltip.add(class_2561.method_43471((String)("chatshot.shiftClick" + (Config.INSTANCE.shiftClickAction == Config.CopyType.TEXT ? "Text" : "Image"))));
            context.method_51434(this.field_22787.field_1772, tooltip, mouseX, mouseY);
        }
        if (hovering && this.mouseClicked) {
            context.method_51452();
            List<class_303.class_7590> visibleMessages = chatHudA.getVisibleMessages();
            ArrayList<class_303.class_7590> messageParts = new ArrayList<class_303.class_7590>();
            messageParts.add(visibleMessages.get(messageIndex));
            for (int i = messageIndex + 1; i < visibleMessages.size() && !visibleMessages.get(i).comp_898(); ++i) {
                messageParts.addFirst(visibleMessages.get(i));
            }
            if (messageParts.isEmpty()) {
                return;
            }
            ChatCopyUtil.copy(messageParts, chatHudL.chatshot$getMessageForLine(chatLineY), this.field_22787);
        }
    }

    @Unique
    private void drawScreenshotButton(class_332 context, int mouseX, int mouseY) {
        int buttonX = this.field_22789 - 12 - CompatCore.INSTANCE.getButtonOffset();
        int buttonY = this.field_22790 - 26;
        boolean hovering = mouseX >= buttonX && mouseX <= buttonX + 10 && mouseY >= buttonY && mouseY <= buttonY + 10;
        int color = this.field_22787.field_1690.method_19344(Integer.MIN_VALUE);
        context.method_25294(buttonX, buttonY, buttonX + 10, buttonY + 10, hovering ? 0xFFFFFF + color : color);
        context.method_25290(class_1921::method_62277, Textures.SCREENSHOT, buttonX, buttonY, 0.0f, 0.0f, 10, 10, 10, 10);
        if (hovering && Config.INSTANCE.tooltip) {
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            tooltip.add(class_2561.method_43471((String)"chatshot.copy"));
            tooltip.add(class_2561.method_43471((String)"chatshot.clickImage"));
            context.method_51434(this.field_22787.field_1772, tooltip, mouseX, mouseY);
        }
        if (this.mouseClicked && hovering) {
            context.method_51452();
            ArrayList<class_303.class_7590> lines = new ArrayList<class_303.class_7590>();
            int scrolledLines = this.getChatHudA().getScrolledLines();
            List<class_303.class_7590> visibleMessages = this.getChatHudA().getVisibleMessages();
            for (int i = scrolledLines; i < visibleMessages.size() && i < this.getChatHud().method_1813() + scrolledLines; ++i) {
                lines.addFirst(visibleMessages.get(i));
            }
            ChatCopyUtil.copyImage(lines, this.field_22787);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")})
    void onMouseClick(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (button != 0) {
            return;
        }
        this.mouseClicked = true;
    }

    @Unique
    private class_338 getChatHud() {
        return this.field_22787.field_1705.method_1743();
    }

    @Unique
    private ChatHudAccessor getChatHudA() {
        return (ChatHudAccessor)this.getChatHud();
    }
}

