/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.chatshot.util;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import dev.dediamondpro.chatshot.compat.CompatCore;
import dev.dediamondpro.chatshot.config.Config;
import dev.dediamondpro.chatshot.util.CollectingCharacterVisitor;
import dev.dediamondpro.chatshot.util.clipboard.ClipboardUtil;
import dev.dediamondpro.chatshot.util.clipboard.MacOSCompat;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMaps;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.SequencedMap;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5224;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6367;
import net.minecraft.class_6417;
import net.minecraft.class_9799;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public class ChatCopyUtil {
    public static Function<class_276, class_1921> CUSTOM_TEXT_LAYER = rt -> class_1921.method_24049((String)"chatshot_text", (int)786432, (boolean)false, (boolean)false, (RenderPipeline)class_10799.field_56818, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(class_4668.field_21378).method_23610(new class_4668.class_4678("chatshot_fbo", () -> rt)).method_23608(class_4668.field_21383).method_23617(false));

    public static void copy(List<class_303.class_7590> lines, class_2561 fullMessage, class_310 client) {
        if (GLFW.glfwGetKey((long)client.method_22683().method_4490(), (int)340) == 1 || GLFW.glfwGetKey((long)client.method_22683().method_4490(), (int)344) == 1) {
            if (Config.INSTANCE.shiftClickAction == Config.CopyType.TEXT) {
                ChatCopyUtil.copyString(lines, fullMessage, client);
            } else {
                ChatCopyUtil.copyImage(lines, client);
            }
        } else if (Config.INSTANCE.clickAction == Config.CopyType.TEXT) {
            ChatCopyUtil.copyString(lines, fullMessage, client);
        } else {
            ChatCopyUtil.copyImage(lines, client);
        }
    }

    public static void copyString(List<class_303.class_7590> lines, class_2561 fullMessage, class_310 client) {
        String clipboardString;
        if (fullMessage == null) {
            CollectingCharacterVisitor visitor = new CollectingCharacterVisitor();
            for (class_303.class_7590 line : lines) {
                line.comp_896().accept((class_5224)visitor);
            }
            clipboardString = visitor.collect();
        } else {
            clipboardString = fullMessage.getString();
        }
        client.field_1774.method_1455(clipboardString);
        if (Config.INSTANCE.showCopyMessage) {
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"chatshot.text.success"));
        }
    }

    public static void copyImage(List<class_303.class_7590> lines, class_310 client) {
        class_6367 rt;
        boolean shadow = Config.INSTANCE.shadow;
        int scaleFactor = Config.INSTANCE.scale;
        CompatCore.INSTANCE.drawChatHud();
        int width = 0;
        for (class_303.class_7590 line : lines) {
            class_5481 content = line.comp_896();
            width = Math.max(width, client.field_1772.method_30880(content));
        }
        int height = lines.size() * 9;
        GpuDevice device = RenderSystem.getDevice();
        CommandEncoder cmd = device.createCommandEncoder();
        try {
            rt = new class_6367(null, width * scaleFactor, height * scaleFactor, false);
        }
        catch (IllegalArgumentException e) {
            client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"chatshot.noMessageFound"));
            return;
        }
        OverrideVertexProvider customConsumer = new OverrideVertexProvider(new class_9799(256), (class_276)rt);
        class_332 context = new class_332(client, (class_4597.class_4598)customConsumer);
        cmd.clearColorTexture(rt.method_30277(), 0);
        context.method_51448().method_22905((float)client.method_22683().method_4486() / (float)width, (float)client.method_22683().method_4502() / (float)height, 1.0f);
        int y = 0;
        for (class_303.class_7590 line : lines) {
            context.method_51430(client.field_1772, line.comp_896(), 0, y, -1, shadow);
            y += 9;
        }
        CompatCore.INSTANCE.drawChatHud();
        context.method_51452();
        customConsumer.finishDrawing();
        ChatCopyUtil.saveImage((class_276)rt, client);
    }

    private static void saveImage(class_276 rt, class_310 client) {
        int i = rt.field_1482;
        int j = rt.field_1481;
        GpuTexture gpuTexture = rt.method_30277();
        GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(null, BufferType.PIXEL_PACK, BufferUsage.STATIC_READ, rt.field_1482 * rt.field_1481 * rt.method_30277().getFormat().pixelSize());
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        RenderSystem.getDevice().createCommandEncoder().copyTextureToBuffer(gpuTexture, gpuBuffer, 0, () -> {
            try (GpuBuffer.ReadView readView = commandEncoder.readBuffer(gpuBuffer);
                 class_1011 nativeImage = new class_1011(i, j, false);){
                for (int k = 0; k < j; ++k) {
                    for (int l = 0; l < i; ++l) {
                        int m = readView.data().getInt((l + k * i) * gpuTexture.getFormat().pixelSize());
                        nativeImage.method_4305(l, j - k - 1, m);
                    }
                }
                try {
                    boolean copySuccessful = false;
                    if (Config.INSTANCE.saveImage || class_6417.field_52734) {
                        File screenShotDir = new File("screenshots/chat");
                        screenShotDir.mkdirs();
                        File screenshotFile = ChatCopyUtil.getScreenshotFilename(screenShotDir);
                        nativeImage.method_4325(screenshotFile);
                        if (class_6417.field_52734) {
                            copySuccessful = MacOSCompat.doCopyMacOS(screenshotFile.getAbsolutePath());
                            if (!Config.INSTANCE.saveImage) {
                                screenshotFile.delete();
                            }
                        }
                    }
                    if (!class_6417.field_52734) {
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        WritableByteChannel writableChannel = Channels.newChannel(outputStream);
                        nativeImage.method_24032(writableChannel);
                        writableChannel.close();
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                        BufferedImage image = ImageIO.read(inputStream);
                        copySuccessful = ClipboardUtil.copy(image);
                    }
                    class_5250 message = null;
                    if (copySuccessful) {
                        if (Config.INSTANCE.showCopyMessage) {
                            message = class_2561.method_43471((String)"chatshot.image.success");
                        }
                    } else {
                        message = class_2561.method_43471((String)"chatshot.image.fail");
                    }
                    if (message != null) {
                        client.field_1705.method_1743().method_1812((class_2561)message);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            finally {
                gpuBuffer.close();
                rt.method_1238();
            }
        }, 0);
    }

    private static File getScreenshotFilename(File directory) {
        File file;
        String string = class_156.method_44893();
        int i = 1;
        while ((file = new File(directory, string + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file;
    }

    public static class OverrideVertexProvider
    extends class_4597.class_4598 {
        private final class_1921 currentLayer;
        public class_287 bufferBuilder;

        private OverrideVertexProvider(class_9799 bufferAllocator, class_276 rt) {
            super(bufferAllocator, (SequencedMap)Object2ObjectSortedMaps.emptyMap());
            this.currentLayer = CUSTOM_TEXT_LAYER.apply(rt);
            this.bufferBuilder = new class_287(this.field_52156, this.currentLayer.method_23033(), this.currentLayer.method_23031());
        }

        @NotNull
        public class_4588 getBuffer(class_1921 renderType) {
            return this.bufferBuilder;
        }

        public void finishDrawing() {
            this.field_52157.put(this.currentLayer, this.bufferBuilder);
            this.method_22994(this.currentLayer);
        }
    }
}

