/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.ping.client;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.anvilcraft.ping.network.PingPayload;
import dev.anvilcraft.ping.util.Ping;
import dev.anvilcraft.ping.util.PingType;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.common.Mod;

@Mod(value="middle_key_ping", dist={Dist.CLIENT})
public class MiddleKeyPingClient {
    public static final Multimap<ResourceKey<Level>, Ping> PINGS = MultimapBuilder.hashKeys().arrayListValues().build();

    public static void handle(PingPayload payload) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            return;
        }
        long gameTime = client.level.getGameTime();
        Collection pings = PINGS.get(payload.dimension());
        if (pings.size() > 5) {
            pings.remove(pings.stream().findFirst().get());
        }
        PINGS.put(payload.dimension(), (Object)new Ping(payload, gameTime + 300L));
        SoundEvent event = switch (payload.pingType()) {
            case PingType.GOTO -> (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value();
            case PingType.WARNING -> (SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value();
            case PingType.ENEMY -> (SoundEvent)SoundEvents.NOTE_BLOCK_BIT.value();
            default -> (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value();
        };
        client.level.playLocalSound((Entity)client.player, event, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

