/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.ping.network;

import dev.anvilcraft.ping.MiddleKeyPing;
import dev.anvilcraft.ping.client.MiddleKeyPingClient;
import dev.anvilcraft.ping.util.ByteBufCodecUtils;
import dev.anvilcraft.ping.util.PingType;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public record PingPayload(ResourceKey<Level> dimension, Vec3 position, PingType pingType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PingPayload> TYPE = new CustomPacketPayload.Type(MiddleKeyPing.of("inspection_state"));
    public static final StreamCodec<ByteBuf, PingPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), PingPayload::dimension, ByteBufCodecUtils.VEC3, PingPayload::position, ByteBufCodecUtils.enumCodec(PingType.class), PingPayload::pingType, PingPayload::new);
    public static final IPayloadHandler<PingPayload> HANDLER = new DirectionalPayloadHandler(PingPayload::clientHandler, PingPayload::serverHandler);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void clientHandler(IPayloadContext context) {
        context.enqueueWork(() -> MiddleKeyPingClient.handle(this));
    }

    public void serverHandler(IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        context.enqueueWork(() -> {
            MinecraftServer server = player.getServer();
            if (server == null) {
                return;
            }
            List players = server.getPlayerList().getPlayers();
            for (ServerPlayer other : players) {
                ResourceKey dimension1;
                PlayerTeam team = player.getTeam();
                PlayerTeam team1 = other.getTeam();
                if (team != null && !team.equals(team1)) {
                    return;
                }
                ResourceKey dimension = player.level().dimension();
                if (!dimension.equals(dimension1 = other.level().dimension())) {
                    return;
                }
                other.connection.send((CustomPacketPayload)new PingPayload(this.dimension, this.position, this.pingType));
                other.sendSystemMessage((Component)Component.translatable((String)this.pingType.description(), (Object[])new Object[]{Component.translatable((String)"chat.middle_key_ping.player", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.WHITE)}).withColor(this.pingType.color()));
            }
        });
    }
}

